
/* SAMSON */

#ifndef _vstruct_h
#define _vstruct_h 1
#include "vcx_utls.h"
/* 
	SAMSON

   General structures for additional rtl vcx peripherals


	*/

#define DEVICE_HAS_VCX (dx_var->vd_type->contains_vcx_periphs)

#define		VCX_SET_PMB_SIG(SIG,V)	 	       w1w(*pmb,SIG,V)
#define		VCX_GET_PMB_SIG(SIG)	   	       r1w(*pmb,SIG)
#define		VCX_SET_PMB_BIT(SIG,BIT,V)	       w1bc(pmb[SIG],BIT,V)
#define		VCX_GET_PMB_BIT(SIG,BIT)	       r1bc(pmb[SIG],BIT)
#define     VCX_SET_PMB_RANGE(SIG,MSB,LSB,V)  w1(pmb[SIG],MSB,LSB,V)
#define     VCX_GET_PMB_RANGE(SIG,MSB,LSB)    r1(pmb[SIG],MSB,LSB)


/* defines for the logic_info function types */
#define CORE_ADDR_DECODE 1
#define DMA_ADDR_DECODE  2

typedef ints01 vcx_sig;


/* for each RTL peripheral type */
struct vperiph_type
{
  /* pointer to function to initialize peripheral */
  void (*initialize)( vcx_sig* , unsigned int);

  /* pointer to function for time slot T0 positive edge */
  void (*t0_pos_edge)(vcx_sig*, unsigned int);

  /* pointer to function for time slot T0 negative edge */
  void (*t0_neg_edge)(vcx_sig*, unsigned int);

  /* pointer to function for time slot T1 positive edge */
  void (*t1_pos_edge)(vcx_sig*, unsigned int);

  /* pointer to function for time slot T1 negative edge */
  void (*t1_neg_edge)(vcx_sig*, unsigned int);

  /* pointer to function for module termination - memory deallocations etc. */
  void (*terminate)(unsigned int);

  /* pointer to function for peripheral reset */
  void (*reset)(vcx_sig*, unsigned int);

  /* return TRUE iff the given address is in
	  the peripheral memory space 0-X, 1-Y */
  int (*in_my_space)(unsigned int, unsigned long,unsigned int);
};


/* wiring information between the peripheral and the PMB */
struct wire_info
{
  int source_offset;    /* source signal offset in VCX array */
  int source_start_bit; /* source signal start bit */
  int source_end_bit;   /* source signal end bit */

  int dest_offset;    /* dest signal offset in VCX array */
  int dest_start_bit; /* dest signal start bit */
  int dest_end_bit;   /* dest signal end bit */
};

/* consts via programming information */
struct const_info
{
  int signal_offset;    /* signal offset in VCX array */
  int signal_start_bit; /* signal start bit */
  int signal_end_bit;   /* signal end bit */
  unsigned long value;  /* const via program value */
};

/* logic function information */
struct logic_info
{
  int function_type;    /* can be CORE_ADDR_DECODE or DMA_ADDR_DECODE or ... */
  int signal_offset;    /* signal offset in VCX array */
  int signal_start_bit; /* signal start bit */
  int signal_end_bit;   /* signal end bit */
  unsigned long parameter;  /* function parameter */
};

/* for each RTL peripheral instance */
struct vperiph_info
{
  struct wire_info* inputs;
  int inputs_number;
  struct wire_info* outputs;
  int outputs_number;
  struct const_info* consts;
  int consts_number;
  struct logic_info* logics;
  int logics_number;

};


/* for each device type */
struct vdevice_type
{
  int contains_vcx_periphs; /* TRUE iff the device contains VCXed peripherals */
  unsigned int prescaler_index;  /* The index of the prescaler peripheral */
  unsigned int pmb_size;     /* the size of the pmb signals array */
};


/* for each device instance */
struct vdevice_inst
{

  vcx_sig *pmb;            /* array of PMB signals */
  int late_fetch;
  unsigned long prev_mdrqn;
  unsigned long last_driven_gdb;

};
  


#endif








