#ifndef	__simusr_h__
#define __simusr_h__
#if FULLSIM

#include "hostio.h"

#include "rgsim.h"
#include "rgcom.h"
#define  DSP_FULLINE		80
#define  DSP_CTRLC			0x03

/*
   *    codes for keyboard input..
 */

#define  DSP_CURL        12	/* ctrl-l */
#define  DSP_CURR        18	/* ctrl-r */
#define  DSP_DELB  		8	/* ctrl-h */
#if ADSx
#define  DSP_DELEOL      1	/* ctrl-A */
#else
#define  DSP_DELEOL      26	/* ctrl-Z */
#endif
#define  DSP_DELF        11	/* ctrl-k */
#define  DSP_ESCAPE      27	/* ESC    */
#define  DSP_INSERT      15	/* ctrl-o */
#define  DSP_LINED       14	/* ctrl-n */
#define  DSP_LINEU       21	/* ctrl-u */
#define  DSP_MOVEEOL     5	/* ctrl-e */
#define  DSP_CTRLB       2	/* ctrl-f */
#define  DSP_CTRLF       6	/* ctrl-f */
#define  DSP_TABR        9	/* ctrl-i */
#define  DSP_PAGED       22	/* ctrl-v */
#define  DSP_WINDOW	 	23	/* ctrl-w */
#define  DSP_CTRLX	 	24	/* ctrl-x */
#define  DSP_CTRLQ	 	17	/* ctrl-q */
#define  DSP_CTRLS	 	19	/* ctrl-s */
#define  DSP_PAGEU       20	/* ctrl-t */
#define  DSP_REFRESH     128	/* macintosh refresh screen flag */
#define  DSP_MACFILE	 129	/* macintosh filename string entered */

#define  DSP_CR			   0x0d		/* ctrl-m */
#define  DSP_SPACE			0x20

#define DSP_WRIT_BRK 1		/* WRITE IO FILE BREAK MEMORY FLAG BIT */
#define DSP_READ_BRK 2		/* READ IO FILE BREAK MEMORY FLAG BIT */

#define DSP_IO_MEMORY 0		/* IO FILE GROUPS */
#define DSP_IO_PERIPH 1
#define DSP_IO_PORT 2
#define DSP_IO_PIN 3
#define DSP_IO_PINGROUP 4
#define DSP_IO_PINTOPIN 5
#define DSP_IO_HISTORY 6
#define DSP_IO_MEMTOMEM 7
#define DSP_IO_APIN 8		/* analog io pin */
#define DSP_IO_REGISTER 9       /* displayed register */
#define DSP_IO_INTREG 10	/* internal register */
#define DSP_IO_PULLUPPIN 11     /* pin connected to a positive voltage via a pull-up resistor */

/* values of stat.radix */
#define  DSP_BINARY      0
#define  DSP_DECIMAL     1
#define  DSP_FRACTIONAL  2
#define  DSP_FLOAT       2
#define  DSP_HEX         3
#define  DSP_UNSIGNED    4

/* Values for st_command.dev_flag */
#define  DSP_DEV_PASS    0
#define  DSP_DEV_NUM     1
#define  DSP_DEV_LIST    2

enum display_modes { REG_DISPLAY,    /* register (standard) display */
                     ASM_DISPLAY,    /* assembly display */
                     SRC_DISPLAY };  /* source display */

struct sev_mac
{
    char macfn[DSP_LINE_LEN];	/* macro filename */
    long macpos;		/* position in file */
    struct sev_mac *macprev;	/* pointer to previous macro on stack */
};

struct sev_line
{
    char lbuf[DSP_LINE_LEN];	/* line buffer */
};

struct sev_window
{				/* VIRTUAL SCREEN POINTERS */
    int next,
     head;
    struct sev_line *dbuf;
};

struct sev_nest
{
    long neststadd;		/* start of loop position in file 0=not defined */
    long nestspadd;		/* end of loop flag 0=not defined  1=defined */
    long nestrep;		/* nest repeat count 0=undefined -1=forever */
    struct sev_nest *nestnext;	/* further nesting of loop */
};

struct sev_iolist
{
    char iofn[DSP_LINE_LEN];	/* io file name */
    char ioexp[80];		/* memory or port or pin group names */
    FILE *iofp;			/* pointer to file structure */
    int iotype;			/*0= memory,1= port,2= pin 3=pin group 4=pin-to-pin 5=register */

    unsigned long iodest[4];	/* 0= memory type or port type or register number, 
				   1= start address or start pin number
				   2= stop address or stop pin number
				   3= ioxref */
    unsigned long iosrc[4];	/* 0= memory type or port type or register number, 
				   1= start address or start pin number
				   2= stop address or stop pin number
				   3= source device number */

    long iopos;			/* current file position */
    struct sev_evres iodata;	/* current data value */
    struct sev_evres ionextdata;	/* next data value in timed mode transfers */
    int ioabs;			/* absolute=1 or relative=0 mode of timed data */
    int ioradix;		/* radix of input data  0=decimal, 1=fractional, 2=hex */
    long iorep;			/* data repeat count 0=not defined -1=forever; also absolute mode cycle */
    struct sev_nest *ionest;	/* for nested parentheses NULL=no nesting */
    struct sev_iolist *ionext;	/* for next in linked list NULL=end of list */
    int ionum;                  /* index number associated with io record */
#if ADSx    
    unsigned long ioaddr;       /* IO address for the ads */
    unsigned long iocount;      /* IO count for ads */
#endif /* ADSx */    
};

struct sev_ilog
{
    unsigned long addr,
     wrd[10];
};				/* history instruction log */

struct sev_history
{
    unsigned long count;	/* count of addresses written since last display */
    int index;			/* insert point of addresses written since last display */
    struct sev_ilog *ilog;	/* pointer to addresses written since last display */
};

/* Profiler Stuff */
typedef void (*FN_PROF_INTER)();
typedef enum FPI
{
    FPI_none,
    FPI_SAVE,
    FPI_LOAD,
    FPI_last
}
FPI;

struct sev_prof_interface
{
    FN_PROF_INTER a_fn_rg [FPI_last + 1]; /* array of profiler
                                             interface functions */
};
/******************/

struct sev_sstat
{				/* SUMMARY OF SIMULATOR STATUS */
    unsigned long asm_add;	/* assembly address */
    unsigned long disasm_add;	/* disassembly address */
    int flg_stat;
    int flg_ijmp;
    int flg_ieof;
    int disasm_mem;		/* current memory being disassembled */
    int disasmf;		/* flag used by disassembly */
    long occ_ctr;		/* counter for step,trace,or breakpoint occurrence */
    int brk_num;		/* proceed to this breakpoint */
    int radix;			/* default base number for command entry */
    int gomode;			/* 0=go, 1=trace inst 2=trace cy 3=step ins 4=step cy 5=next-over 1 inst
				   6=next-over jsr 7=next over 1 inst in macro 8=next-over jsr in macro
				   9=until temporary bp */
    int forced_gomode;          /* 0=unused, 1=assembly step size, 2=source step size*/
    int halt_at_breakpoints;	/* flag to halt at any breakpoint - used while in trace or step with -h flag */
    int executing;		/* Flag indicating dsp cycle execution.  Not at a breakpoint */
    int ioxrefnext;		/* next ioxref value for memory io files */
    FILE *logsfp;		/* log file pointers */
    char logsname[DSP_LINE_LEN];	/* logging session file name */
    struct sev_iolist *iors;	/* stack mode reads from files */
    struct sev_iolist *iort;	/* timed mode reads from files */
    struct sev_iolist *iows;	/* stack mode writes to files */
    struct sev_iolist *iowt;	/* timed mode writes to files */
    unsigned long reg_cnt1;	/* counter 1 user count */
    unsigned long reg_cnt2;	/* counter 2 user count */
    unsigned long reg_cnt3;	/* counter 3 user count */
    unsigned long reg_cnt4;	/* counter 4 user count */
    /* For 56300 */
    unsigned long ic_hit;
    unsigned long ic_miss;
    unsigned long ic_replace;
    int macro_index;		/* used to record macro id when using next command to step over macro */
    CORE_ADDR end_pc;
    int log_debug;		/* flag to log display status line during session logging */

    struct sev_profile pf;      /* profiler information */
    int label_display;      /* label display flag */
#if ADSx
    int poll_error;             /* lost contact with command converter */
#endif /* ADSx */    
};

struct sev_cmd
{
    char gcs[256];		/* global command string buffer with just blanks=0, lower case */
    char gcu[256];		/* same as gcs, but upper and lower case */
    char gct[128];		/* global command main field types */
    int gcf[128];		/* global command string main field positions */
    struct sev_evres gce[128];	/* expression float double representation */
    char *gcsp;			/*pointer to original string being parsed */
    int gerrpos;		/* position in string with error */
#if ADSx
    char gcswd[256];            /* global command string with device field */
    int devlist[33];            /* list of devices that this command will be
                                   executed on.  devlist[0] is count,
                                   subsequent values are the device numbers */
#endif    
};

struct sev_bp
{
    int bpnum;			/* breakpoint number greater than 1, 0 are temporary breakpoints */
    int bptype;			/* 0=read 1=write 2=access memory */
    /* 3=read 4=write 5=access register */
    /* 6=expression  7=simple expression 8=execution address */
    /* 9=dma read 10=dma access 11=dma write 12=C expression */
    int bpcycle;		/* 0=instruction boundary, 1=cycle boundary check */
    int bpaction;		/* break action */
    char bpexp[256];		/* breakpoint expression */
    char bpcommand[256];        /* breakpoint command to execute */
    int bpenable;		/* 1=enable, 0=disable */
    struct sev_evres bpev;
    struct sev_bp *bpnext;	/* point to next breakpoint */
    struct cdb_parse_tree *bpctree;   /* parse tree from C expression */
    int bpbfi;                  /* function index for function in */
				/* which C expression locals come from */
    int bpbbi;                  /* block index for block in which C */
				/* expression locals come from */
#if ADSx    
    unsigned long bpaccess[2];  /* memory access type for ads breakpoints */
    unsigned long bprange[2];   /* memory range qualifier for ads breakpoints*/
    unsigned long bporder;      /* memory order qualifier for ads breakpoints*/
    unsigned long bpaddlow;     /* start address for ads breakpoints */
    unsigned long bpaddhigh;    /* end address for ads breakpoints */
    unsigned long bpcount;      /* count for ads breakpoints */
    unsigned long bpoccur;      /* count decremented by number of occurences */
    unsigned long bpbrkopcode;  /* opcode for ads debug */
    unsigned long bpopcode;     /* saved off opcode for ads sw breakpoints */
    unsigned long bposcr;       /* saved off oscr for ads breakpoints */
    unsigned long bpfnum;       /* file number for break eof */
#endif    
};

struct sev_file_info
{
    int fd;     /* file descriptor */
    char *path;
    int flags;  /* the flags the file was open with */
    int mode;   /* the mode the file was open with */
};

/* order counts */
enum { STDIN, STDOUT, STDERR };

/* for support of host i/o for C programs */
struct sev_hio
{
    int enabled;               /* 1=we are handling C I/O, 0=we ignore */
                               /* C I/O */

    hio_buffer send_buffer;
    hio_buffer receive_buffer;
    
    CORE_ADDR send_address;    /* address of the __send function in the */
                               /* C program */
    
    CORE_ADDR receive_address; /* address of the __receive function */
                               /* in the C program */

    struct sev_file_info *fi; /* information for opened files */
    int ufi;                    /* index of first available file */
                                     /* info struct */
    int afi;  /* number of allocated file info structs --- */
                   /* ufi == afi if there are none availble */

    /* indexed by file descriptor (0=stdin, */
    /* 1=stdout, 2=stderr, others are not handled) */
    int redirect[3]; /* true if the given file is being redirected */
                     /* to/from a file */
    FILE *fp[3];
    char fn[3][DSP_LINE_LEN];
    int file_text_p[FOPEN_MAX];
    enum states state;
    union call_info call_data;
#if ADSx
    unsigned long send_opcode; /* Opcode replaced by debug at send_address */
    unsigned long receive_opcode; /* Opcode replaced by debug at receive_address */
    unsigned long break_opcode; /* Debug opcode */
    int break_installed; /* Set if hio breapoints are installed */
#endif /* ADSx */    
};

enum wtype
{
    WT_CEXP, /* this has to stay the first element due to dependency */
             /* in simutil.c */
    WT_REG,
    WT_IEXP,
    WT_FEXP
};

/* watch list */
struct sev_watch_node
{
    unsigned wnum;              /* watch number */
    char wexp[256];             /* Watch expression */
    enum wtype type;            /* watch expression type... */
    int radix;
    unsigned long memtype;
    unsigned long addr;
    struct cdb_parse_tree *tree;
    int bb_index;
    int bf_index;
    struct sev_watch_node *wnext;   /* Pointer to next watched item */
};


struct sev_frame_node
{
    char *str;
    unsigned long
        pc,
        fp,
        sp
	;
    struct cdb_register_list *registers;
    struct sev_frame_node
        *prev,
        *next;
};

/* current frame list for device */
struct sev_frames
{
    struct sev_frame_node *fhead;
    struct sev_frame_node *ftail;
    struct sev_frame_node *fcur;
};

struct sev_mtag
{				/* describes enable status of a block of memory */
    int menable;		/* 0=off, 1=on, 2=read, 3=write, 4=access */
    unsigned long mbegin;	/* beginning address of block */
    unsigned long mend;		/* end address of block */
    struct sev_mtag *mnext;	/* next block */
};

struct sev_periph
{
    unsigned long perattr;	/* peripheral attribute flags */
    unsigned long *regattr;	/* attributes of displayable registers: */
    /* includes dispnst, initialized,denab,don,doff */
    /* dr,dw,drw,benab,br,bw,brw,hex,dec,bin,fr,pin,size */
};

struct sev_memflags
{
    int count;			/* count of addresses written since last display */
    int index;			/* insert point of addresses written since last display */
    int bcount;			/* count of addresses written since last breakpoint */
    unsigned long addr[16];	/* array of addresses written since last display */
    unsigned long dma_flag[16];	/* extra info - if the write or read was done by dma */
};

struct sev_memory
{
    struct sev_mtag *mdp;	/*memory display enable flags structure */
    struct sev_mtag *mdn;	/*memory display now structure */
    struct sev_mtag *mdr;	/*memory display radix selection */
    struct sev_mtag *mdbo;	/*memory output file breakpoints selection */
    struct sev_mtag *mdbi;	/*memory input file breakpoints selection */
    struct sev_memflags wflags;	/* write tags for memories written */
    struct sev_memflags rflags;	/* read tags for memories read */
};

struct sev_section_info
{
    CORE_ADDR s_paddr;		/* physical address,start addr of section */
    unsigned long s_size;	/* number of words in section */
    unsigned long s_scnptr;	/* file offset to data */
    unsigned long s_flags;
    unsigned long s_nlnno;	/* number of line numbers for this section */
    unsigned long s_lineno;	/* index of first line number record for this section */
    int bsi;			/* index of .bs symbol number */
};

struct sev_ftab
{
    int numlines;		/* number of lines in the file */
    long *line_offsets;		/* file offset to start of each line in file */
};

struct sev_offset_entry
{
    unsigned long pc; /* pc at which offset change instruction occurs */
    long offset;      /* offset magnitude */
};

struct sev_regs_entry
{
    unsigned long pc; /* pc at which register save instruction occurs */
    int regnum; /* register index based on C register indexes*/
    long offset;      /* offset magnitude from fp at which register is saved.*/
    CORE_ADDR addr; /* absolute address at which register is saved */
};

struct sev_offset_table
{
    unsigned long num_entries; /* number of entries in following table */
    struct sev_offset_entry *entries; /* points to first member of array of entries */
};

struct sev_regs_table
{
    unsigned long num_entries; /* number of entries in following table */
    struct sev_regs_entry *entries; /* points to first member of array of entries */
};

struct sev_cdb
{
    struct sev_offset_table fp;  /* the frame pointer offsets table */
    struct sev_regs_table saved_regs; /* register offset table */
};


/* this record is used for sorting the line numbers by file id */
struct sev_line_xref
{
    int ln; /* line number index */
    unsigned long fileid; /* file id number */
};

struct sev_debug
{				/* symbolic debug info for each device */
    long current_section;	/* previously found section used to start searches */
    long num_sections;		/* Number of sections */
    long symptr;		/* File pointer to symbol table entries */
    long num_symbols;		/* Number of symbols */
    SYMENT *symtab;		/* Symbol table */
    SYMENT *csymtab;		/* C Symbol table */
    char *str_tab;		/* Pointer to start of string char. array */
    long str_length;		/* Length in bytes of string array */
    int linetab_count;		/* Number of line records */
    LINENO *linetab;		/* Line number records */
    int prev_file_index;	/* previously displayed file index */
    int prev_line_start;	/* start line previously displayed */
    int prev_line_end;		/* end line previously displayed */
    int prev_line_caret;	/* previous line where caret displayed */
    CORE_ADDR prev_addr_start;
    unsigned long prev_addr_end;
    struct sev_section_info *sectiontab;
    char *cld_filename;		/* name of .cld file used for debug */
    int numfiles;		/* number of ft structures */
    struct sev_ftab *ft;	/* file tables line offset structures
                                   for each source file */
    unsigned long current_pos;	/* current position in displayed source file */
    unsigned long max_pos;	/* maximum position displayed source file */
    unsigned long *sort_addr;	/* symbols indexes sorted by map and address */
    unsigned long *sort_name;	/* symbol indexes sorted alphabetically */
    struct sev_cdb cdb;         /* C debug tables created at program load time */
    struct sev_line_xref *linetab_xref;  /* xref to linetab sorted by file id */
};

struct sev_var
{				/* one of these for each device */
    char *devid;		/* name for this particular device */
    struct sev_memory *mem;	/* pointer to array of memory structures */
    struct sev_periph *periph;	/* pointer to array of peripherals */
    struct sev_sstat stat;	/* Simulator status structure */
    struct sev_bp gbp;		/* Breakpoint header structure */
#if ADSx    
    struct sev_bp tempbp;	/* Temporary breakpoint */
	char updateCoreWin;     /* variable that shows if the core reg window
							 * needs to be updated
							 * 0- Does not need to be updated
							 * 1- Needs to be updated
							 */
#endif /* ADSx */    
    struct sev_watch_node wl;   /* Watch list header structure */
    struct sev_frames fl;       /* Frame list header structure */
    unsigned long memory_map;   /* if they have a C file loaded, this */
                                /* is the memory map that the file was */
                                /* compiled with --- otherwise, this */
                                /* is the memory map that the compiler */
                                /* for this part would default to */
    struct sev_window *win;	/* allocated window buffer for device */
    struct sev_history history;	/* holds history of execution */
    struct sev_debug db;
    struct sev_hio hio;         /* for handling C i/o on the host side */
    enum display_modes display_mode;
    int source_mode;		/* 1 source window open */
};

struct st_help_topic
{
    char *help_key;		/* help topic keyword */
    char **help_text;		/* pointers to help strings. Last one is NULL. */
    char *help_description;     /* single line describing help topic */
    char **(*help_func) (void);	/* help execution function */
    void (*help_post_func) (char **help_strings); /* normally used to free allocated help memory */
};

struct st_help
{				/* help entry for on-line help topics */
    int num_topics;
    struct st_help_topic *topic;
};

#define DSP_INTERACTIVE 1	/* interactive command flag */

struct st_cexec
{				/* one of these for each form of command */
    void (*cmd_exec) (char *);	/* command execution function */
    int cmd_flag;
};

struct st_ohelp
{				/* strings used for on-line help functions */
    char *help_key;		/* help keyword for help file extended help */
    char **help_line;		/* on-line help strings for different command forms */
    char **more_help;		/* Extended help for commands */
};

struct st_command
{
    char *cmd_full;		/* full command name */
    char *cmd_short;		/* short (minimum) form of command name */
    struct st_ohelp cmd_help;
    struct st_cexec *(*cmd_parse) (void);/* command parsing function */
    int dev_flag;               /* 0=pass devlist, 1=one device, 2=devlist */
    int exec_flag;              /* 1=allow command when ads is not in debug
                                   mode */
};

struct st_disp
{
    int dispxr;			/* maxreg display to simulator register list */
    int dispfw;			/* field widths of displayed registers and blank fields */
    int dispfe;			/* position in display field of the = mark */
};

struct st_periph
{
    int numdisp;		/* number of displayed register slots for display routine */
    struct st_disp *dispf;	/*display parameters */
    /* function called to read data string provide by io file */
    int (*iorval) (char *, struct sev_iolist *);
    /* function called to furnish output data string for io file */
    int (*iowval) (struct sev_iolist *, long *, char *);
    /* function called to process timed io data */
    int (*iopval) (int, struct sev_evres *);
    struct st_help *phlp;       /* pointer to on-line help topics for peripheral */
};

/* device type specific profile functions */
struct st_prof
{
    int Gr_number;
    int Op_number;
 
    char **op_group_name;
    char **op_group_set;
 
     OPERATION (*map_op) (struct INSTRUCTION_NODE * command);
    char *(*map_op_name) (OPERATION op);
    void (*init_addr_mode_table) (char **add_mode_msg);
    void (*update_addr_modes) (struct INSTRUCTION_NODE * command);
    void (*update_move_info) (struct INSTRUCTION_NODE * command);

    BOOL (*is_cond) (struct INSTRUCTION_NODE * inst);
    BOOL (*is_jsr) (struct INSTRUCTION_NODE * inst);
    BOOL (*is_callable) (struct INSTRUCTION_NODE * inst);
    BOOL (*is_return) (struct INSTRUCTION_NODE * inst);
    BOOL (*is_loop) (struct INSTRUCTION_NODE * inst);
    
    char *(*disassemble) (struct INSTRUCTION_NODE * inst);
    void (*decoder) (int devindex,
                     enum memory_map memt,
                     unsigned long pc,
                     unsigned long next_pc,
                     struct INSTRUCTION_INFO * ip);
};
    

struct st_cdb
{
    int (*create_offset_tables) ();
    unsigned long (*pc_of_parent) (unsigned long pc, unsigned long fp, unsigned long sp, unsigned long *hwsp);
    unsigned long (*sp_of_parent) (unsigned long pc, unsigned long fp, unsigned long parent_pc);
    unsigned long (*fp_of_parent) (unsigned long pc, unsigned long fp, unsigned long sp, unsigned long parent_pc);
    unsigned long (*sp_current) (void);
    unsigned long (*fp_current) (void);
    struct sev_regs_entry * (*get_saved_regs)(unsigned long pc, unsigned long sp);
};
    
struct st_var
{				/* one of these for each device type */
    int *mem_dispfw;		/* memory display field width */
    char **mem_help;		/* memory map description strings */
    struct st_periph **periph;	/* pointer to array of peripherals */
    /* assemble code for this device */
    void (*sasm) (char *, unsigned long);
    /* disassemble code for this device */
    int (*sunasm) (unsigned long *, char *, unsigned long,
                   unsigned long, struct sdb_dasm *);
    struct st_help *hlp;
    struct st_prof *pft;
    struct st_cdb *cdb;
};

struct sev_const
{
    struct sev_var **sv;	/* pointers to data structures for each device */
    int cmdsz;			/* Stack size for previous commands */
    int histsz;			/* Execution history buffer size */
    int winsz;			/* Number of display lines in window buffer */
    int numlines;		/* number of lines of display terminal */
    int numcols;		/* number of columns of display terminal */
    int cmdline;		/* display line used by scrmgr for command entry */
    struct st_var **st;		/* pointers to data structures for each device */
    int numcmds;
    struct st_command **commands;
    char **command_help;	/* list of commands for help line */
    struct sev_line *prevcmd;	/* previous command list (for repeat of command) */
    struct sev_prof_interface * prof;    /* profiler structure pointer */
    int viewdev;		/* device index being viewed on screen */
    char *gerrptr;		/* pointer to error message */
    char gerrmsg[DSP_LINE_LEN];	/* error line message buffer */
    char helpmsg[DSP_LINE_LEN];	/* help line message buffer */
    char cmdmsg[DSP_LINE_LEN];	/* command line message buffer */
    int breakdev;		/* device index that will halt if CTRLC break occurs */
    FILE *logcfp;		/* log commands file pointers */
    char logcname[DSP_LINE_LEN];	/* logging commands file name */
    int in_macro;		/* Flag indication a macro command is being executed */
    FILE *macfp;		/* the currently open macro file (only 1 open at a time) */
    struct sev_mac *mactop;	/* Linked list of nested macros being executed */
    struct sev_cmd cmd;		/* Parsed command structures */
    int edithelp;		/* flag to select edit or main help */
    int hlpindex;		/* current offset into help lines */
    char **hlpmain;		/* on-line main help lines pointers */
    char **hlpedit;		/* on-line edit help lines pointers */
    int curline;
    int curclm;
    int scrnest;
    int insert_o;
    int gui;                    /* TRUE if the GUI is running */
    int waiting;                /* TRUE if in waiting in gui wait command */
    char devprompt[10];
    char *source_path;		/* multiple source paths comma separated */
    char *screenbuf;		/* pointer to buffer used for symbolic debug display */
    int more_processing_flag;   /* flag to pause during screen output */
    int lines_written;          /* count of lines written to session window */
    int quit_enabled;           /* enables quit on error */
    int exit_status;            /* exit status for quit with non-zero status */
    int command_status;         /* 0 = ok, non-zero = error for current command */
    int spw_mode;               /* state variable for spw interface */
    int spw_end_addr;           /* task end address for spw interface */
#if ADSx
    struct sev_window *ads_win; /* The ads only uses one window */
#endif
};

#endif
#endif /* __simusr_h__ */
