/* $Id: rgsim.h,v 1.6 1997/02/17 20:19:18 jay Exp $ */
/* Copyright (C) 1995, by Motorola, Inc. */

#ifndef __rgsim_h__
#define __rgsim_h__

#if FULLSIM

#include "rgir.h"

struct INSTRUCTION_MEM
{
    ADDRESS_SPACE space;
    MBT mbt;
    DSP_ADDR addr;
    DSP_DATA data;
    MOT mot;
};

typedef enum REP_STATUS
{
    SAP_REP_none,
    SAP_REP_START,
    SAP_REP_INGO,
    SAP_REP_DONE,
    SAP_REP_last
}
REP_STATUS;

struct REP_INFO
{
    DSP_ADDR addr;
    REP_STATUS status;
    unsigned long cycl;
    int iter;
};

struct INSTRUCTION_EXEC
{
    unsigned long cycl;		/* spent cycles                   */
    unsigned long cycl_total;	/* total spent cycles             */
    unsigned long cycl_stalls;	/* pipeline stalls                */
    int is_condition_passed;	/* whether condition passed       */
    DSP_ADDR next_addr;		/* next instruction address       */
    struct REP_INFO *rep;	/* REP execution results, or NULL */
};

/***************************************************************************
 *
 * INSTRUCTION NODE structure. One for each executable line of code.
 *
 ***************************************************************************/

#define CUR_INST_MEM_OP 10
#define MAX_INST_MEM_OP (CUR_INST_MEM_OP + CUR_INST_MEM_OP)

struct INSTRUCTION_INFO
{
    struct INSTRUCTION_NODE in;
    struct INSTRUCTION_EXEC ie;
    struct INSTRUCTION_MEM im[MAX_INST_MEM_OP];
};

struct PICKUP_REG_INFO
{
    int reg_num;
    int periph_num;
    int f_found;
    unsigned long regval;
    unsigned long prev_regval;
};


struct LOOP_INFO
{
    struct PICKUP_REG_INFO sr_info;
    struct PICKUP_REG_INFO lc_info;
    struct PICKUP_REG_INFO la_info;
    int LF_value;
    long loop_nesting;
    long max_loop_nesting;
};

struct sev_profile
{
    int  f_is_prof_active; /* not zero if the profiler was turned on by log p*/
    char filename[DSP_LINE_LEN];
    unsigned long prev_cyc;
    unsigned long prev_pc;
    struct INSTRUCTION_MEM im[MAX_INST_MEM_OP];
    struct REP_INFO rep_info;
    struct LOOP_INFO loop_info;
    unsigned long inst_pl_stalls;	/* P.L. stalls */
    DSP_DATA sr_val;           /* value of the SR register at creation time */
    DSP_DATA omr_val;          /* value of the OMR register at creation time */
    int      f_new_inst;       /* true before firts instruction cycle        */
    int      f_run;            /* true if profiling started already */
    struct PROGRAM program;   /* profiler's internal representation of prog */
};

void siml_dsp_profile (int devindex);
void siml_profile_program_start (char *, char *, char *);
void siml_profile_program_end (unsigned long);
int siml_rg_step (struct INSTRUCTION_INFO *);

void siml_dsprof_conv_memt (enum memory_map memt,
			    ADDRESS_SPACE * space, MBT * mbt);


#endif /* FULLSIM */

#endif /* __rgsim_h__ */
