#ifndef _driver_h_
#define _driver_h_

/* Includes */
#include <stdio.h>
#include <ctype.h>
#include <time.h>

#if UNIX
#include <fcntl.h>
#ifdef _HPUX_SOURCE
#include <sys/ioctl.h>
#else
#include <sys/ioccom.h>
#endif /* _HPUX_SOURCE */
#include <sys/uio.h>
#include <sys/types.h>
#include <sys/time.h>
#endif

/* Public function prototypes */
/* Driver functions */
int dspd_read_core_registers (int, int, unsigned long, unsigned long *);
int dspd_write_core_registers (int, int, unsigned long, unsigned long *);
int dspd_read_once_registers (int, int, unsigned long, unsigned long *);
int dspd_write_once_registers (int, int, unsigned long, unsigned long *);
int dspd_read_memory (int, int, unsigned long, unsigned long, unsigned long *);
int dspd_write_memory (int, int, unsigned long, unsigned long,
                       unsigned long *);
int dspd_write_flash (int, int, int, unsigned long, unsigned long,
                       unsigned long *);
int dspd_erase_flash (int, int, int, unsigned long, unsigned long);
int dspd_fill_memory (int, int, unsigned long, unsigned long, unsigned long);
int dspd_go (int, unsigned long, unsigned long);
int dspd_break (int, int);
int dspd_reset (int, int);
int dspd_check_service_request (int);
int dspd_status (int, int *);
int dspd_jtag_reset (int, int);
void dspd_set_host_timeout (int);
int dspd_set_host_address (int);
void dspd_configure_device (int, int, int, int);
void dspd_set_tms_chain_length (int, int, int);
int dspd_get_host_timeout (void);
int dspd_get_host_address (void);
void dspd_get_device_configuration (int, int *, int *, int *);
int dspd_get_cc_num (int);
int dspd_get_tms_chain_length (int, int);

/* Command Converter functions */
int dspd_cc_architecture (int, int);
int dspd_cc_read_memory (int, int, unsigned long, unsigned long,
                         unsigned long *);
int dspd_cc_write_memory (int, int, unsigned long, unsigned long,
                          unsigned long *);
int dspd_cc_read_flag (int, int, unsigned long *);
int dspd_cc_write_flag (int, int, unsigned long);
int dspd_cc_break (int);
int dspd_cc_reset (int);
int dspd_cc_go (int);
int dspd_cc_service_bp (int);
int dspd_cc_revision (int, char *);

/* definitions for memory spaces */
#define P_MEM 0 /* program memory */   
#define X_MEM 1 /* x data memory */   
#define Y_MEM 2 /* y data memory */   

#if _MSC_VER
#include <conio.h>
#define inp(x) _inp((x))
#define outp(x,y) _outp((x),(y))
#endif

#if UNIX
/* mdsp_ioctl commands */
#define MDSPRESET       _IOW('m',1,int)           /* set adm reset line */
#define MDSPBREAK       _IOW('m',2,int)           /* force adm break */
#define MDSPCOMMAND     _IOW('m',3,struct fakeit) /* send read command */
#define MDSPSELECT      _IOW('m',4,int)           /* select an adm for a group */
#define MDSPDESELECT    _IOW('m',5,int)           /* deselect an adm group */
#define MDSPCLEAR       _IOW('m',6,int)           /* clear adm reset line */
#define MDSPWBYTE       _IOW('m',7,int)           /* write byte to data addr */
#define MDSPRBYTE       _IOWR('m',8,int)          /* read byte from data addr */
#define MDSPDEVICE      _IOW('m',9,int)           /* set mdspsoftc.ctrl1 ADM */
#define MDSPIOW         _IOW('m',10,int)          /* write to an address */
#define MDSPIOR         _IOWR('m',11,int)         /* read from an address */
#define MDSPSETADM      _IOW('m',19,int)          /* set adm types/actives */
#define MDSPVERSION     _IOWR('m',20,char[120])   /* return driver version */
#endif

/* Interface board register defines */
#define CTRL1  0 /* control register address offset */
#define DATA   1 /* data register address offset */
#define CTRL2  2 /* control register 2 address offset */

/* ADM and Host interface signal description */

/* ADM inputs */
#define HST_REQ    2
#define HST_ACK    4

/* ADM outputs */
#define ADM_INT    1
#define ADM_REQ    2
#define ADM_ACK    4

/* Host Inputs  */
#define HST_BRK    8

/* Host outputs */
#define ADM_BRK    1
#define HST_REQ    2
#define HST_ACK    4
#define ADM_ALL    8
#define ADM_RESET  0x80
#define BRACE_SEL  0x20
#define INT_ACK    0x40
#define ADM_GROUP  0x80

#define DSP_HIGH         1
#define DSP_LOW          0

#define RESET_USER       0
#define RESET_DEBUG      1

#define USER_MODE        0
#define DEBUG_MODE       1

/* Architecture types */
#define DSP_CC_96000 0
#define DSP_CC_56000 1
#define DSP_CC_56100 2
#define DSP_CC_56300 3
#define DSP_CC_LP16  4
#define DSP_CC_56800 5
#define DSP_CC_56600 8

/* Low level timeout counter */
#define DSP_MAX_ATTEMPTS 0xffffl

/* Options for dspd_jtag_reset */
#define DSP_JTAG_TOGGLE_STATES 0
#define DSP_JTAG_PULL_RESET_LINE 1

#define LSB (0x0001)		/* 'least significant bit' */
#define SRX (0x0001)		/* SCI receiver bit in CNTR1 */
#define STX (0x0080)		/* SCI transmit bit in CNTR2 */
#define SCK (0x0020)		/* SCI clock bit in CNTR2 */

#define DSP_BREAK_JTAG 0
#define DSP_BREAK_DE 1

#define DSP_OLD_CC 0
#define DSP_NEW_CC 1

struct cc_config
{
    int type;
    int tms0_count;
    int tms1_count;
    int has_been_reset;
    int has_been_configured;
};

#define get_cc_type(cc_num) (cc_info[(cc_num)].type)
#define set_cc_type(cc_num, cc_type) cc_info[(cc_num)].type = (cc_type)
#define get_tms0_count(cc_num) (cc_info[(cc_num)].tms0_count)
#define set_tms0_count(cc_num, count) \
        cc_info[(cc_num)].tms0_count = (count)
#define get_tms1_count(cc_num) (cc_info[(cc_num)].tms1_count)
#define set_tms1_count(cc_num, count) \
        (cc_info[(cc_num)].tms1_count = (count))
#define get_cc_has_been_reset(cc_num) (cc_info[(cc_num)].has_been_reset)
#define set_cc_has_been_reset(cc_num, flag) \
        cc_info[(cc_num)].has_been_reset = (flag)
#define get_cc_has_been_configured(cc_num) \
        (cc_info[(cc_num)].has_been_configured)
#define set_cc_has_been_configured(cc_num, flag) \
        cc_info[(cc_num)].has_been_configured = (flag)

struct dev_config
{
    int cc_num;
    int tms_num;
    int chain_pos;
};

#define get_cc_num(dev_num) (dev_info[(dev_num)].cc_num)
#define set_cc_num(dev_num, ccnum) dev_info[(dev_num)].cc_num = (ccnum)
#define get_tms_num(dev_num) (dev_info[(dev_num)].tms_num)
#define set_tms_num(dev_num, tmsnum) dev_info[(dev_num)].tms_num = (tmsnum)
#define get_chain_pos(dev_num) (dev_info[(dev_num)].chain_pos)
#define set_chain_pos(dev_num, chainpos) \
        dev_info[(dev_num)].chain_pos = (chainpos)



#endif /* _driver_h_ */
