; $Id: adm.h,v 1.27 1996/09/10 15:41:22 cgregg Exp $
	opt	cex,loc,cre,mu,nomsw,lb,mex
	page	133,66,0,0
;****************************************************************************
;	MULTIPLE ARCHITECTURE COMMAND CONVERTER PROGRAM
;
;	MOTOROLA RESERVES THE RIGHT TO MAKE CHANGES WITHOUT FURTHER
;	NOTICE TO THE PROGRAM HEREIN TO IMPROVE RELIABILITY, FUNCTION
;	OR DESIGN.  MOTOROLA DOES NOT ASSUME ANY LIABILITY ARISING OUT
;	OF THE APPLICATION OR USE OF THE PROGRAM HEREIN; NEITHER DOES
;	IT CONVEY ANY LICENSE UNDER ITS PATENT RIGHTS NOR THE RIGHTS
;	OF OTHERS.
;
;	THIS PROGRAM IS USED TO TRANSFER DATA TO/FROM THE
;	THE HOST COMPUTER TO THE TARGET. THE COMMAND CONVERTER
;	RECEIVES HOST HIGH LEVEL COMMANDS AS DEFINED IN THE
;	target ADS.  THE CONVERTER THEN SENDS A SEQUENCE OF
;	INSTRUCTIONS TO THE target OnCE PORT TO INTERPRET
;	THE COMMAND.  THE COMMAND CONVERTER IS A DSP56000 WHICH
;	USES THE SSI PORT TO COMMUNICATE WITH THE OnCE PORT AND THE
;	HOST INTERFACE PORT TO COMMUNICATE WITH THE HOST COMPUTER.
;
;	SEQUENCING OF THE OnCE INSTRUCTIONS ADHERE TO AN INTERNAL
;	FORMAT.  THE LOWER BYTE OF THE Y INTERNAL RAM IS USED TO
;	DEFINE WHAT MUST BE DONE TO ACCOMPLISH THE CORRECT TRANSFER
;	PROTOCOL WITH THE OnCE PORT.  THE UPPER TWO BYTES OF THE 24
;	BIT WORD ARE USED AS OnCE COMMANDS OR target INSTRUCTIONS.
;	THE LOWER BYTE IS USED BY THE OnCE COMMUNICATION ROUTINES TO
;	SEND/STORE DATA AS WELL AS TERMINATE THE TRANSFER.
;
REV	equ	$0265	;REVISION 6.13
;	WRITTEN BY	DAVID GONZALES
;			CHRIS GREGG
;
;*******************************************************************
;	There are two types of breakpoints that may be set using the OnCE
;	controller. These are hardware breakpoints and software breakpoints.
;	Hardware breakpoints use comparator logic on-chip which monitors
;	the address bus.  When the address falls within a high and low
;	boundary the debug mode of operation is entered and the command
;	converter is requested for service.
;
;	Software breakpoint types are described as conditional
;	statements (debugcc) which examine the status register and if the
;	particular condition is true, the debug mode of operation
;	is entered. The type is an offset to the correct opcode
;	to be entered in the user program memory map.
;
;	Type		offset		condition
;	----		------		---------
;	debugcc/hs	0		carry clear	 (C=0)
;	debugcs 	1		carry set	 (C=1)
;	debugeq 	2		equal		 (Z=1)
;	debugge 	3		greater or equal (N and V = 0)
;	debuggt 	4		greater than	 (Z or (N and V) = 0)
;	debughi 	5		higher		 (Z or C = 0)
;	debugle 	6		less or equal	 (Z or (N and V) = 1)
;	debugls 	7		lower or same	 (Z or C = 1)
;	debuglt 	8		less than	 (N or V = 1)
;	debugmi 	9		minus		 (N = 1)
;	debugne 	10		not equal	 (Z = 0)
;	debugpl 	11		plus		 (N = 0)
;	debugvc 	12		overflow clear	 (V = 0)
;	debugvs 	13		overflow set	 (V = 1)
;	debugal 	14		always true	 N.A.
;*******************************************************************
RESET	equ	$0000			;RESET VECTOR ADDRESS (MODE 1)
;*********************************************************
;	SSI STATUS REGISTER BITS
;*********************************************************
RDF		equ	7			;receive data reg. full
TDE		equ	6			;transmit data reg. empty
ROE		equ	5			;receive overrun error
TUE		equ	4			;transmit underrun error
RFS		equ	3			;receive frame sync flag
TFS		equ	2			;transmit frame sync flag
IF1		equ	1			;input flag 1
IF0		equ	0			;input flag 0
;*********************************************************
;	SSI CRA REGISTER BITS
;*********************************************************
SSI16_24	equ	$e	;WL1 bit dictates 16/24 bit length
SSI12_24	equ	$d	;WL0 bit dictates 12/24 bit length
WL1		equ	$e	;WL1 - CRA word length (msb) 00=8  01=12
WL0		equ	$d	;WL0 - CRA word length (lsb) 10=16 11=24

;*************************************************************************
;	DATA BUS PINS USED AS INPUTS
;*************************************************************************
SELECT		equ	18			;D<18>
RS232		equ	19			;D<19>
INT_ACK		equ	20			;D<20>
H_ACK 		equ	21			;D<21>
H_REQ 		equ	22			;D<22>
;*********************************************************
;	COMMAND CONVERTER PORT B OUTPUT BIT NUMBERS
;	PORT B DATA BITS 0-7 ARE USED TO TRANSFER DATA.
;*********************************************************
ADM_REQ 	equ	10			;Port B output
ADM_INT 	equ	9			;Port B output
ADM_ACK 	equ	8			;Port B output
DIR		equ	11			;Port B output
JTAGPORT	equ	12			;informs pal if device is
						;  jtag or once
TMS0    	equ     13                      ;TMS0 output control line 
TMS1    	equ     14                      ;TMS1 output control line
;*********************************************************
;       COMMAND CONVERTER PORT C INPUT/OUTPUT BIT NUMBERS
;*********************************************************
SCIRX   	equ	0			;Port C SCI RX input
SCITX   	equ	1			;Port C SCI TX output
H_BRK   	equ     3                       ;Port C output
ORESET  	equ     4                       ;Port C output
DEBUGREQ 	equ	5                       ;Port C output
DSCK		equ	6			;Port C SCK are dsck outputs
DSO     	equ     7                       ;Port C SRD are dso inputs
DSI		equ	8			;Port C STD are dsi outputs
;**********************************************************
;	PORT B & C I/O CONFIGURATION
;	Currently PB12 is now used to distinguish between once and jtag devices.
;	This is a kludge due to lack of i/o pins available and having to toggle
;	trst via pb9 only when pb12 is high.  pb12 is called jtagport.
;**********************************************************
BDDRIN		equ	$7f00			;outputs=ADM_REQ,ADM_INT,
						;  ADM_ACK,DIR,TMS0,TMS1
BDDROUT		equ	$7fff			;all outputs including
						;  8 bit data port
BOUT		equ	$7000			;TMS0=1,TMS1=1,default to jtag
						;  part(pb12=1),all others = 0
CIO		equ	$17c			;inputs=SELECT,outputs=H_BRK,
						;  ORESET,TDI/DSI


PLLIN		equ	$40001			;preset pll for multiplier of
						;  2 x 20mhz
;**********************************************************
;	56001 PERIPHERAL REGISTER DEFINITIONS
;**********************************************************
	define	INPUTS	'y:$fff0'	;dummy address-data bus 18-22 inputs
	define	PBC	'x:$ffe0'       ;port b control
	define	PCC	'x:$ffe1'       ;port c control
	define	PBDDR	'x:$ffe2'       ;port b ddr
	define	PCDDR	'x:$ffe3'       ;port c ddr
	define	PBD	'x:$ffe4'       ;port b data
	define	PCD	'x:$ffe5'       ;port c data
	define	CRA	'x:$ffec'       ;ssi control reg. a
	define	CRB	'x:$ffed'       ;ssi control reg. b
	define	SSISR	'x:$ffee'       ;ssi status reg.
	define	RX	'x:$ffef'       ;ssi receive reg.
	define	TX	'x:$ffef'       ;ssi transmit reg.
	define  PCTL    'x:$fffd'       ;pll control register
	define	BCR	'x:$fffe'       ;bus control register
	define	IPR	'x:$ffff'       ;interrupt priority reg.
;****************************************************************************
;	BIT ASSIGNMENTS WITHIN THE FLAGS WORD
;****************************************************************************
DEBUGMODE	equ	0		;debug mode flag, target in debug
					;  mode if set
OnCEREQ		equ	1		;OnCE req flag, target requesting
					;  service if set
CLEANUP		equ	2		;target reg clean up flag, restore
					;  registers on target if set
JTAGDEV		equ	3		;jtag type device if set
TMS0FLAG	equ	4		;tms0 flag, use tms0 if set
TMS1FLAG	equ	5		;tms1 flag, use tms1 if set
POLLSTATUS	equ	6		;poll status if set
CMDFLAG		equ	7		;ONCE command flag, send 8 bit
					;   command if set
STATUSBUSY	equ	8		;devices in chain are busy if set,
					;  else all in debug mode
POLLSTAT	equ	9		;status poll flag, set when status
					;  needs to be checked in JTAG
DATAFLG		equ	10		;data flag bit used to shift in data
					;  from TDO pin.
DEV96K  	equ	11		;96k  device flag
DEV56K  	equ	12		;56k  device flag
DEV561K 	equ	13		;56100 device flag
DEV563K		equ	14		;56300 device flag
DEV56L1K	equ	15		;56lp16 device flag
DEV568K		equ	16		;56800 device flag
STACKERR	equ	17		;Stack error flag
ILLEGERR	equ	18		;illegal opcode error flag
TIMEOUT		equ	19		;timeout error flag
JTAGFLAG	equ	20		;jtag port if set
ACTVMODE	equ	21		;MODE setting (1 in debug, 0 otherwise)
;****************************************************************************
;	BIT ASSIGNMENTS WITHIN THE FLAG2 WORD
;****************************************************************************
POLLENABLE	equ	0		;polling of status enabled if 1		
;***************************************************************
;	MISC. EQUATES
;***************************************************************
DEBUGSTAT	equ	$D00000		;value to compare when polling status 
LOADADDR	equ	$C000		;start location of EPROM
JTAGTDI		equ	$0		;Data write for BANGBIT (TDI)
JTAGTDIV	equ	$1		;valid bit for JTAGTDI
JTAGTDO		equ	$2		;Data read from BANGBIT (TDO)
JTAGTDOV	equ	$3		;valid bit for JTAGTDO
JTAGLAST	equ	$4		;Device closest to TDO active
;************************************************************************
;	The first 16 locations of X memory are used for storing variables
;       56001 "SCRATCH PAD" DEFINITIONS
;**********************************************************
        define  LOOPCOUNT	'x:$0'	;loop count
        define  FLAGS		'x:$1'	;debug mode status flag
        define  YPTR		'x:$2'	;y memory pointer
        define  YTEMP		'x:$3'	;temporary scratch pad area
        define  XPTR		'x:$4'	;x memory pointer
        define  SSIMOD		'x:$5'	;ssi mode settings
        define  SSICLK		'x:$6'	;variable ssi clock speed
        define  DEVICE		'x:$7'	;target device type. 0=32,1=24,2=16bit,
        define  MARKER		'x:$8'	;current revision
        define  CLKRATE		'x:$9'	;defines manual clock rate
        define  TMSCLKS		'x:$a'	;defines number of TMS clocks to send
        define  DEVCNT		'x:$b'	;defines number of devices in jtag chain
        define  DEVACTIVE	'x:$c'	;defines active devices 
        define  DEVTMP		'x:$d'	;define scratch area for device active
        define  DATACLKS	'x:$e'	;defines number of clocks to
					;  send/receive Data
        define  ICLKS		'x:$f'	;defines number clocks to send
					;  (instructions) /receive (status)
	define	STATCNT		'x:$10'	;defines the JTAG status polling count
	define  STATVAL		'x:$11'	;defines the status of the current
					;  command executed aa = OK
	define  STATCMP		'x:$12'	;defines the status value to compare to
	define  ONCECNT		'x:$13'	;defines the OnCE status polling count
	define  ILENGTH		'x:$14'	;defines the jtag instruction length
	define	JTAGDATA	'x:$15'	;defines the jtag data value to send
        define  PLLVAR		'x:$16'	;pll holding register
	define  BCRVAL		'x:$17'	;variable bcr value
	define	TEMPAREA	'x:$18'	;temporary holding area
	define	SAVEACTIV	'x:$19'	;DEVACTIVE save location
	define	JTAGCMD1	'x:$1A'
	define	JTAGCMD2	'x:$1B'
	define	JTAGCMD3	'x:$1C'
	define	DEVSERVICE	'x:$1D' ;device number requesting service
	define	FLAG2		'x:$1E'	;extra FLAG bits
	define	USRTMP		'x:$1F'	;temp storage of user list
	define  USRLIST		'x:$20'	;List of devices in user mode to poll
	define	JTAGBDAT	'x:$21'	;JTAG single bit data storage
	define	ACTIVECMD	'x:$22'	;JTAG/OnCE command to send to an
					;  active device in upper 4/8 bits
	define	INACTIVECMD	'x:$23'	;JTAG/OnCE command to send to an
					;  inactive device (BYPASS)
	define	CURDEV		'x:$24'	;Temp - hold number of device being
					;  talked to but possibly not active
	define	DEVNUMA		'x:$25' ;Device NUMBER which is active
	define	SAVENUMA	'x:$26' ;save Device NUMBER which is active
	org	x:0
SCRATCH		bsc	$30,0
;*********************************************************************
;       THE FOLLOWING TABLE IS USED FOR HOLDING THE
;       EPROM ADDRESS LOCATIONS OF DIFFERENT SEQUENCES
;       FOR EACH OF THE ARCHITECTURES.
;*********************************************************************
TABLE   	equ     *
RPLOOP          dc      0       ;offset to execute p read opcode
RXLOOP		dc	0	;offset to execute x read opcode
RYLOOP		dc	0	;offset to execute y read opcode
WLOOP1          dc      0       ;offset to execute write opcode
WPLOOP          dc      0       ;offset to execute pmem write opcode
WXLOOP          dc      0       ;offset to execute xmem write opcode
WYLOOP          dc      0       ;offset to execute ymem write opcode
GETREG          dc      0       ;offset to reg. read opcode
PUTREG          dc      0       ;offset to reg. write opcode
OGETREG         dc      0       ;offset to OnCE reg. read
OPIPE           dc      0       ;offset to OnCE pipe reg. write
OPUTREG         dc      0       ;offset to OnCE reg. write
REGRDSEQ        dc      0       ;offset to reg. read command
REGWRSEQ        dc      0       ;offset to reg. write command
PREADSEQ        dc      0       ;offset to p read command
XREADSEQ        dc      0       ;offset to x read command
YREADSEQ        dc      0       ;offset to y read command
PWRITSEQ        dc      0       ;offset to p write command
XWRITSEQ        dc      0       ;offset to x write command
YWRITSEQ        dc      0       ;offset to y write command
GOSEQ           dc      0       ;offset to go command sequence
REPSEQ          dc      0       ;offset to repeat loop for blk writes
RESTORE         dc      0       ;offset to restore regs. used
RSAVE           dc      0       ;offset to save regs. used
RESTOR56	dc	0	;offset to restore x0,m0,r0,bpmrl,bpmrh
SAVE566		dc	0	;offset to save x0,m0,r0,bpmrl,bpmrh
GOSEQ2		dc	0
;**************************************************************************
OFFSET          dc      0       ;offset in y memory for mem read/write addr
WVOFFSET        dc      0       ;offset in y memory for mem write value
WLOOP           dc      0       ;offset in y memory for write loop
WLOOPVAL        dc      0       ;offset in y memory for write loop value
LOCREGVAL       dc      0       ;offset in y memory for reg. write value
X0VAL1          dc      0       ;offset in y memory for return x0 value
R0VAL1          dc      0       ;offset in y memory for return r0 value
M0VAL1          dc      0       ;offset in y memory for return m0 value
PWWLOOP1      	dc      0       ;offset in y mem for pwrite loop
XWWLOOP1      	dc      0       ;offset in y mem for xwrite loop
YWWLOOP1      	dc      0       ;offset in y mem for ywrite loop

		org	p:$1100
JMPTABL         bsc     48,0    ;48 locations for command jump table
		org	x:
;SAVETEMP        bsc     16,0    ;scratch area for saving registers used
SAVETEMP	dc	0	;scratch area for saving registers used
SAVEREG		equ	*       ;area for saving OnCE read data
;*************************************************************************
;	The two variables for the ssi bit rate and setup are the following
;*************************************************************************
CRAVAL		equ	8	;prescale of 0, 8 bit word, sys clk/4
CRBVAL		equ	$3e20	;gated clk, no rx/tx irqs.
CRBLSB		equ	$3E60	;gated clock, no rx/tx irqs, LSB first for JTAG

BCRDEFAULT	equ	$110	;default bcr value
PLLDEFAULT	equ	$40001	;default pll is 8mhz x 10
;*************************************************************************
;	The following equates represent values for TMS so that
;	the JTAG state machine can be sequenced to its proper states.
;	A maximum of 16 bits can be sent from lsb to msb on the upper
;	16 bits of the constant, while the lower 8 bits dictate the
;	number of clocks to toggle.
;*************************************************************************
IDLE_SDR	equ	$800003	;3 clocks from idle to shift-dr
EXIT_IDLE	equ	$800002	;2 clocks from exit1 to idle
IDLE_SIR	equ	$C00004	;4 clocks from idle to shift-ir
JTAG_RESET	equ	$f80005	;5 clocks from anywhere to reset state
JRESET_IDL	equ	$fc0008 ;8 clocks forces jtag reset then to idle state
JRESET_SIR      equ     $fb000a ;10 clocks from jtag reset to shift-ir
SHIFT_EXIT	equ	$800001 ;1 clock from SHIFT to EXIT1
SHIFT_IDLE	equ	$c00003	;3 clocks from shift to idle
RESET_IDLE	equ	$000001 ;1 clock from RESET to IDLE
;*************************************************************************
;	The following equates represent the OS0 and OS1 flag values
;	when the STATPOLL routine is called to examine whether a
;	DSP or group of DSPs have completed their DSP instruction
;	or whether they are in the debug mode.
;*************************************************************************
NORMAL		equ	$0	;DSP running out of internal memory normally
STOP		equ	$1	;DSP is in STOP mode
BUSY		equ	$2	;DSP is busy executing an instruction
				;  (TA/wait states)
DEBUG		equ	$3	;DSP is in debug mode waiting for an instruction
;*************************************************************************
;	The following equates represent the JTAG Instruction Register 
;	in the upper 8 bits and the number of clocks -1 in the lower 8 bits.
;	The assumption in the following codes is that there is only one
;	device to communicate with and the last data clock be toggled when
;	exiting the shift state.
;*************************************************************************
EXTEST		equ	$0003	;extest enables the boundary scan register
SAMPLE		equ	$0103	;sample/preload data or boundary scan outputs
IDCODE		equ	$0203	;IDregister enabled between TDI and TDO
EX_PULLUP	equ	$0303	;extest eanbled with weak pullup on inputs
HIGHZ		equ	$0403	;enable high z on all outputs
CLAMP		equ	$0503	;clamp/bypass last value on outputs
E_ONCE		equ	$0603	;enable once registers onto the TDI and TDO
DEBUG_R		equ	$0703	;send a debug request signal to the core
BYPASS		equ	$0f03	;enable bypass mode
DUMB_CMD	equ	$9e07   ;dummy OnCE command to get OSR value in 8 clocks
READ_OSCR	equ	$8007	;read oscr from onyx/lp16
;****************************************************************************
;	The following equates represent the JTAG Instruction Register
;	in the uppoer 8 bits and the number of clocks in the lower 8
;	bits.  The assumption in the following codes is that there is
;	multiple devices and the serial stream will be terminated by a
;	code which will be -1 clock so the last bit can be shifted when
;	transitioning to exit state.
;****************************************************************************
MEXTEST		 equ	 $0004	;extest enables the boundary scan register
MSAMPLE          equ     $0104   ;sample/preload data or boundary scan outputs
MIDCODE          equ     $0204   ;IDregister enabled between TDI and TDO
MEX_PULLUP       equ     $0304   ;extest eanbled with weak pullup on inputs
MHIGHZ           equ     $0404   ;enable high z on all outputs
MCLAMP           equ     $0504   ;clamp/bypass last value on outputs
ME_ONCE          equ     $0604   ;enable once registers onto the TDI and TDO
MDEBUG_R         equ     $0704   ;send a debug request signal to the core
MBYPASS          equ     $0f04   ;enable bypass mode
MDUMB_CMD        equ     $9e08   ;dummy OnCE command get OSR value in 8 clocks
MREAD_OSCR       equ     $8008   ;read oscr from onyx/lp16

		org	p:$1000
JIRTABLEp	equ	*		;pointer to table
JIRTABLE	dc	*
JIRDATA		bsc	24,4		;space allocated and initilized to 4

;*************************************************************************
;	THE MONITOR ROUTINE GETS COMMANDS FROM THE HOST AND EXECUTES THEM.
;	THE MAIN REASON MOST COMMANDS ARE 9 BYTES LONG IS BECAUSE IT MAKES
;	THE DRIVER SOFTWARE ON THE HOST COMPUTER EASIER TO WRITE AND MAINTAIN.
;	THE FOLLOWING COMMANDS PERTAIN TO USER SOFTWARE/HARDWARE DEBUG.
;
;	     THE COMMAND TYPES ARE:	BYTES IN COMMAND
;		GO IMMEDIATE=10 	9 - command,4 byte PIIB/JMP Opcode,
;						4 byte PDB/JMP Operand
;		GO DELAYED = 11 	10 - command,4 byte PIIB/JMP Opcode,
;						4 byte PDB/JMP Operand, trigger
;		PMEM READ  = 12 	9 - command,4 byte addr. start,
;						4 byte count
;		PMEM WRITE = 13 	9 - command,4 byte addr. start,
;						4 byte count ***block fill***
;		XMEM READ  = 14 	9 - "   "       "
;		XMEM WRITE = 15 	9 - "   "       " ***block fill***
;		YMEM READ  = 16 	9 - "   "       "
;		YMEM WRITE = 17 	9 - "   "       " ***block fill***
;		REG  READ  = 18 	9 - command,4 byte offset,4 byte count
;		REG  WRITE = 19 	9 - "   "       "    "     "    "
;		PMEM WRITE = 1a 	9 - "   "       " ***different values***
;		XMEM WRITE = 1b 	9 - "   "       " ***different values***
;		YMEM WRITE = 1c 	9 - "   "       " ***different values***
;
;	THE FOLLOWING COMMANDS ARE FOR EXECUTION OF USER DEFINED
;	ONCE COMMAND SEQUENCES.  THEY ARE MEANT FOR THE USER TO
;	HAVE DIRECT ACCESS TO THE ONCE PORT FOR DEVELOPING THEIR
;	OWN UNIQUE COMMAND MACROS. THEY ARE ALSO USED FOR ACCESSING
;	ONCE REGISTERS THAT ARE USED TO SET UP BREAKPOINTS AND GIVE
;	CURRENT STATUS OF THE ONCE CONTROLLER.	THESE COMMANDS ARE ALSO
;	USED FOR CONTROLLING THE OnCE HARDWARE BREAKPOINT REGISTERS/COUNTER
;	AND THE TRACE COUNTER.
;
;	   THE COMMAND TYPES ARE:		BYTES IN COMMAND
;		READ ONCE REG.	  	= 1d	3 - command, 1 byte offset,
;							1 byte count
;		WRITE ONCE REG.   	= 1e	3 - command,1 byte offset,
;							1 byte count
;     (Step)	TRACE SEQUENCE	  	= 1f	2 - command,1 byte count
;     (Go)	RUN SEQUENCE	  	= 20	2 - command,1 byte Y mem addr
;		SAVE PIPELINE	  	= 21	1 - command
;
;     (Display) READ SEQUENCE	  	= 22	2 - command,1 byte count
;     (Load)	WRITE SEQUENCE	  	= 23	2 - command,1 byte count
;		READ MISC. REG.   	= 24	2 - command,1 byte offset
;		WRITE MISC. REG.  	= 25	2 - command,1 byte offset
;		FORCE RESET	  	= 26	2 - command, 1 byte reset type
;		FORCE BREAK	  	= 27	1 - command
;		EXECUTE PMEM OVERLAY	= 28	1 - command
;
;               JTAG_RESET_STATE_MACH   = 29    2 - command,1 byte reset type
;               JTAG_BREAK              = 2a    2 - command,1 byte break path
;               JTAG_RESET              = 2b    2 - command,1 byte reset path
;               EXEC_FROM_ADDR          = 2c    3 - command,2 byte address
;
;               READ_FIFO               = 2d    1 - command
;               POLL_STATUS(JTAG)       = 2e    1 - command
;
;
;	THE COMMAND CONVERTER MUST KEEP TABS ON WHEN THE TARGET IS IN
;	THE DEBUG MODE.  FLAGS ACTS AS A STATUS WORD TO KEEP TRACK OF
;	WHEN THE TARGET IS IN DEBUG MODE, NEEDS TO SERVICE A TARGET
;	REQUEST, ETC.  THE DEBUGMODE FLAG IS SET WHEN THE DEBUG REQUEST
;	PIN IS ASSERTED OR WHEN THE TARGET ENTERS THE DEBUG MODE AND
;	REQUESTS SERVICE FROM THE CONVERTER.  THIS FLAG IS CLEARED WHEN
;	THE TRACE,GO OR RESET COMMANDS ARE EXECUTED.
;
;	THERE ARE THREE RESET COMMANDS ON THE ADS USER INTERFACE.
;	ONE IS TO RESET THE COMMAND CONVERTER, ONE IS TO RESET THE TARGET
;	WITH THE DEBUG REQUEST ASSERTED AND THE OTHER IS TO RESET THE TARGET
;	WITH THE DEBUG REQUEST NOT ASSERTED.
;
;*********************************************************************
;	HERE IS WHERE THE MONITOR PROGRAM BEGINS
;
;	FLAGS bit 0 is a flag to indicate the TARGET is in debug mode.
;	FLAGS bit 1 is set whenever the OnCE port asserts the Ack signal.
;	FLAGS bit 2 is a flag for command being executed.  If an abort occurs
;			from the host the registers being used in the 96k must
;			be restored.
;
;	IRQA is used for the ADM_BREAK function.  The ADM_BREAK
;	is a signal generated by the host computer to get the
;	DSP56's attention.  It will cause the stack pointer to
;	be cleared and the monitor program started over.
;
;	IRQB is used for the OnCE acknowledge signal.
;	The OnCE acknowledge signal is used to request service from
;	the host computer.  It will set a bit in the FLAGS register
;	and will remain set until the acknowledge is serviced.
;
;	IRQB will have higher priority than the IRQA.  IRQA will be
;	masked during OnCE communication in order not to lose
;	synchronization with the OnCE port.  A set of transfer
;	registers (R0,R1,R2,M0,M1,M2) on the 96k are used by the
;	monitor during write to/read from 96k memory.  These registers
;	are saved before use and restored when done.  If an IRQA occurs
;	during the time these registers are being used by the monitor,
;	the current activity will be aborted, but the transfer
;	registers will be restored to the 96k.  If a reset is applied
;	to the command converter during a write to/read from 96k
;	memory, the transfer register contents will be lost.
;
;	At the completion of the execution of every command, the monitor and
;	the host go through a handshake sequence to inform the host that
;	the command has been executed.  This same handshake is also performed
;	when coming out of reset in order to inform the host that the monitor
;	program has come up running properly out of reset.
;
;*********************************************************************
;	It should be noted that the reset routine for initialization
;	resides in the overlay area because it's only used once.
;	The get command routine also resides in overlay area, since
;	it is used only once per command, therefore its reloaded 
;	after each overlay command is executed.
;*********************************************************************
;       The initialization routine is overlaid only after reset
;       exit so that the I/O ports can be preset.
;       Note: The overlay area is immediately after the larger of the
;       two polling routines to insure the overlay area is constant.
;       The EPROM must be sequencial however, and requires that when
;       bootloading, the bootloader initializes the RAM to default as
;       a JTAG part.  The GETINIT and GETCMD overlays are called after
;       reset to insure proper loading.
