/*

Freely Distributable Java Applets

Copyright (c) 1996-2001 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Author: Dogu Arifler, Saleem Marwat, and Brian Evans
Version: @(#)ImButtons.java	1.16  04/17/01

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

package utexas.espl.weds.ui;

import java.awt.*;
import java.net.*;
import java.util.*;
import javax.swing.*;
import java.awt.event.*;

public class ImButtons extends JPanel implements ActionListener {

    private boolean pressed_before;

    private JButton cycleButton;
    private JButton debugButton;
    private JButton historyButton;
    private JButton executeButton;
    private JButton stepButton;

    private CommandWindow commandWindow;
    private HistoryWindow histWindow;
    private MainWindow mainWindow;
    private ResponseWindow responseWindow;
    private Simulator simulator =  null;

    // Executes all the commands typed in the command window in one step.
    private void executeCommands(String text) {
        StringTokenizer stk = new StringTokenizer(text, "\n");
        while( stk.hasMoreTokens() ) {
            String command = stk.nextToken();
            String result = simulator.run(command);
            responseWindow.appendText(result);
        }
    }

    public ImButtons( MainWindow f, CommandWindow commwin,
                      ResponseWindow respwin, String gifURL,
                      Simulator sim) {
        setLayout(new GridLayout(1, 5));
        mainWindow = f;
        commandWindow = commwin;
        responseWindow = respwin;
        simulator = sim;
        pressed_before = false;
        try {
          executeButton = new JButton("Evaluate",
              new ImageIcon(new URL(gifURL + "/go.gif")));
          executeButton.setActionCommand("execute");
          executeButton.addActionListener(this);
          stepButton = new JButton("Single step",
              new ImageIcon(new URL(gifURL + "/step.gif")));
          stepButton.setActionCommand("step");
          stepButton.addActionListener(this);
          cycleButton = new JButton("Report cycles",
              new ImageIcon(new URL(gifURL + "/cycle.gif")));
          cycleButton.setActionCommand("cycle");
          cycleButton.addActionListener(this);
          debugButton = new JButton("Enable debugging",
              new ImageIcon(new URL(gifURL + "/debug.gif")));
          debugButton.setActionCommand("debug");
          debugButton.addActionListener(this);
          historyButton = new JButton("Command history",
              new ImageIcon(new URL(gifURL + "/history.gif")));
          historyButton.setActionCommand("history");
          historyButton.addActionListener(this);
        }
        catch (MalformedURLException e) {
          System.out.println("Malformed URL");
        }

        setLayout(new FlowLayout());
        add(executeButton);
        add(stepButton);
        add(cycleButton);
        add(debugButton);
        add(historyButton);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("execute")) {
          String text = commandWindow.getText();
          executeCommands(text);
          commandWindow.setText("");
        }
        else if (e.getActionCommand().equals("step")) {
          responseWindow.appendText(simulator.step());
        }
        else if (e.getActionCommand().equals("debug")) {
          responseWindow.appendText(simulator.enableDebugging());
        }
        else if (e.getActionCommand().equals("cycle")) {
          responseWindow.appendText(simulator.displayCycles());
        }
        else if (e.getActionCommand().equals("history")) {
          String[] history = simulator.getHistory();
          int histSize = simulator.historySize();
          histWindow = new HistoryWindow( mainWindow, commandWindow,
              history, histSize );
        }
    }
}
