/*

Freely Distributable Java Applets

Copyright (c) 1996-2001 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Author: Dogu Arifler, Saleem Marwat, and Brian Evans
Version: @(#)CommandWindow.java	1.7  04/17/01

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

package utexas.espl.weds.ui;

import java.awt.*;
import javax.swing.*;

/* Build a component with a text area and a title */
public class CommandWindow extends JPanel {
    private JTextArea comArea;

    final int TEXT_ROWS = 10;
    final int TEXT_COLUMNS = 20;

    // Constructor
    public CommandWindow() {
        createWindow(TEXT_ROWS, TEXT_COLUMNS);
    }

    // Constructor
    public CommandWindow(int rows, int columns) {
        createWindow(rows, columns);
    }

    private void createWindow(int rows, int columns) {
        comArea = new JTextArea(rows, columns);
        comArea.setFont(new Font("Courier", Font.PLAIN, 12));
        comArea.setLineWrap(true);
        comArea.setWrapStyleWord(true);
        JScrollPane areaScrollPane = new JScrollPane(comArea);
        areaScrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        areaScrollPane.setBorder(
            BorderFactory.createCompoundBorder(
                BorderFactory.createCompoundBorder(
                                BorderFactory.createTitledBorder("Command Window"),
                                BorderFactory.createEmptyBorder(5,5,5,5)),
                areaScrollPane.getBorder()));
        add(areaScrollPane);
    }

    // Appends new text to the text field
    public void appendText(String s) {
        comArea.append(s);
    }

    // Reads the text in the text field
    public String getText() {
        return comArea.getText();
    }

    // Set the text in the text field
    public void setText( String s ) {
        comArea.setText( s );
    }
}
