/*
Copyright (c) 1996-2001 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Programmers: Dogu Arifler, Brian L. Evans, Jun Huang, and Saleem K. Marwat
Version: @(#)Server.java	1.18  04/17/01
*/

/*
See the <WEDS_ROOT>/doc/README.txt file for the details on how to run the
server.  <WEDS_ROOT> is the directory where WEDS is installed.
The general format is

java [options] Server >& Server.out &

To enable debugging, pass

-DDEBUG=true

as an option.  The shell script <WEDS_ROOT>/bin/startServer will automatically
start the server with the right options for a Unix machine.
*/

package utexas.espl.weds.server;

import java.io.*;
import java.net.*;
import java.util.*;
import utexas.espl.weds.ui.WedsConfig;

public class Server {

  public static void main(String[] args) {
    WedsConfig config = new WedsConfig("file:.");
    int SOCKET_NUMBER = config.getPort();
    boolean listening = true;
    ServerSocket server = null;
    try {
      // Create a server socket that can take up to 100 simultaneous requests
      server = new ServerSocket(SOCKET_NUMBER, 100);
    }
    catch (IOException e) {
      System.err.println("Could not listen to port : " + SOCKET_NUMBER +
                         ", " + e.getMessage());
    }
    int numEntry=0;
    while (listening) {
      Socket socketHandle = null;

      try {
        // Block until a request for a socket is made
        socketHandle = server.accept();
      }
      catch (IOException e) {
        System.err.println("Accept failed : " + SOCKET_NUMBER +
                           ", " + e.getMessage());
        continue;
      }

      // Create a new thread to interface the client with the simulators
      new ServerThread(socketHandle, args).start();
    }
  }
}
