//---------------------------------------------------------------------------
//
// %FILE     pic.h
// %VSS-REV  $Revision: 9 $
// %CREATED  1995.12.17
// %REVISED  $Date: 4/18/97 4:17p $
// %AUTHOR   Noreen Bell
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF
// %SUMMARY  Programmable Interrupt Controller header
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:17p $ $Revision: 9 $
//
// DESCRIPTION
//
//   Header for pic.c
//
// INPUTS
//
// HISTORY
//
/*
 *
 * $History: pic.h $ 
 * 
 * *****************  Version 9  *****************
 * User: Miked        Date: 4/18/97    Time: 4:17p
 * Updated in $/nsdemo
 *  New header (comment) changes.
 * 
 * *****************  Version 8  *****************
 * User: Miked        Date: 12/04/96   Time: 4:07p
 * Updated in $/nsdemo
 * Added function prototypes.  Added check to see if this include file was
 * already included.
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 4/18/96    Time: 12:44p
 * Updated in $/nsdemo
 * Revised for initial release.
 * 
 * *****************  Version 2  *****************
 * User: Miked        Date: 4/12/96    Time: 2:29p
 * Updated in $/nstest
 * Revised headers for VSS.
 *
 */
//
// COPYRIGHT
//
//      (c) 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef PIC_H_INC
#define PIC_H_INC

// Required headers

#include "nsglobal.h"

//---------------------------------------------------------------------------
// Function structures

typedef struct {
	BOOL enable;            // masked=0,unmasked=1
	USHORT vector;          // Interrupt Vector Address
	BOOL IRR;               // NoIRQpending=0,IRQpending=1
	BOOL ISR;               // NotInService=0,InService=1
} IRQ_STATUS;

//---------------------------------------------------------------------------
// Register bit definitions

// ICW1 - starts initialization sequence

#define ICW1_ReservedMask0  0xE6   // Bits 7,6,5,2,1 write 0
#define ICW1_ReservedMask1  0x10   // Bit 4 write 1 (identifies ICW1)

#define ICW1_ICW4Needed     1
#define ICW1_NoICW4Needed   0

#define ICW1_LevelTriggered (1<<3)
#define ICW1_EdgeTriggered  0

// predefine the programming of the master and slave PIC

#define ICW1_Master (    ICW1_ICW4Needed \
		      |  ICW1_EdgeTriggered \
		      |  ICW1_ReservedMask1 ) \
		    & ~ICW1_ReservedMask0

#define ICW1_Slave  ICW1_Master

// ICW2 - written after ICW1

// we are setting bits t7-t3 in the control register,
// into the five most significant bits of the vectoring byte and
// the last three ( t2-t0 ) bit are generated from the
// interrupt level (line)
// For example
//        5432 1098 Bit number mod 10
// 0x08 = 0000 1000 reprsents t7 - t3
//    2 =       010 Interrupt Level 2
// 0x0A =      1010 Formed interrupt Vector

#define SETVECTOR(vector)  (vector & (~3))

#define ICW2_Master SETVECTOR(IRQIV_Controller1)
#define ICW2_Slave  SETVECTOR(IRQIV_Controller2)

// ICW3 - written after ICW1 if in cascade mode

// In Master mode this byte reprsents a bit mask of Slave ID
// or interrupt pins that have slaves attached to the Master
// In Slave Mode it is ID number
// So Given Master and Slave
//                  76543210
//      Master Mask 00000100 = Slave "2"
//      The Slave ID is determined by what Interrput control
//      pin the slave connects to on the master.

#define ICW3_Master  0x04
#define ICW3_Slave   0x02

// ICW4 - written after ICW3 (or 2 if in single mode) only if
// requested in ICW1

#define ICW4_ReservedMask0         0xE0   // Bits 7,6,5 write 0
#define ICW4_ReservedMask1         0x01   // Bit 0 write 1

#define ICW4_AutoEOI               (1<<1)
#define ICW4_NormalEOI             0

// Note: bit 2 is don't care if bit 3 is 0. (MS definition)
//#define ICW4_NonBufferedMode       (1<<2)

#define ICW4_NonBufferedMode       0
#define ICW4_BufferedSlave         (2<<2)
#define ICW4_BufferedMaster        (3<<2)

#define ICW4_SpecialFullyNested    (1<<4)
#define ICW4_NotSpecialFullyNested 0

// Predefine the programming of the master and slave PIC for ICW4

#define ICW4_Master (    ICW4_NormalEOI \
		      |  ICW4_NonBufferedMode \
		      |  ICW4_NotSpecialFullyNested \
		      |  ICW4_ReservedMask1 ) \
		    & ~ICW4_ReservedMask0

#define ICW4_Slave   ICW4_Master

// OCW1 - used during operation

// Value to Mask or Allow all interrupts (written to IMR)
#define OCW1_MaskAllInterrupts   0xFF
#define OCW1_AllowAllInterrupts  0
  
// Value to mask interrupts used in HalDisableIRQ - the master leaves
// the cascade IRQ unmasked.
#define IMR_MaskAllIntMaster 0xFB
#define IMR_MaskAllIntSlave  0xFF

// OCW2 - used during operation

// Send EOI to PIC
#define OCW2_NonSpecificEOI (1<<5)
#define OCW2_SpecificEOI    (3<<5)

// OCW3 - used during operation

// Difference between OCW2 and 3 is bit3 Set!
#define OCW3_OCW3bit              (1<<3)

// Programs what read of OCW3 will read (ISR or IRR)
#define OCW3_ReadIRequest         ((1<<1) | OCW3_OCW3bit)
#define OCW3_ReadInServiceStatus  ((3)    | OCW3_OCW3bit)

// Number of IRQs per device - used to determine if Master or Slave PIC
// is to be accessed.
#define IRQ_PER_DEVICE  8

// Number of devices
#define NUM_DEVICES     2

#define MAX_IRQ         (IRQ_PER_DEVICE * NUM_DEVICES) - 1

// Status Bit definitions

#define NotInService    0
#define InService       1
#define NoIRQpending    0
#define IRQpending      1
#define unmasked        0
#define masked          1

//---------------------------------------------------------------------------
// Function prototypes

extern USHORT PIC_Status(USHORT IRQLevel, IRQ_STATUS * pStatus);
extern USHORT PIC_EOI(USHORT IRQLevel);
extern USHORT PIC_Disable(USHORT IRQLevel);
extern USHORT PIC_Enable(USHORT IRQLevel);
extern USHORT PIC_Initialize(void);

//---------------------------------------------------------------------------

#endif // #ifndef PIT_C_INC

//---------------------------------------------------------------------------
// END       pic.h
//---------------------------------------------------------------------------
