//---------------------------------------------------------------------------
//
// %FILE     dramtest.c
// %VSS-REV  $Revision: 14 $
// %CREATED  1996.01.17
// %REVISED  $Date: 4/18/97 4:05p $
// %AUTHOR   Noreen Bell
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF, NS486SXL
// %SUMMARY  Dynamic RAM test module
//
// %VSS      $Author: Miked $ $Date: 4/18/97 4:05p $ $Revision: 14 $
//
// DESCRIPTION
//
//   This module uses the DRAM_Status function to return information
//   on the NS486SXF DRAM controller.
//
// HISTORY
//
/*
 *
 * $History: dramtest.c $
 * 
 * *****************  Version 14  *****************
 * User: Miked        Date: 4/18/97    Time: 4:05p
 * Updated in $/nsdemo
 * Removed unneeded prototype.   New header (comment) changes.
 * 
 * *****************  Version 13  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 12  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 11  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 10  *****************
 * User: Miked        Date: 7/03/96    Time: 3:06p
 * Updated in $/nsdemo
 * Updated to include "dramtest.h".
 * 
 * *****************  Version 9  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 *
 */
//
// COPYRIGHT
//
//      (c) 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#include "dramtest.h"

//---------------------------------------------------------------------------
//
// FUNCTION    DRAM_Info
//
// INPUT       none
// OUTPUT      none
// RETURN      USHORT
//               SUCCESS - if call successful
//               FAIL - if the DRAM function fails
//
// DESCRIPTION
//  This function calls DRAM_Status to get the size of DRAM Bank0 and Bank1
//  to display to the user.
//
//---------------------------------------------------------------------------

USHORT DRAM_Info(void)
{
	DRAMC_STATUS Status;
	DRAMC_STATUS * pStatus = &Status;
	      
	dprintf("DRAM Controller:\r\n");

	if(DRAM_Status(pStatus) == 0)
	{
	   //A return value of zero represents 0.5 MB
	   if(pStatus->BankSize0 == 0)
	      dprintf("  Bank 0: 0.5MB \r\n");
	   if(pStatus->BankSize1 == 0)
	      dprintf("  Bank 1: 0.5MB \r\n\n");
	   else
	   {
	     dprintf("  Bank 0: %dMB\r\n", pStatus->BankSize0);
	     dprintf("  Bank 1: %dMB\r\n\n", pStatus->BankSize1);
	   }
	   return SUCCESS;
	}
	else
	  dprintf("  DRAM status unavailable\r\n\n");
	  return FAIL;

}

//---------------------------------------------------------------------------
// END       dramtest.c
//---------------------------------------------------------------------------
