/***********************************************************************
 *
 *	File name:      dsp.c
 *
 *	Description:	This function (task) is the systems
 *                      "User Interface". At request it displays
 *                      messages on the screen and transmits them
 *                      on the serial port.
 *
 *	Functions:	display()
 *                      initDsp()
 *
 *
 *      Version		Date		ID		Comment
 *	----------------------------------------------------------------
 *	0.1		120188		TEKELEC/IA	first created
 *	1.0		120888		TEKELEC/IA	Demo package
 *
 ***********************************************************************/


#include        <fcntl.h>
#include	"mainSym.h"
#include        "tos.h"




/*
 *	Function:	display()
 *	Description:	This function displays messages on
 *                      the screen and outputs them on the
 *                      auxiliary ports.
 *                      
 *
 *	Inparameters:   initiation structure
 *
 *	Outparameters:  none
 *
 */

display(t)
DSPINIT *t;
    {
    DSPREQ *p;
    byte rec[256];
    int  event;

    p = (DSPREQ *)  rec;

    initDsp(t);

    for(;;)
        {
        event = get_event(t->recKey,rec);
        switch(event)
            {
        case ABORT:  printf(RESET); 
                     return;

	    case DSP_REQ: printf(p->text);
                          sndpa(p->text,(long int) strlen(p->text),0L);
                          sndpa("\r\n\r\n",4L,0L);
                          printf("\n\n");
                          break;

	    default: printf("WARNING: display() received unknowm primitive");
                      printf("\n\n");
                          break;
            }

        }
    } /* end display() */




/*
 *	Function:	initDsp()
 *	Description:	This function initates the display task.
 *                      The message buffers are opened and
 *                      start-up messages are exchanged with
 *                      the coordinator.
 *
 *	Inparameters:   initiation structure
 *
 *	Outparameters:  none
 *
 */


initDsp(t)
DSPINIT *t;
    {

    t->coKey  = crmsb( t->coKey,  MSBGBL+50L );
    t->recKey = crmsb( t->recKey, MSBGBL+50L );

    startUp(t->coKey,t->taskId,t->recKey);

    printf(CLEAR);
    printf(RED);

    } /*  end initDsp  */


/*-------------------      end dsp.c        ----------------*/