/***********************************************************************
 *
 *	File name:  	co.c
 *
 *	Description:    This is the main task of this MTOS-UX demo package.
 *                      The main() function inititates all the i/o ports
 *                      and starts all the tasks.  At shutdown this the
 *                      main function notifies all tasks of termination
 *                      and closes all message buffers.
 *
 *	Functions:	main()
 *
 *      Version		Date		ID	       Comment
 *	----------------------------------------------------------------
 *	0.1		113088		TEKELEC/IA     First created
 *      1.0             120788          TEKELEC/IA     Demo release
 *
 ***********************************************************************/



#include	"mainSym.h"
#include        "tos.h"


extern long int get_dest();




/*
 *
 *    Declaration of tasks.
 *
 */

#define   DSP      1
#define   MA1      2
#define   MA2      3
#define   PORT     4
#define   CO       5


extern int        display(),
                  ma1(),
                  ma2(),
                  portPoll();

extern struct tcd taskDsp,
                  taskMa1,
                  taskMa2,
                  taskPort;

MAINIT            tMa1,
                  tMa2;

DSPINIT           tDsp;

PORTINIT          tPort;


#define   DSPR    'DSPR'
#define   COR     'CORE'
#define   MAR1    'MAR1'
#define   MAR2    'MAR2'
#define   PORTR   'PORT'




main()
    {

    RECEIVE   *p;


    byte     abort,
             sysId[40], 
             rec[256];



    long int msbDsp, 
             msbCo, 
             msbMa1, 
             msbMa2,
             msbPort,
             stDsp,
             stMa1,
             stMa2,
             stPort,
             idDsp,
             idMa1,
             idMa2,
             idPort,
             dest;

    int      event,
             id,
             n;


   initporta(ST1,DB8,F960,PANO);

   printf("Wait 10 s for initiation.........\n\n");

   reset_port(PORTA);
   reset_port(PORTB);    

   pause(SEC+10);  

   setup(PORTA,SIMNT,SYSTEM,IDLE,IDLE,NT_POWER);
   setupLinks(PORTA,linksA);

   setup(PORTB,SIMNT,SYSTEM,IDLE,IDLE,NT_POWER);
   setupLinks(PORTB,linksB);


    p = (RECEIVE *) rec;


    /*
     *
     *     Create message buffers.
     *
     */

    msbDsp = crmsb(DSPR, MSBGBL + 50L);

    msbCo  = crmsb(COR,  MSBGBL + 50L);

    msbMa1 = crmsb(MAR1, MSBGBL + 50L);

    msbMa2 = crmsb(MAR2, MSBGBL + 50L);

    msbPort = crmsb(PORTR, MSBGBL + 50L);



    /*
     *
     *  Initiate DSP record 	
     *
     */

     tDsp.taskId = DSP;
     tDsp.recKey = DSPR;
     tDsp.coKey  = COR;


    /*
     *
     *  Initiate MA1 record 	
     *
     */

     tMa1.portnum = PORTA;
     tMa1.taskId  = MA1;
     tMa1.recKey  = MAR1;
     tMa1.coKey   = COR;

    /*
     *
     *  Initiate MA2 record 	
     *
     */

     tMa2.portnum = PORTB;
     tMa2.taskId  = MA2;
     tMa2.recKey  = MAR2;
     tMa2.coKey   = COR;


    /*
     *
     *  Initiate PORT record 	
     *
     */
 
     tPort.taskId   = PORT;
     tPort.recKey   = PORTR;
     tPort.portAKey = MAR1;
     tPort.portBKey = MAR2;
     tPort.coKey    = COR;

    /*
     *
     *  Set entry points.
     *
     */

    taskDsp.ep  = (long int) display;
    taskMa1.ep  = (long int) ma1;
    taskMa2.ep  = (long int) ma2;
    taskPort.ep = (long int) portPoll;


    /*
     *
     *  Create tasks.
     *
     */

    idDsp = crtsk(&taskDsp);
    idMa1 = crtsk(&taskMa1);
    idMa2 = crtsk(&taskMa2);
    idPort = crtsk(&taskPort);



    /*
     *
     *  Start tasks.
     *
     */


    start(idDsp, INHPTY,&tDsp, &stDsp, CTUNOC);
    start(idMa1, INHPTY,&tMa1, &stMa1, CTUNOC);
    start(idMa2, INHPTY,&tMa2, &stMa2, CTUNOC);
    start(idPort,INHPTY,&tPort,&stPort,CTUNOC);




    /*
     *
     *   Exchange startup message with all tasks.
     *
     */

   n = 0;

   sendStart(msbDsp);
   sendStart(msbMa1);
   sendStart(msbMa2);
   sendStart(msbPort);

   do
       {
       id = getConf(msbCo);
       switch(id)
           {
           case DSP:  n++; 
                      break;
           case MA1:  n++; 
                      break;
           case MA2:  n++; 
                      break;
           case PORT: n++; 
                      break;
           }
       }
while ( n != 4 );

getidn(sysId);
sendDSP_REQ(msbDsp,CO,sysId);

abort = FALSE;

   do
      {
       event = get_event(msbCo,rec);
       switch(event)
           {
	       case TERM_REQ: sendDSP_REQ(msbDsp,CO,p->info);
                              abort = TRUE;
                              break;
	       case DSP_REQ:  sendDSP_REQ(msbDsp,CO,p->info);
                              break;
               case ABORT:    abort = TRUE;
                           sendDSP_REQ(msbDsp,CO,"TERMINATE KEY DEPRESSED\n");
                              break;	
               case AUX_SIG: sendDSP_REQ(msbDsp,CO,"AUX signal received");
                             break;
        default:       sendDSP_REQ(msbDsp,CO,"---- ILLEGAL EVENT:CO---");
                              break;
           }
      }
   while ( abort == FALSE );





   /*
    *
    *  Send abort.
    *
    */ 


   sendTERM(msbDsp);
   sendTERM(msbMa1);
   sendTERM(msbMa2);
   sendTERM(msbPort);

   /* 
    *  wait for i/o reset
    */

   printf("            Wait 5s for reset.....\n\n");
   pause(SEC+5);

    /* 
     *
     *  Delete all message buffers.
     *
     */

     dlmsb(msbDsp);
     dlmsb(msbCo);
     dlmsb(msbMa1);
     dlmsb(msbMa2);
     dlmsb(msbPort);



    } 	/* end main() */



/*-------------------      end co.c        ----------------*/