PRIMARY RATE INTERFACE LIBRARY FILENAME:   libpri.a


GETIME    Gets the number of milliseconds elapsed since the 
          system was started.
          #include mtosux.h
          int getime(msbfr)
          unsigned char *msbfr;


GETPORT   Identifies which port is communicating with the     
          library.
          int getport()
          Returns:
            0=Port A selected
            1=Port B selected.
           -1=Neither port selected.


PRI_VERSION   Returns current verion of the PRI library.
              char *Pri_version();


SETLEDS   Controls which port's LEDs are displayed on the 
          front panel.of a Dual Port machine.
          int setleds(port)
          int port;  0=Port A LEDS displayed
                     1=Port B LEDS displayed
          Returns
            0=Successful
            1=Invalid parameter
            2=Dual Port board not installed


SETPORT   Selects Port A or Port B for library.
          #include <cham.h>
          int  setport(port)
          int port;  0=Port A
                     1=Port B
          Returns
            0=Successful
           -1=Parameter out of range
           -2=Selected Port B, but not available


SETPRIMARY     int  SetPrimary(cmdblock, resblock);
               int cmdblock [14];
               int resblock [14];

               Error codes for resblock[0]:  
               resblock[0]    Meaning
                   0          Successful
                   1          PRI board is not installed
                   2          Setup already done
                   3          Invalid channel number/time slot
                   4          Selection already in use
                   5          Channel already assigned
                  10          Command not implemented

    Setup (* Available for line 1 only)
      cmdblock[0] = 1 (Board A) or cmdblock[0] = 101 (Board B)
      cmdblock[1]   mode     1   Monitor
                             2   Simulate
      cmdblock[2]   framing  1   D4
                             2   ESF
                             3   CEPT
      cmdblock[3]    idle data       8 bit value
      cmdblock[4]    idle signal     2 or 4 bit value
      *cmdblock[5]   DS0x receive    Channel/time slot
      *cmdblock[6]   Codec receive   Channel/time slot
      *cmdblock[7]   DS0y recvr/Xmitter   Channel/time slot
      *cmdblock[8]   Codec Xmitter        Channel/time slot 
      *cmdblock[9]   Milliwatt Xmitter    Channel/time slot 
      *cmdblock[10]  Status line 1  8 bits (see Change Status)
      cmdblock[11]   Status line 2  8 bits (see Change Status)

    Resynchronize
      cmdblock[0] = 2 (Board A) or cmdblock[0] = 102 (Board B)
      Argument   None

    Reset
      cmdblock[0] = 3 (Board A) or cmdblock[0] = 103 (Board B)
      Argument     None


    Channel Functions
      cmdblock[0] = 4 (Board A) or cmdblock[0] = 104 (Board B)
      cmdblock[1]   mode   0   Retain current setup
                           1   Override current setup. 
      cmdblock[2]   selection   1   DS0x receive
                                2   Codec receive
                                3   DS0y transmit
                                4   DS0y receive
                                5   Codec transmit
                                6   Milliwatt transmit
                                7   Reset transmit channel
                                8   Reset receive channel
                                9   Idle data
                               10   Idle signal
      cmdblock[3]   channel (if cmdblock[2]=1 - 8)
                        1 - 24 D4/ESF line 1
                        1 - 31 CEPT  line 1
      cmdblock[3]   idle bits (if cmdblock[2]=9 - 10)
                        8, 4, 2, bits


   Signal Functions
      cmdblock[0] = 5 (Board A) or cmdblock[0] = 105 (Board B)
      cmdblock[1] selection     1   Resynchronize
                                2   Normal
                                3   Repeater
                                4   Alarm
                                5   Transparency (for line 1)
      cmdblock[2]  line number  1   Line 1
                                2   Line 2

    Get Status
      cmdblock[0] = 6 (Board A) or cmdblock[0] = 106 (Board B)
      Argument   None
      
      resblock[1]    0    Synchronized
                     1    Loss of signal
                     2    Yellow Alarm
                     4    Loss of framing

     Change Status
      cmdblock[0] = 7 (Board A) or cmdblock[0] = 107 (Board B)
      cmdblock[1]   line 1 or 2
      cmdblock[2]   status   8 bits:
                    Bit 0 - Zero suppression:   0=Off
                                                1=On 
                    Bit 1 - Reserved
                    Bit 2 - Signaling:   0=Off
                                         1=On 
                    Bit 3 - Data rate (ANSI only):   0=64k
                                                     1=56k
                    Bit 4 - Milliwatt tone (CEPT):   0=820
                                                     1=1020
                    Bit 5 - DS0 Bit Inversion:   0=Off
                                                 1=On 
                    Bit 6 - CRC Enable (CEPT):   0=Off
                                                 1=On
                    Bit 7 - Reserved 


     Enable Trace
      cmdblock[0] = 9 (Board A only)
      cmdblock[1]   8 bits:
                    Bit 0 - Trace I/O to the Hardware:  0=Off
                                                        1=On
                    Bit 1 - Trace Command Block:  0=Off
                                                  1=On
                    Bit 2 - Trace Result Block:   0=Off
                                                  1=On
                    Bit 3 - Trace Configuration:  0=Off
                                                  1=On
                    Bits 4 - 7: Reserved


SETTIME   Sets the timer value.
          int settimer(number,value)
          char number;   0=.01 timer (down)
                         1=.01 timer (up)
                         2=seconds (down)
                         3=seconds (up)
          unsigned int value;       timer setting
          Returns:
            0=Successful
            1=Invalid number
            2=inittime not performed


TIMER     Returns the value of the timer.
          int timer(number)
          int number;  0=.01 (down)
                       1=.01 (up)
                       2=seconds (down)
                       3=seconds (up)

