
STANDARD C LIBRARY FUNCTIONS


abs     #include <stdio.h>
        int abs (i)
        int i;

        Returns the absolute value.  


access  #include <sys/file.h>

        accessible = acess(path, mode)
        int accessible;
        char *path;
        int mode;

        #define R_OK        4/*Test for read permission*/
        #define W_OK        2/*Test for write permission*/
        #define X_OK        1/*Test for execute permission*/
        #define F_OK        0/*Test for presence of file*/

        Determines the accessibility of a file.  
        path points to a path name naming a file.  access 
        checks the named file for accessiblility according 
        to mode, which is an inclusive OR of the bits 
        R_OK, W_OK, and X_OK.  


        Returns    -1    path cannot be found 
                    0    Otherwise a 0 value is returned.


alloca    char *alloca (size)
          unsigned int size;

          Allocates size bytes of space in the stack frame
          of the calling function.  This space is temporary
          and is automatically released upon the return
          of the calling function.

          alloca does not check for stack overflow.  
          The size of the stack is set to the value in
          extern long _stksize when the program starts 
          (default is 8 kbytes).  _stksize should be redefined
          if more space is needed, 


atof    double atof (nptr)
        char *nptr;

        Converts a character string pointed to by nptr 
        to a double-precision floating-point number.  
        The first unrecognized character ends the conversion.  

        Returns 0 String begins with an unrecognized character


atoi, atol, strtol

        int atoi (str)
        char         *str;

        long atol (str)
        char         *str;

        long strtol (str, ptr, base)
        char         *str;
        char         **ptr;
        int         base;

        These functions convert strings to integers. 

        strtol returns as a long integer the value represented
        by the character string str. 

        atol takes the ASCII representation of a number
        and converts it into a long integer.

        atoi takes the ASCII representation of a number
        and converts it into an integer.


bcmp, bcopy, bzero

        int bcmp(block1, block2, len)
        char  *block1, *block2;
        int len;

        int bcopy(source, destin, len)
        char  *source, *destin;
        int len;

        int bzero(block1, len)
        char  *block1;
        int len;

        These functions perform operations on blocks of memory.

        bcmp compares two blocks of memory block1 and block2.  

        bcopy copies the source block of memory to the block
        of memory pointed to by destin.  

        bzero zeroes the memory pointed to by block1.



calloc, lcalloc

        char *calloc (nelem, elsize)
        unsigned int  nelem, elsize;

        char *lcalloc (nelem, elsize)
        unsigned long  nelem, elsize;

        calloc allocates space for an array of nelem elements
        of size elsize. The space is initialized to zeros.

        lcalloc is like calloc but accepts long parameters.

        Return a null pointer if there is no available memory.


clearerr    #include <stdio.h>
            clearerr (stream)
            FILE *stream;

            Resets the error indicator and EOF indicator to
            zero on the named stream.


close   int close (fildes)
        int fildes;

        Closes a file.  fildes is a file descriptor obtained
        from creat or open. 

        Returns     0=Successful
                   -1=Error

creat   int creat (fname, oflag)
        char *fname;
        int oflag;

        Creates a new file or writes to an existing one.

        oflag may be set to O_BINARY to indicate
        the untranslated mode.  No other flag values are
        allowed here (see open).

        creat will fail if an OS error occurs. No process
        may have more than 12 files open simultaneously.  
        This function has been superceded by open with
        the O_CREAT flag.

        Returns    non-negative integer = successful
                  -1=Error


execl   execl (name, arg0, arg1, . . . , argn, 0L)
        char *name;
        char *arg0, arg1, . . . argn;

        Executes a file.  PATH is not evaluated
        from execl.  For example, from the shell, you
        execute the cp (copy) program, as follows:

           %cp x y

        where: cp is arg0, x is arg1 and y is arg2.

        In a program, you use execl to execute the 
        cp program, by entering the following:

            execl("\\bin\\cp" ,"cp" ,"x" , "y" , 0L)

       where: \\bin\\cp is the path, cp is arg0, x is arg1, 
       and y is arg2.


execv   int execv (pathname, argv)
        char *pathname, *argv[ ];

        execv executes a program from the disk.  pathname
        is a pointer to a string which contains the name
        of the program to be executed.

        argv is an array of character pointers to strings,
        creating an argument list that is made available to
        the new program.  


exit,  _exit

        exit (status)
        int  status;

        _exit (status)
        int status;

        These functions terminate a process.

        exit performs cleanup operations before terminating
        the program.

        _exit terminates the program immediately 
        without performing any cleanup operations.


fclose    #include <stdio.h>

          int fclose (stream)
          FILE *stream;

          Writes any buffered data to disk and closes a stream.  
          Returns      0 = Successful
                     EOF = Unsuccessful


ferror  #include <stdio.h>
        int ferror (stream)
        FILE *stream;

        Returns a non-zero when an I/O error has previously
        occurred reading from or writing to the named 
        stream.  Otherwise a zero is returned.  


feof    #include <stdio.h>
        int feof (stream)
        FILE *stream;

        Returns a non-zero when EOF has previously been
        detected reading the named input stream.  Otherwise 
        zero is returned.  


fflush    #include <stdio.h>
          int fflush (stream)
          FILE         *stream;

          Writes any buffered data to disk and clears the 
          input buffer, but does not close the stream.

          Returns      0=Successful
                       EOF=Unsuccessful
fgetc   int fgetc (stream)
        FILE *stream;

        This function returns the next byte from the named 
        input stram and positions the pointer ahead one byte 
        in the stream.  fgetc performs the same function 
        as getc, however it is a true function.  It is 
        slower, but takes less space per invocation.

        EOF is returned when end-of-file or error 
        is encountered.


fgets   #include <stdio.h>
        char *fgets (s, n, stream)
        char *s;
        int n;
        FILE *stream;

        This function reads characters from the stream into an 
        array pointed to by s, until n-1 characters are read, 
        or a new-line character is read and transferred to s, 
        or an EOF is encountered.  The string is terminated 
        with a null character.


fileno  #include <stdio.h>
        int fileno (stream)
        FILE *stream;

        This function fileno returns the integer file 
        descriptor for the named stream.  This function 
        is implemented as a macro and therefore cannot be 
        declared or redeclared.


fopen,  freopen

        #include <stdio.h>
        FILE *fopen (file_name, type)
        char *file-name, *type;

        FILE *freopen (file_name, type, stream)
        char *file_name, *type;
        FILE *stream;

        fopen opens the file named by file_name and 
        associates a stream with it.  It returns a pointer 
        to the FILE structure associated with the stream. 
        file_name points to a character string that 
        contains the name of the file to be opened.  
        type is one of the following:

        r    Open for reading
        w    Truncate or create for writing
        a    Append; open or create for writing at end of file
        r+   Open for update  (reading and writing)
        w+   Truncate or create for update
        a+   Random open for read or write

        freopen substitutes the named file in place of the 
        open stream.  

        fopen can be used to direct output to Chameleon 
        devices: .AUX (Serial Port 2 unformatted data), 
     .TTY (Serial Port 2 formatted data), and .PRT (printer).  


fputc   #include <stdio.h>
        int fputc (c , stream)
        char c;
        FILE *stream;

        fputc writes the character c to the output stream 
        at the current pointer position.  It is similar to 
        putc but it is a true function, it is slower, and 
        takes less space per invocation.

        If successful, the value written is returned. 
        If unsuccessful, EOF is returned.


fputs   include <stdio.h>
        int fputs (s, stream)
        char *s;
        FILE *stream;


        This function writes the null-terminated string, 
        pointed to by s, to stream. The string is not 
        followed by a new-line character.  It does not 
        write out the terminating null character.

        Returns    EOF is returned if an error occurs. This 
                   will happen if output is attempted to a 
                   file not open for writing.


fread    #include <stdio.h>
        int fread (ptr, size, nitems, stream)
        char *ptr;
        int size, nitems;
        FILE *stream;

        This function is for binary input.  It places into 
        an array nitems of data read from the input 
        stream beginning at ptr.  The data items are a 
        sequence of bytes of length size. 

        Reading is stopped when an error occurs, end-of-file 
        is encountered, or nitems of data have been 
        read.  fread places the pointer, if any, at the 
        byte following the last byte read, if one exists. 
        The contents of the stream are not changed.

        fseek or rewind must be called before switching 
        between reading and writing on a stream that 
        allows both.

        Returns  the number of items read. If a non-positive 
                 number is given for nitems, then a 0 is 
                 returned and nothing is read.


free    free (ptr)
        char *ptr;

        This function makes space, pointed to by ptr 
        (and formerly allocated by malloc, lmalloc, 
        calloc or lcalloc,) available for further 
        allocation. free does not affect the contents 
        of the space.


fseek   #include <stdio.h>
        int fseek (stream, offset, ptrname)
        FILE *stream;
        long offset;
        int ptrname;

        This function sets the position of the next input 
        or output operation on the stream. The new position 
        is at the signed distance offset bytes from 
        the beginning, from the current position, or from 
        the end of the file, depending on the value of 
        ptrname.  ptrname has the following values:

                0        Offset from beginning of file
                1        Offset from current position in file
                2        Offset from end of file

        fseek undoes the effects of ungetc.  After fseek, 
        the next operation to the file may be either 
        input or output.

        Returns        0=Successful
                       Non-zero=Unsuccessful.  


ftell   #include <stdio.h>
        long ftell (stream)
        FILE *stream;

        This function returns the offset of the current 
        byte relative to the beginning of the file 
        associated with the named stream.


fwrite     #include <stdio.h>
           int fwrite (ptr, size, nitems, stream)
           char *ptr;
           int size, nitems;
           FILE *stream;

           This function is for binary output.  It attempts 
           to append nitems of data from the array pointed to 
           by ptr to the named output stream.

           fseek or rewind must be called before switching 
           between reading and writing on a stream that 
           allows both.


        Returns   Returns the number of items written. 
                  If a non-positive number is given for nitems, 
                  then a 0 is returned and nothing is written.


getc    #include <stdio.h>
        int getc (stream)
        FILE *stream;

        This function returns the next byte from the named 
        input stream and positions the pointer ahead one 
        byte in stream.  getc is a macro and cannot be 
        used where a function is required.  For example, 
        a function pointer cannot point to it.

        Returns     EOF is returned when end-of-file 
                    or error is encountered.


getchar  #include <stdio.h>
         int getchar()

         getchar is a macro that returns the next character
         from the standard input stream, stdin.  

         The character is returned to the program only 
         after pressing Return.  

         Returns        EOF  end-of-file or error


gets   #include <stdio.h>
       char *gets (s)
       char *s;

       This function reads characters from the standard 
       input stream, stdin, into the array pointed to by s, 
       until an end-of-file or new-line character 
       is encountered.  The new-line character is discarded 
       and the string is terminated with a null character.


getw   int getw (stream)
       FILE *stream;

       getw returns the next word (integer) from the 
       named input stream. The file pointer is positioned 
       at the next word. No special alignment is assumed.


isalnum, isalpha, isascii, iscntrl, isdigit, islower,
isprint, ispunct, isspace, isupper, isxdigit

       #include <ctype.h>
       int c;

       int isalnum(c)       c is alphanumeric
       int isalpha(c)       c is a letter
       int isascii(c)       c is an ASCII character
       int iscntrl(c)       c is a delete character (0177) 
                            or an control character < than 040
       int isdigit(c)       c is a digit
       int islower(c)       c is a lower case letter
       int isprint(c)       c is a printing character, 040 
                            (space) through 0176 (tilde)
       int ispunct(c)       c is a punctuation character 
                            (neither control nor alphanumeric)
       int isspace(c)       c is a space, tab, carriage return, 
                            new-line, or formfeed
       int isupper(c)       c is an upper case letter
       int isxdigit         c is a hexadecimal digit


lseek    long lseek (fildes, offset, whence)
         int fildes;
         long offset;
         int whence;

         This function moves the read/write file pointer.  
         It sets the file pointer associated with fildes, 
         by offset from the position specified by whence.  
         whence has the following values:

         0  Pointer set to offset bytes
         1  Pointer set to current position plus offset bytes
         2  Pointer set to file size plus offset bytes


longjmp    #include <stdio.h>
           longjmp (env, val)
           jmp-buf env;
           int val;


          This function is a non-local goto.   longjmp restores 
          the environment saved by the last call of setjmp with
          the same env argument.  After longjmp is called, 
          program execution continues as if the corresponding 
          call of setjmp had just returned the value val.  



malloc, lmalloc

       char *malloc (size)
       unsigned int size;

       char *lmalloc (size)
       unsigned long size;


       This function returns a pointer to a block of at 
       least size bytes aligned for any use. The size parameter 
       limits the size of the block to 64K.

       lmalloc is like malloc but accepts a long 
       parameter, allowing more than 64K bytes per allocation.



onexit    onexit(f)
          int  (*f) ( );


         onexit allows the user to add logic to the exit() 
         function.  When a program is terminated normally 
         or abnormally (using ^C, kill, or the Applications
         Selection menu), the exit() function is called, which
         calls up to 10 functions defined by the user. 
         These functions can be defined by giving the function 
         pointer to onexit().  


open   #include <fcntl.h>
       int open (fname, oflag)
       char *fname;
       int oflag;

       This function opens a file for reading or writing as 
       specified by oflag.  fname points to a string 
       containing the name of the file file.  oflag values 
       are constructed by ORing flags from the following 
       list (only one of the first three may be used):

       0-RDONLY        Open for reading only.
       0-WRONLY        Open for writing only.
       0-RDWR          Open for reading and writing.
       0-BINARY        Open in binary (untranslated) mode.  


printf, fprintf, sprintf, _fprintf, _sprintf

       #include <stdio.h>
       int printf (format [ , arg] . . . )
       char *format;

       int fprintf (stream, format [ , arg] . . . )
       FILE * stream;
       char *format;

       int sprintf (s, format [ , arg] . . . )
       char *s, format;

       int _fprintf(stream, format, args)
       FILE *stream;
       char *format, *args;

       int _sprintf(s, format, args)
       char *s, *format, *args;

       These functions print formatted output, as described 
       below.  All buffers passed to printf() are limited to 
       256 characters.

       printf outputs on the standard output stream stdout.
       fprintf places output on the named output stream.  

       _fprintf is like fprintf except the arguments 
        are retrieved from the pointer args.

       sprintf places "output", followed by a null character 
       (\O) in consecutive bytes starting at *s.  

       _sprintf works like sprintf except the arguments 
       are retrieved from the pointer args, which 
       normally points into the stack.

       Each function returns the number of characters 
       transmitted (not including \0 for sprintf), 
       or a negative value if an output error was encountered. 


perror     perror(s)
           char  *s;

           extern int sys_nerr;
           extern char *sys_errlist[];


           perror writes a short  of the last error that set 
           errno onto the standard stream stderr.  The string s 
           is printed first, then a colon, then the message and 
           a newline.  


putc   #include <stdio.h>
       int putc (c , stream)
       char c;
       FILE *stream;

       putc is a macro that writes the character c 
       to the output stream at the current pointer position.  


putchar    #include <stdio.h>
           int putchar (c)
           char c;

           putchar is a macro that is defined as 
           putc(c, stdout).  (putc is a macro that writes the 
           character c to the output stream at the 
           current pointer position. 



puts   include <stdio.h>
       int puts (s)
       char *s;


       puts writes the null-terminated string, pointed to by s, 
       to the standard output stream stdout. The string 
       is followed by a new-line character.  It does not 
       write out the terminating null character.


putw   #include <stdio.h>
       int putw (w, stream)
       int w;
       FILE *stream;

       putw writes the word (integer) w to the output stream 
       at the current pointer position.  putw does not 
       force even alignment on the file.


qsort   qsort(base, nelem, width, compare)
        char *base;
        int nelem, width;
        int (*compare) ();


        qsort is an implementation of the quicksort algorithm. 
        The parameter base is a pointer to the base of the 
        data.  The parameter nelem is the number of elements in 
        the array.  The parameter width is the width of each 
        element in bytes.  The parameter compare is a pointer 
        to the comparison routine to be called.  


rand
srand

       #include <stdio.h>
       int rand()

       srand(seed)
       long seed;

       rand and srand are macros that function as simple 
       random-number generators.

       rand uses a multiplicative congruential random-number 
       generator.

       srand can be called at any time to reset the random-
       number generator to a new starting point. The generator 
       is initially seeded with a value of 1.


read   int read (fildes, buf, nbyte)
       int fildes;
       char *buf;
       unsigned nbyte;

       read attempts to read nbyte bytes from the file 
       associated with fildes into the buffer pointed to 
       by buf.  fildes is a file descriptor obtained by using 
       an open or creat.


realloc, lrealloc

       char *realloc(ptr, size)
       char       *ptr;
       unsigned size;

       char *lrealloc(ptr, size)
       char       *ptr;
       unsigned long        size;

       These are RAM allocator functions.  realloc changes 
       the size of the block pointed to by ptr to size 
       bytes and returns a pointer to the (potentially moved) 
       block.  Note that the data will remain unchanged, 
       and any data defined beyond size will be lost.

       lrealloc is like realloc but accepts a long parameter.


rename    int rename (from, to)
          char *from, *to;

          rename changes the existing name of a file on a 
          disk to another name.


rewind    #include <stdio.h>
          rewind (stream)
          FILE *stream;

          rewind sets the position of the next input or output 
          operation on the stream.  The new position is at the 
          signed distance offset bytes from the beginning, from 
          the current position, or from the end of the file. 
          rewind is equivalent to fseek(stream, OL, 0), except 
          no value is returned.  rewind undoes the effects of 
          ungetc.  After rewind the next operation to the 
          file may be either input or output.



scanf, fscanf, sscanf

       #include <stdio.h>
       int scanf (format [ , pointer] . . . )
       char *format;

       int fscanf (stream, format [ , pointer] . . . )
       FILE *stream;
       char *format;

       int sscanf (s, format [ , pointer] . . . )
       char *s, *format;

       Each function reads characters, converts them according 
       to a format, and stores the results in its arguments. 
       The arguments consist of a control string format and 
       a set of pointer arguments indicating where the 
       converted input should be stored.

       scanf reads from the standard input stream stdin.
       fscanf reads from the named input stream.
       sscanf reads from the character string s.


setbuf, setbuffer, setlinebuf 

       #include <stdio.h>

       setbuf (stream, buf)
       FILE *stream;
       char *buf;
       char buf[BUFSIZE];

       setbuffer (stream, buf, bufsize)
       FILE *stream;
       char *buf;

       setlinebuf(stream)
       FILE *stream


setjmp     #include <stdio.h>
           int setjmp (env)
           jmp_buf env;

          This is a non-local goto which is useful for 
          dealing with errors and interrupts encountered in 
          a low-level subroutine of a program.  setjmp 
          saves its stack environment in env (whose 
          type, jmp_buf, is defined in the <stdio.h> 
          header file), for later use by longjmp. 


strcat,  strncat,  strcmp,  strncmp,  strcpy, strncpy,  
strlen,  index,  rindex, xtrncat, xtrcpy, xtrncpy

       #include <string.h>

       char *strcat (s1, s2)       char *strcpy (s1, s2)
       char *s1, *s2;       char *s1, *s2;

       char *strncat (s1, s2, n)       char strncpy (s1, s2, n)
       char *s1, *s2;       char *s1, *s2;
       int n;       int n;

       int strcmp (s1, s2)       int strlen (s)
       char *s1, *s2;       char *s;

       int strncmp (s1, s2, n)       char *xtrcat(s1, s2)
       char *s1, *s2;       char *s1, *s2;
       int n;       

       int index (s, c)       char *xtrcpy(s1, s2)
       char *s, c;       char *s1, *s2;

       int rindex (s, c)       char *xtrncpy(s1, s2)
       char *s, c;       char *s1, *s2;

       These functions perform string operations as described 
       below.  The arguments s1, s2, and c point to 
       strings (arrays of characters terminated by a 
       null character).  The functions strcat, strncat, 
       strcpy, strncpy, xtrcat, xtrcpy, and xtrncpy 
       all alter s1. 
toupper, tolower, -tolower, toascii

       #include <ctype.h>

       int toupper (c)
       int c:

       int tolower (c)
       int c;

       int _tolower (c)
       int c;

       int toascii (c)
       int c;

       The range for toupper and tolower is -1 to 255.

       If the argument for toupper is a lower case letter, 
       the result is a corresponding upper case letter.

       If the argument for tolower is an upper case letter, 
       the result is a corresponding lower case letter.

       _tolower is similar to tolower but has a smaller 
       domain and is faster.  

       toascii returns the argument with all but the low 
       order 7 bits set to zero.



ungetc     #include <stdio.h>
           int ungetc (c, stream)
           char c;
           FILE *stream;

 
           This function pushes the character c into the buffer 
           associated with an input stream.  c will be returned 
           by the next read from that stream.  c is returned 
           and the stream is left unchanged.



unlink     int unlink (fname)
           char *path;

           This function removes the directory entry pointed 
           to by fname.  The named file is unlinked unless 
           the operating system returns an error (see errno).


write  int write(fildes, buf, nbyte)
       int fildes;
       char *buf,
       unsigned nbyte;

       This function writes on a file.  It writes nbyte 
       bytes from the buffer pointed to by buf to the 
       file associated with the fildes.

       fildes is a file descriptor obtained from a 
       creat or open.

       If successful, the number of bytes actually 
       written is returned.  If unsuccessful, -1 is returned 
       and errno is set appropriately.
 
