/******************************************************************
* File       : x25lib.h
* Module     : Interface procedures for HDLC, x25 simulator
* Author     : Erik von der Marwitz
* Date       : 08-29-89
* Version    : 0.01
******************************************************************/

#define uch	unsigned char
#define ush	unsigned short
#define uint	unsigned int
#define ulong	unsigned long

#define aiNone		60	/* Application inform values */
#define aiCallSetup	61
#define aiCallRej	62
#define aiCallCleared	63
#define aiData		64
#define aiResetLCN	65
#define aiQuit		66
#define aiRestart	67
#define aiCallAcc	68
#define aiStart		69
#define aiDiag		70
#define aiIntrupt	71
#define aiLink		72
#define aiCallLCN	73
#define aiRegister	74

#define airTimout	1
#define airInternal	2
#define airCollision	3
#define airCallRej	4
#define airRest_r1	5
#define airRest_r3	6
#define airNoLCN	7
#define airLinkDown	8
#define airLinkUp	9
#define airBadState	10

typedef struct {
	uch	Q_Bit;
	uch	D_Bit;
	uch	M_Bit;
	uch	LCGN;
	uch	LCN;
	uch	*pClgAd;   /* Calling DTE Address in ASCII */
	uch	*pCldAd;   /* Called  DTE Address in ASCII */
	uch	FacLen;    /* Facilities length */
	uch	*pFacil;   /* Facilities */
	uint	RegLen;    /* Registration length */
	uch	*pReg;     /* Registration */
	uint	UD_Len;    /* User Data length */
	uch	*pUserData;
	uch	Cause;
	uch	Diag;
	ush	DiagExpLen;
	uch	*pDiagExp; /* Diag Explanation */
	ush	RetVal;    /* Return Value */
	ush	ReqType;   /* Request Type */
        int     RefNo;
} ACB; /* Application Contents Block */

/*----------------------------------------------------------------*/

#define DCE		0
#define DTE		1
#define ISDN		2
#define NETWORK		0
#define SUBSCRIBER	1
#define PORTA		0
#define PORTB		1
#define NRZ		0
#define NRZI		1
#define RESTART		0
#define STOP		1
#define MOD8		8
#define MOD128		128
#define	CCITT		0
#define	TRANSPAK	1
#define	AUTO_ANS  	0
#define	MANUAL_ANS  	1

typedef struct {

	ulong	Baud;
	uch	Encoding;
	uch	DC_TE;
	uch	Net_Sub;
	uch	Interface;
	int	ReTxN2;
	uch	T1;
	uch	LinkWin;
	int	Port;
	uch	PackWin;
	int	MaxFrmSizeN1;
	uch	ModVal;            /* 8 or 128 */
	ush	No_of_SVCs;
	ush	No_of_PVCs;
	uch	Standard;
	int	MaxPackSize;
	int	Answer;        /* 0 = Auto 1 = Manual */

} LPB;	/* Link Parameter Block */

/*----------------------------------------------------------------*/

#define _MS	0x100L   /* Redefine mtos-ux units for speed */
#define _TMS	0x200L
#define _HMS	0x300L
#define _SEC	0x400L
#define _MIN	0x500L
#define _HRS	0x600L
#define _DAY	0x700L
