/*************************************************************
file : x25.h
date : Dec 28th 1989
Author : Gilles Lejeune
desc : x25 include file
*************************************************************/

/* command between control task and hdlC task */

#define	HL_SLON	0
#define HL_SLOF	1

/********** packet types ************/

#define	PT_CR	0x0b	/* call request */
#define PT_CA	0x0f	/* call accepted */
#define	PT_CLR	0x13	/* clear request */
#define PT_CLC	0x17	/* clear confirm */
#define PT_IT	0x23	/* interrupt */
#define PT_ITC	0x27	/* interrupt confirm */
#define PT_RR	0x01	/* receive ready */
#define PT_RNR	0x05	/* receive not ready */
#define PT_REJ	0x09	/* reject */
#define PT_RES	0x1b	/* reset */
#define PT_REC	0x1f	/* reset confirm */
#define PT_RST	0xfb	/* restart */
#define PT_RSTC 0xff	/* restart confirm */
#define PT_DIAG 0xf1	/* diagnostic */
#define PT_DT	0x00	/* data */

/******** X25 packet description structure ******/

#define	uchar	unsigned char

struct	x25_st	{
		uchar	x25_q ;	/* q bit */
		uchar	x25_d ;	/* d bit */
		uchar	x25_mod ;	/* modulo */
		uchar	x25_lcgn ;	/* lcgn */
		uchar	x25_lcn ;	/* lcn */
		uchar	x25_type ;	/* type */
		uchar	x25_ps ;	/* P(S) */
		uchar	x25_pr ;	/* P(R) */
		uchar	x25_m ;		/* More bit */
		uchar	*x25_cga ;	/* pointer on calling address */
		uchar	x25_cgal ;	/* length on calling address */
		uchar	*x25_cda ;	/* pointer on called address */
		uchar	x25_cdal ;	/* length of called address */
		uchar	*x25_data ;	/* pointer on data */
		uchar	x25_dtl ;	/* data length */
		} ;

