const	MAX_PRED_NAME = 10;
		MAX_OBJ_NAME = 10;
		IN_STR_LEN = 79;
		LEFT_PAREN = #40;
		RIGHT_PAREN = #41;
		COMMA = #44;

type	pred_rec_ptr = ^pred_rec;
		link_ptr = ^link;
		arg_rec_ptr = ^arg_rec;
		obj_rec_ptr = ^obj_rec;
		p_name = string[ MAX_PRED_NAME ];
		o_name = string[ MAX_OBJ_NAME ];

		pred_rec = record
						name: p_name;
						next: pred_rec_ptr;
						num_of_arg: byte;
						arg_list: link_ptr;
					  end;

		link =	 record
						next: link_ptr;
						prev: link_ptr;
						arg_ptr: arg_rec_ptr;
					 end;

		arg_rec = record
						next: arg_rec_ptr;
						prev: arg_rec_ptr;
						obj_ptr: obj_rec_ptr;
					 end;

		obj_rec = record
						next: obj_rec_ptr;
						prev: obj_rec_ptr;
						name: o_name;
					 end;

var	pred, predicate_list: pred_rec_ptr;
		object_list: obj_rec_ptr;
		pred_name: string[ MAX_PRED_NAME ];
		in_str: string[ IN_STR_LEN ];
		in_len, i, arg_num: integer;
		tail: link_ptr;
		a_name: o_name;
		temp_arg_ptr: arg_rec_ptr;

function get_tail ( p: pred_rec_ptr ): link_ptr;
	var	temp, tail: link_ptr;
	begin
		(* This procedure originally was to find the tail of  *)
		(* the list, but it is easier to insert at the front. *)
		new( tail );
		temp := p^.arg_list;
		p^.arg_list := tail;
		tail^.next := temp;
		tail^.arg_ptr := NIL;
		get_tail := tail;
	end;

function lookup_p ( pn: p_name ): pred_rec_ptr;
	var	p, temp: pred_rec_ptr;
	begin
		if predicate_list = NIL
			then
				begin
					new(p);
					p^.arg_list := NIL;
					p^.name := pn;
					p^.next := NIL;
					lookup_p := p;
					predicate_list := p;
				end
			else
				begin
					temp := predicate_list;
					while ( temp^.next <> NIL ) and ( temp^.name <> pn ) do
						temp := temp^.next;
					if temp^.name = pn
						then lookup_p := temp
						else
							begin
								new(p);
								p^.arg_list := NIL;
								p^.name := pn;
								p^.next := NIL;
								lookup_p := p;
								temp^.next := p;
							end;
				end;
	end;

procedure dump_predicates;
	var	p: pred_rec_ptr;
			l: link_ptr;
			a: arg_rec_ptr;
	begin
		p := predicate_list;
		writeln( '-- Predicates --' );
		while p <> NIL do
			begin
				writeln( '   ', p^.name );
				l := p^.arg_list;
				repeat
					a := l^.arg_ptr;
					write( '      ' );
					repeat
						write( a^.obj_ptr^.name, '  ' );
						a := a^.next;
					until a = NIL;
					writeln( '' );
					l := l^.next
				until l = NIL;
				p := p^.next;
			end;
	end;

function lookup_a ( on: o_name ): obj_rec_ptr;
	var	o: obj_rec_ptr;
	begin
		new( o );
		o^.name := on;
		lookup_a := o;
	end;

function get_arg_name ( var i: integer ): o_name;
	var	arg_name: o_name;
			offset: integer;
	begin
		offset := i - 1;
		while ( in_str[i] <> COMMA ) and ( i < in_len ) do
			begin
				arg_name[i-offset] := in_str[i];
				i := i + 1;
			end;
		arg_name[0] := chr( i - offset - 1 );
		if ( in_str[i] <> COMMA ) and ( in_str[i] <> RIGHT_PAREN )
			then writeln( 'Expected comma or closing parenthesis' )
			else i := i + 1;
		get_arg_name := arg_name;
	end;

procedure process_a_line;
	begin
		write( '->' );
		readln( in_str );
		in_len := length( in_str );
		i := 1;
	
		(* Get the name of the predicate. *) 
		while ( in_str[i] <> LEFT_PAREN ) and ( i <= MAX_PRED_NAME ) do
			begin
				pred_name[i] := in_str[i];
				i := i + 1;
				if i = in_len then writeln( 'Incomplete input' );
			end;
		pred_name[0] := chr( i - 1 );
	
		if in_str[i] <> LEFT_PAREN
			then writeln( 'Expecting left parenthesis' );
		i := i + 1;
	
		pred := lookup_p( pred_name );		(* Find the predicate...         *)
		tail := get_tail( pred );				(* and the end of its arguments. *)

		repeat
			new( temp_arg_ptr );								(* Build new record...   *)
			a_name := get_arg_name(i);						(* get argument name...  *)
			temp_arg_ptr^.obj_ptr := lookup_a(a_name);(* find it in obj list...*)
			temp_arg_ptr^.prev := tail^.arg_ptr;		(* make connection...    *)
			tail^.arg_ptr := temp_arg_ptr;				(* and move on.          *)
		until i >= in_len;

		(* Cauterize the end. *)
		tail^.arg_ptr^.next := NIL;

		(* Turn singly-linked list into doubly linked list. *)
		while tail^.arg_ptr^.prev <> NIL do
			begin
				tail^.arg_ptr := tail^.arg_ptr^.prev;
				tail^.arg_ptr^.next := temp_arg_ptr;
				temp_arg_ptr := tail^.arg_ptr;
			end;
	end;

begin
	predicate_list := NIL;
	process_a_line;
	process_a_line;
	process_a_line;
	dump_predicates;
end.
if in_str[i] <> LEFT_PAREN
			then writeln( 'Expecting 