#if defined(SCCS_ID)
static char Sccs_Id[] = 
	"5/17/89  @(#)soc43.c	1.1  13:54:14";
#endif

/*
   (c) Copyright 1989 by Locus Computing Corporation.  ALL RIGHTS RESERVED.

   This material contains valuable proprietary products and trade secrets
   of Locus Computing Corporation, embodying substantial creative efforts
   and confidential information, ideas and expressions.  No part of this
   material may be used, reproduced or transmitted in any form or by any
   means, electronic, mechanical, or otherwise, including photocopying or
   recording, or in connection with any information storage or retrieval
   system without permission in writing from Locus Computing Corporation.
*/

/*
   xln.c - Excelan interface for xanswer
*/


#include <stdio.h>
#include <sys/types.h>
#include <sys/types.tcp.h>
#include <sys/socket.h>
#include <netinet/in.h>

int
NetWaitCon(port)
int port;
{
    int sock;
    int ns;
    struct sockaddr_in sin;
    int addrlen;
    
    /*
       Set up address
    */
    memset(&sin, 0, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_port = htons(port);
    sin.sin_addr.s_addr = INADDR_ANY;
    
    
    /*
       Open a socket
    */
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock == -1) {
#ifdef DEBUG
        fprintf(stderr, "socket call failed\n");
#endif
	return -1;
    }
    if (bind(sock, &sin, sizeof(sin)) == -1) {
#ifdef DEBUG
	fprintf(stderr, "bind failed\n");
#endif
	return -1;
    }
    if (listen(sock, 1) == -1) {
#ifdef DEBUG
	fprintf(stderr, "listen failed\n");
#endif
	return -1;
    }
    
    /*
       Wait for a connection
    */
    addrlen = sizeof(sin);
    ns = accept(sock, &sin, &addrlen);
    if (ns == -1) {
#ifdef DEBUG
	fprintf(stderr, "accept failed\n");
#endif
    }
    close(sock);
    
    return ns;
}

int
NetRead(sock, buf, size)
int sock;
char *buf;
int size;
{
    return recv(sock, buf, size, 0);
}

void
NetClose(sock)
int sock;
{
    close(sock);
}

void
NetError(prefix)
char *prefix;
{
    perror(prefix);
}
