/*	SCCSID(@(#)ipc.h	5.1	LCC)	 Modified: 3/26/90 19:05:37 */
/*	@LCCID(ipc.h, 5.1, 3/26/90, 19:05:37) */
/*
 * Interprocess Communication Constants and Structures
 * This file is a concatenation of ipc.h and msg.h
 */

/* History:
   [11/20/87 PD] Updated from /pcid/dos/2_8_6/oemlib/ipc.h - no
   	code changes.
*/


#define key_t long
#define time_t long 

/*
 * Message buffer structure
 */

struct msg {
  long   msg_type;			/* message type 	*/
  short  msg_ts;			/* message text size	*/
  short  msg_spot;			/* message text map addr*/
  struct msg  *msg_next;		/* ptr to next msg on q */
};

struct msgbuf {
	long    mtype;
	char	*mtext;
};

/* 
 *	Common IPC Access Structure 
 */

struct ipc_perm {
	USHORT	uid;	/* owner's user id */
	USHORT	gid;	/* owner's group id */
	USHORT	cuid;	/* creator's user id */
	USHORT	cgid;	/* creator's group id */
	USHORT	mode;	/* access modes */
	USHORT	seq;	/* slot usage sequence number */
	key_t	key;	/* key */
};

/*
 *	Message Queue Id Data Structure
 */

struct msqid_ds {
	struct ipc_perm	msg_perm;	/* operation permission struct */
	time_t		msg_stime;	/* last msgsnd time */
	time_t		msg_rtime;	/* last msgrcv time */
	time_t		msg_ctime;	/* last change time */
	USHORT		msg_cbytes;	/* current # bytes on q */
	USHORT		msg_qnum;	/* # of messages on q */
	USHORT		msg_qbytes;	/* max # of bytes on q */
	USHORT		msg_lspid;	/* pid of last msgsnd */
	USHORT		msg_lrpid;	/* pid of last msgrcv */
	short		dummy;		/* struct ends on dword boundary */
};


/*
 *	There is one semaphore structure for each semaphore in the system.
 */

struct sem {
	USHORT	semval;		/* semaphore text map address */
	short	sempid;		/* pid of last operation */
	USHORT	semncnt;	/* # awaiting semval > cval */
	USHORT	semzcnt;	/* # awaiting semval = 0 */
};

/*
 *	There is one semaphore id data structure for each set of semaphores
 *		in the system.
 */

struct semid_ds {
	struct ipc_perm	sem_perm;	/* operation permission struct */
	time_t		sem_otime;	/* last semop time */
	time_t		sem_ctime;	/* last change time */
	USHORT		sem_nsems;	/* # of semaphores in set */
	short		dummy;		/* struct ends on dword boundary */
};

/*
 *	Semaphore structures
 */

struct sembuf {
	USHORT	sem_num;
	short	sem_op;
	short	sem_flg;
	short	dummy;			/* struct ends on dword boundary */
};

/* Common IPC Definitions. */

#define MSG_NOERROR	0010000		/* no error reported if msg too big */

/* Mode bits. */

#define	IPC_ALLOC	0100000		/* entry currently allocated */
#define	IPC_CREAT	0001000		/* create entry if key doesn't exist */
#define	IPC_EXCL	0002000		/* fail if key exists */
#define	IPC_NOWAIT	0004000		/* error if request must wait */

/* Keys. */

#define	IPC_PRIVATE	(key_t)0	/* private key */

/* Control Commands. */

#define	IPC_RMID	0	/* remove identifier */
#define	IPC_SET		1	/* set options */
#define	IPC_STAT	2	/* get options */

/* Semctl Command Definitions */

#define GETNCNT 3	/* get semncnt */
#define GETPID  4	/* get sempid */
#define GETVAL  5	/* get semval */
#define GETALL  6	/* get all semvals */
#define GETZCNT 7	/* get semzcnt */
#define SETVAL  8	/* set semval */
#define SETALL  9	/* set all semvals */


/* Semaphore Operation Flags */

#define SEM_UNDO 010000

/* Semaphore Permission Definitions */

#define SEM_A	 0200
#define SEM_R	 0400

/*
 * Extended Protocol Header for Locus Computing Corporation PC-Interface
 * Bridge.
 */

struct msgget_type {
	key_t	key;
	long	flag;
};

struct msgsnd_type {
	long	id;
	long	size;
	long	flag;
	struct  msgbuf  message;
};

struct msgrcv_type {
	long 	id;
	long	size;
	long	flag;
	long	type;
	struct  msgbuf  message;
};

struct msgctl_type {
	long	id;
	long	command;
	struct  msqid_ds *buffer;
}; 

struct semget_type {
	key_t	key;
	long	number;
	long	flag;
};

struct semop_type {
	long	id;
	long	number;
	struct sembuf *ops;
};

struct semctl_type {
	long	id;
	long	number;
	long	command;
	union semnum 
	{
	  long val;
	  struct semid_ds buf;
	  USHORT *array;
	  USHORT abuf[sizeof(struct semid_ds)/sizeof(USHORT)];
	} *arg;
};
