C	  DISK TO DISK COPY PROGRAM & VERIFIER
C	  USES ASYNCHRONOUS I/O SUBROUTINES SUPPLIED BY SYSF4 FORTRAN
C	  TO SPEED UP THE I/O PROCESS
C	  WRITTEN BY MICHAEL LAMPI     4-8-79
C
	INTEGER BUFCMP(4096)
	INTEGER BUFIN(4096),BUFOUT(4096),OCHAN,OTDBLK(4),INDBLK(4)
	LOGICAL*1 SOURCE(4),DESTIN(4)
C
C	  GET THE DEVICE NAMES OF THE INPUT & OUTPUT DISKS
C
	WRITE(5,10)
 10	FORMAT(' DISK COPIER V1.0')
 15	WRITE(5,20)
 20	FORMAT($,' Enter source disk device (ddu):')
	READ(5,30) LEN,SOURCE
 30	FORMAT(Q,4A1)
	IF(LEN.LT.3.OR.LEN.GT.4) GOTO 15
 35	WRITE(5,40)
 40	FORMAT($,' Enter destination disk device (ddu):')
	READ(5,30) LEN,DESTIN
	IF(LEN.LT.3.OR.LEN.GT.4) GOTO 35
C
C	  WE HAVE THE DISK NAMES--NOW CONVERT TO RAD50 FORMAT
C
	I=IRAD50(3,SOURCE,INDBLK)
	I=IRAD50(3,DESTIN,OTDBLK)
C	  ZERO OUT REMAINDER OF FILENAMES
	DO 45 I=2,4
	OTDBLK(I)=0
	INDBLK(I)=0
 45	CONTINUE
C
C	  GET TWO I/O CHANNELS FROM RT-11
C
	IF(IQSET(5).NE.0) STOP'QUEUE ENLARGEMENT ERROR'
	ICHAN=IGETC(IDUMMY)
	IF(ICHAN.LT.0) STOP'NO CHANNEL AVAILABLE'
	OCHAN=IGETC(IDUMMY)
	IF(OCHAN.LT.0) STOP'ONLY 1 CHANNEL AVAILABLE'
C
C	  NOW OPEN THE TWO CHANNELS TO THE DISKS
C
	I=LOOKUP(ICHAN,INDBLK)
	IF(I.LT.0) STOP'BAD LOOKUP FOR INPUT DISK'
	I=LOOKUP(OCHAN,OTDBLK)
	IF(I.LT.0) STOP'BAD LOOKUP FOR OUTPUT DISK'
C
C	  START I/O AT BLOCK 0
C
	IBLK=0
 100	I=IREAD(4096,BUFIN,IBLK,ICHAN)
C	  CHECK FOR HARDWARE & OTHER ERRORS
	IF(I.GE.0) GOTO 110
	IF(I.EQ.-3) STOP'ERROR: INPUT CHANNEL NOT OPEN'
	IF(I.EQ.-1) STOP'ATTEMPT TO READ PAST END OF FILE'
	WRITE(5,105) IBLK
 105	FORMAT(' READ HARDWARE ERROR: BUFFER ',I4)
	I=IWAIT(ICHAN)
	GOTO 100
C	  NOW WRITE TO OUTPUT DEVICE
 110	I=IWRITE(4096,BUFIN,IBLK,OCHAN)
C	  CHECK FOR HARDWARE & OTHER ERRORS
	IF(I.GE.0) GOTO 120
	IF(I.EQ.-3) STOP'ERROR: INPUT CHANNEL NOT OPEN'
	IF(I.EQ.-1) STOP'ATTEMPT TO WRITE PAST END OF FILE'
	WRITE(5,115) IBLK
 115	FORMAT(' WRITE HARDWARE ERROR: BUFFER ',I4)
	I=IWAIT(OCHAN)
	GOTO 110
C
C	  BUFFER HAS BEEN TRANSFERRED
C	  NOW READ IT BACK IN & COMPARE WITH INPUT
C
 120	I=IWAIT(ICHAN)
C	  CHECK FOR ANY ERRORS SINCE I/O STARTED
	IF(I.EQ.0) GOTO 130
	WRITE(5,125) IBLK
 125	FORMAT($,' HARDWARE ERROR ON ',I4,' READ - RETRY?')
 126	FORMAT(A1)
	READ(5,126) LEN
	GOTO 100
C	  NOW COPY THE INPUT BUFFER TO THE COMPARISON BUFFER
C	  SO WE CAN BE READING WHILE VERIFYING
 130	DO 135 I=1,4096
	BUFCMP(I)=BUFIN(I)
 135	CONTINUE
C	  NOW WAIT FOR OUTPUT OPERATION TO COMPLETE
	I=IWAIT(OCHAN)
C	  CHECK FOR ANY OUTPUT HARDWARE ERRORS
	IF(I.EQ.0) GOTO 140
	WRITE(5,136) IBLK
 136	FORMAT($,' HARDWARE ERROR ON ',I4,' WRITE - RETRY?')
	READ(5,126) LEN
	GOTO 110
C
C	  START A READ OPERATION BEFORE WE CAN VERIFY
C
 140	CONTINUE
 142	FORMAT(' ERROR ',I2,' AT BUFFER ',I4,' DURING OVERLAP READ')
	I=IREAD(4096,BUFOUT,IBLK,OCHAN)
	IF(I.LT.0) WRITE(5,145) I,IBLK
 145	FORMAT(' ERROR ',I2,' AT BUFFER ',I4,' DURING VERIFY READ')
C
C	  START READING NEXT INPUT BUFFER WHILST WE READ THE OUTPUT BUFF
C
 150	I=IREAD(4096,BUFIN,IBLK+16,ICHAN)
	IF(I.LT.0) WRITE(5,142) I,IBLK+16
C	  WE MUST WAIT HERE FOR THE OUTPUT BUFFER READ TO COMPLETE
	I=IWAIT(OCHAN)
C	  CHECK FOR ANY ERRORS ON READ
	IF(I.EQ.0) GOTO 155
	WRITE(5,125) IBLK
	READ(5,126) LEN
	GOTO 140
C	  NO ERRORS - START VERIFYING
 155	IERR=0
	DO 160 I=1,4096
	IF(BUFCMP(I).EQ.BUFOUT(I)) GOTO 160
	WRITE(5,156) IBLK,I,BUFCMP(I),BUFOUT(I)
C	IF(BUFIN(I).EQ.BUFOUT(I)) GOTO 160
C	WRITE(5,156) IBLK,I,BUFIN(I),BUFOUT(I)
 156	FORMAT(' VERIFY ERROR: BUFFER ',I4,' WORD ',I4,2(3X,O6))
	IERR=1
 160	CONTINUE
	IF(IERR.NE.0) GOTO 170
C	  INCREMENT BLOCK NUMBER & TRANSFER NEXT BUFFER
 165	IBLK=IBLK+16
C	  CHECK FOR END OF DEVICE
	IF(IBLK.GT.4800) GOTO 200
	GOTO 110
C	  WE HAVE VERIFICATION ERRORS - ASK IF USER WANTS A RETRY
 170	WRITE(5,175)
 175	FORMAT($,' VERIFICATION ERRORS FOUND - RETRY?')
	READ(5,126) LEN
C	  IF USER TYPES A <CR>, THEN SIMPLY FORGET ABOUT ERRORS
C	  AND TRY NEXT BLOCK
	IF(LEN.EQ.'') GOTO 165
	GOTO 100
C
C	  VERIFICATION COMPLETE - CLEAN EVERYTHING UP
C
 200	CALL CLOSEC(OCHAN)
	CALL CLOSEC(ICHAN)
C	  FREE THE I/O CHANNELS
	CALL IFREEC(ICHAN)
	CALL IFREEC(OCHAN)
	STOP
	END
 