/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	xtiso_config.h,v $
 * Revision 4.2  91/09/19  22:56:11  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: xtiso_config.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:56:11 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

/*
 * Configuration structures for XTI-over-SOcket driver.
 */

/*
 * Protocol Information Structure
 */
struct xtiproto { 
	int	 xp_dom;		/* socket domain		*/
	int	 xp_type;		/* socket type  		*/
	int	 xp_proto;		/* socket protocol		*/
	int	 xp_servtype;		/* service type supported	*/
	long	 xp_tsdulen;		/* max TSDU size		*/
	long	 xp_etsdulen;		/* max ETSDU size		*/
	long	 xp_disconlen;		/* max disconnection data size	*/
	long	 xp_connectlen;		/* max connection data size 	*/
	long	 xp_addrlen;		/* max protocol addr size	*/
	long	 xp_optlen;		/* max protocol option size 	*/
	long	 xp_tidulen;		/* max trans protocol i/f size  */
};

#define OSF_XTISO_CONFIG_10	0x01091790

/*
 * Input data structure from configuration manager via kmodcall()
 */
typedef struct {
	str_config_t		sc;		/* standard stream config */
	struct xtiproto         proto;		/* xtiso protocol info    */
} xtiso_inadm_t;

/*
 * Output data structure from configuration manager via kmodcall()
 */
typedef struct {
	str_config_t		sc;
} xtiso_outadm_t;

