/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	search.h,v $
 * Revision 4.2.2.2  92/03/27  15:29:22  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  14:04:37  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  11:59:51  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  17:17:17  Craig_Horman]
 * 
 * Revision 4.2  91/09/20  05:18:47  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: search.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/03/27 15:29:22 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

/*
 * COMPONENT_NAME: (LIBCGEN) Standard C Library General Functions
 *
 * FUNCTIONS: 
 *
 * ORIGINS: 27
 *
 * (C) COPYRIGHT International Business Machines Corp. 1989
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
#ifndef _SEARCH_H_
#define _SEARCH_H_

#include <standards.h>
#include <sys/types.h>

#ifdef _XOPEN_SOURCE

/* HSEARCH(3C) */
typedef struct entry { char *key, *data; } ENTRY;
typedef enum { FIND, ENTER } ACTION;

/* TSEARCH(3C) */
typedef enum { preorder, postorder, endorder, leaf } VISIT;

#ifdef	_NONSTD_TYPES
extern char *lsearch();
extern char *lfind();
extern char *tsearch();
extern char *tfind();
extern char *tdelete();

#elif	defined	_NO_PROTO

extern void *lsearch();
extern void *lfind();
extern void *tsearch();
extern void *tfind();
extern void *tdelete();

#else	/* _NONSTD_TYPES, _NO_PROTO */
#if defined(__cplusplus)
extern "C" {
#endif
extern void *lsearch(void *key, void *base, size_t *nelp, size_t width, int (*compar)());
extern void *lfind(void *key, void *base, size_t *nelp, size_t width, int (*compar)());
extern void *tsearch(void *key, void **rootp, int (*compar)(void *,void *)); 
extern void *tfind(void *key, void **rootp, int (*compar)(void *,void *));
extern void *tdelete(void *key, void **rootp, int (*compar)(void *,void *));
#if defined(__cplusplus)
}
#endif
#endif	/* _NONSTD_TYPES, _NO_PROTO */
 
#ifdef _NO_PROTO
extern int hcreate();
extern void hdestroy();
extern ENTRY *hsearch();
extern void twalk();

#else
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif

extern int hcreate(unsigned nel);
extern void hdestroy(void);
extern ENTRY *hsearch(ENTRY item, ACTION action);
extern void twalk(void *root, void (*action)(void *,VISIT,int));

#if defined(__cplusplus)
}
#endif
#endif
#endif /* _NO_PROTO */
#endif /* _XOPEN_SOURCE */

#endif /* _SEARCH_H_ */
