/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	auth_unix.h,v $
 * Revision 4.2  91/09/20  05:10:27  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*
 *	@(#)$RCSfile: auth_unix.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/20 05:10:27 $
 */
/*
 */


/* 
 * Copyright (c) 1990 by Sun Microsystems, Inc.
 *  1.8 88/02/08 SMI   
 */


/*
 * auth_unix.h, Protocol for UNIX style authentication parameters for RPC
 */

#ifndef _rpc_auth_unix_h
#define	_rpc_auth_unix_h

/*
 * The system is very weak.  The client uses no encryption for  it
 * credentials and only sends null verifiers.  The server sends backs
 * null verifiers or optionally a verifier that suggests a new short hand
 * for the credentials.
 */

/* The machine name is part of a credential; it may not exceed 255 bytes */
#define MAX_MACHINE_NAME 255

/* gids compose part of a credential; there may not be more than 32 of them */
#define NGRPS 32

/*
 * Unix style credentials.
 */
struct authunix_parms {
	u_long	 aup_time;
	char	*aup_machname;
	int	 aup_uid;
	int	 aup_gid;
	u_int	 aup_len;
	int	*aup_gids;
};

extern bool_t xdr_authunix_parms();

/* 
 * If a response verifier has flavor AUTH_SHORT, 
 * then the body of the response verifier encapsulates the following structure;
 * again it is serialized in the obvious fashion.
 */
struct short_hand_verf {
	struct opaque_auth new_cred;
};

#endif /*!_rpc_auth_unix_h*/
