/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	ftw.h,v $
 * Revision 4.2.5.3  92/03/27  15:23:40  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  13:53:30  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  11:39:56  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  15:23:19  Craig_Horman]
 * 
 * Revision 4.2.5.2  92/03/24  17:37:17  Alaa_Zeineldine
 * 	- Corrected the _AES_SOURCE bracked as in the original version.
 * 	- Added #ifdef _OSF_SOURCE brackets around new macros.
 * 	[92/03/20  18:59:03  Alaa_Zeineldine]
 * 
 * Revision 4.2.3.2  92/03/19  23:57:25  Alaa_Zeineldine
 * 	Added nftw(3) from the OSF1.1 version.
 * 
 * Revision 4.2  91/09/20  05:14:57  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: ftw.h,v $ $Revision: 4.2.5.3 $ (DEC) $Date: 92/03/27 15:23:40 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * RESTRICTED RIGHTS LEGEND
 * Use, Duplication or Disclosure by the Government is subject to
 * restrictions as set forth in paragraph (b)(3)(B) of the rights in
 * Technical Data and Computer Software clause in DAR 7-104.9(a).
 */ 

/*
 *	Codes for the third argument to the user-supplied function
 *	which is passed as the second argument to ftw
 */
#ifndef _FTW_H_
#define _FTW_H_

#include <standards.h>
#include <sys/stat.h>

#ifdef _XOPEN_SOURCE

#define	FTW_F	0	/* file */
#define	FTW_D	1	/* directory */
#define	FTW_DNR	2	/* directory without read permission */
#define	FTW_NS	3	/* unknown type, stat failed */


#ifdef _AES_SOURCE
#define FTW_SL	4	/* symbolic link */
#endif

#ifdef _OSF_SOURCE

#define FTW_DP	5	/* directory was previously visited */
#define FTW_PHYS	0x00000001
#define FTW_MOUNT	0x00000002
#define FTW_DEPTH	0x00000004
#define FTW_CHDIR	0x00000008

#endif /* _OSF_SOURCE */

struct FTW {
	int base;
	int level;
}; 

struct stat;

#ifdef _NO_PROTO
extern int ftw();
extern int nftw();
#else
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif
extern int ftw(char *, int (*fn)(char *,struct stat *, int), int );
extern int nftw(char *, int (*fn)(char *,struct stat *, int, struct FTW),
		int, int);
#if defined(__cplusplus)
}
#endif
#endif

#endif /* _NO_PROTO */

#endif /* _XOPEN_SOURCE */

#endif /* _FTW_H_ */
