/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	cma_sigwait.h,v $
 * Revision 4.2  91/09/20  04:58:26  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*
 *	@(#)$RCSfile: cma_sigwait.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/20 04:58:26 $
 */
/*
 *  Copyright (c) 1990, 1991 by
 *  Digital Equipment Corporation, Maynard Massachusetts.
 *  All rights reserved.
 *
 *  This software is furnished under a license and may be used and  copied
 *  only  in  accordance  with  the  terms  of  such  license and with the
 *  inclusion of the above copyright notice.  This software or  any  other
 *  copies  thereof may not be provided or otherwise made available to any
 *  other person.  No title to and ownership of  the  software  is  hereby
 *  transferred.
 *
 *  The information in this software is subject to change  without  notice
 *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment
 *  Corporation.
 *
 *  DIGITAL assumes no responsibility for the use or  reliability  of  its
 *  software on equipment which is not supplied by DIGITAL.
 */

/*
 *  FACILITY:
 *
 *	CMA services
 *
 *  ABSTRACT:
 *
 *	Header file for the CMA implementation of POSIX sigwait routine
 *
 *  AUTHORS:
 *
 *	Paul Curtin
 *
 *  CREATION DATE:
 *
 *	10 December 1990
 *
 *  MODIFICATION HISTORY:
 *
 *	001	Dave Butenhof	5 February 1991
 *		To avoid breaking client code (now that this is pulled in
 *		transparently by cma.h, pthread.h, pthread_exc.h), drop all
 *		the header file includes; which means also dropping the
 *		prototypes (oh well).
 *	002	Paul Curtin	9 May 1991
 *		Removed empty proto for cma_sigwait, should acquire from
 *		system header (ie, we redefine system sigwait to cma_sigwait)
 *	003	Paul Curtin	14 May 1991 
 *		Added full proto for cma_sigwait, not part of some systems...
 */


#ifndef CMA_SIGWAIT
#define CMA_SIGWAIT

/*
 *  INCLUDE FILES
 */
#include <signal.h>

/*
 * CONSTANTS AND MACROS
 */

/*
 * Note:  sigwait is currently only defined in the POSIX spec and nowhere 
 *	else (ie, it is not in Section 2 of the Unix Manual, it is not part of
 *	the C RTL, and it is not part of the CMA specification) so it is an 
 *	orphan.  It is documented here until it is given its rightful place.
 */
#ifndef _CMA_NOWRAPPERS_
# define sigwait cma_sigwait
#endif

/*
 * TYPEDEFS
 */

#if _CMA_OS_ == _CMA__VMS
# ifndef _SIGSET_T_
# define _SIGSET_T_
typedef	int	sigset_t;		/* For sigwait */
# endif
#endif

/*
 *  GLOBAL DATA
 */

/*
 *  PROTOTYPES
 */
#if _CMA_OS_ != _CMA__VMS
extern cma_t_integer
cma_sigwait _CMA_PROTOTYPE_ ((
        sigset_t    *set));
#endif

#endif
