unit instedit;


interface
USES CRT;

TYPE BufferType = Array[0..63999] of Byte; { 64k mem            }
     Line       = Array[1..160] of Byte;   { 160 bytes per line }

CONST LinesToDisplay = 16;   { Must be <= 25                     }
      MinY           = 0;    { Must be >= 0                      }
      MaxY           = 50;  { Must be <= the length of the ansi }
      StartDisplay   = 7;    { Must be >= 1 & <= 24 depending on }
                             { LinesToDisplay.                   }
VAR Buffer : ^BufferType;                            { Buffer for ansi     }
    Ch     : Char;                                   { inputted key        }
    Y      : Integer;                                { display from line Y }
    Screen : Array [1..25] Of Line Absolute $B800:0; { 25 lines of 160     }
                                                     { bytes each          }
procedure editorial;
{$L .\art\editoril.OBJ}                                        { Linking the obj     }
{$I .\art\editor.pas}
implementation
Procedure idtedit; External;                            { into the  prog.     }


Procedure Flushbuffer; Assembler;
          Asm
          mov ax, $0C00;
          int 21h;
          end;

Procedure GetKey(Var Ch : Char);
          Begin
          Ch := #0;
          Repeat
                Ch := readkey;
          Until (Ch <> #0);
          End;

Procedure Key2Dir(Var Y : Integer;
                  Var Ch: Char);
          Begin
{up}      If (Ch = #72) and (Y > MinY) then
             Begin
             dec(y);
             End;
{down}    If (Ch = #80) and (Y < MaxY - LinesToDisplay) then
             Begin
             inc(y);
             End;
{pgup}    If (Ch = #73) then begin
           if ((Y - LinesToDisplay) >= 1) then
             Begin
             y := y - LinesToDisplay;
             End
           else
             begin
             y := miny;
             end;
           end;
{pgdown}  If (Ch = #81) then begin
           if ((Y + (2 * LinesToDisplay)) < MaxY) then
             Begin
             y := y + LinesToDisplay;
             End
           else
             begin
             y := maxy - LinesToDisplay;
             end;
          end;
{home}    If (Ch = #71) and (Y > MinY) then
             Begin
             y := miny;
             End;
{end}     If (Ch = #79) and (Y < MaxY) then
             Begin
             y := maxy - LinesToDisplay;
             End;
End;

Procedure Display_80_25(Y, Y2 : Word);
          Begin
               If (Y2 <= 25) And (Y >= 0) Then
               Begin
                    Move(Buffer^[Y*160],Screen[StartDisplay],Y2*160);
               End;
          End;

procedure editorial;
Begin
   move(editoril,mem[$b800:0000],sizeof(editoril));
   Y := 0;                          {Starting point.                     }
   New(Buffer);                     {create a new buffer                 }
   Buffer:=@idtedit;                   {put the ansi into the buffer        }
   Display_80_25(Y,LinesToDisplay); {display from line line Y of the ansi}
                                    {and show LineToDisplay lines of it. }
   Repeat                           {do this this until...               }
   Flushbuffer;                     {flush the keyboard buffer           }
   GetKey(Ch);                      {gets the key pressed                }
   Key2Dir(Y, Ch);                  {inc or dec's why depending on what  }
                                    {key was pressed.                    }
   Display_80_25(Y,LinesToDisplay); {display from line line Y of the ansi}
                                    {and show LineToDisplay lines of it. }
   Until (Ch = #27);                {...escape is hit.                   }
   Clrscr;                          {clear the screen                    }
End;

begin

end.