Unit Fossil;


Interface

Procedure fossil_Send(c: Char);            { Send character to port      }
Function  fossil_Recv: Char;               { Receive character from port }
Function  fossil_Carr: Boolean;            { Detect carrier presense     }
Function  fossil_Init(com: byte): Boolean; { Initialize port             }
Procedure fossil_Dnit;                     { Deinitialize port           }
Procedure fossil_sDtr(b: boolean);         { Set DTR state               }
Procedure fossil_fOut;                     { Flush output buffer         }
Procedure fossil_kOut;                     { Kill output buffer/pending  }
Procedure fossil_kInp;                     { Kill input buffer/pending   }
Procedure fossil_Flow(b: boolean);         { Set Flow Control state      }
Function  fossil_Char: Boolean;            { Detect if character waiting }
Procedure fossil_SendModemStr(str:string; display:boolean); { Send AT Commands            }
Procedure fossil_Parm(                     { Set fossil paramaters       }
          Baud:Word;
          DataBits: Byte;
          Parity: Char;
          StopBits: Byte);


Implementation
uses dos,crt;
Const
   Null   = #0;

Var
   Port   : Integer;
   Vah    : Byte;
   Vax    : Integer;
   C      : Char;
   W      : Word;

Procedure fossil_Send(c: Char); assembler;
 Asm
  mov ah, 0Bh
  mov al, c
  mov dx, port
  int 14h
 End;


Function fossil_Recv: Char;
 Begin
   Asm
    mov c, null
    mov ah, $02
    mov dx, port
    int 14h
    mov c, al
   End;
  fossil_recv := c;
 End;


Function  fossil_Carr: Boolean; assembler;
 Asm
  mov ah, $03
  mov dx, port
  int 14h
  mov bl, al
  xor al, al
  and bl, $80
  cmp bl, $80
  jne @@exitcarr
  inc al
  @@exitcarr:
 End;


Function  fossil_Init(com: byte): Boolean;
 Begin
  port := pred(com);
  fossil_Init := False;
   asm
    mov ah, $04
    mov dx, port
    int 14h
    mov vax, ax;
   end;
  if vax = $1954 then fossil_Init := True;
 End;


Procedure fossil_Dnit; assembler;
 Asm
  mov ah, $05
  mov dx, port
  int 14h
 End;


Procedure fossil_sDtr(b: boolean); assembler;
 Asm
  mov ah, $06
  mov dx, port
  cmp b, 0
  je  @@lower
  mov al,$01
  jmp @@exitdtr
  @@lower:
  mov al,$00
  @@exitdtr:
  int 14h
 End;


Procedure fossil_fOut; assembler;
 Asm
  mov ah, $08
  mov dx, port
  int 14h
 End;


Procedure fossil_kOut; assembler;
 Asm
  mov ah, $09
  mov dx, port
  int 14h
 End;


Procedure fossil_kInp; assembler;
 Asm
  mov ah, 0Ah
  mov dx, port
  int 14h
 End;


Procedure fossil_Flow(b: boolean); assembler;
 Asm
  mov ah, 0Fh
  xor al, al
  mov dx, port
  cmp b, 0
  je @@disable
  mov al, 255
  @@disable:
  int 14h
 End;


Function  fossil_Char: Boolean;
 Begin
  Asm
   mov ah, $03
   mov dx, port
   int 14h
   mov vah, ah
  End;
  if (vah and 1) = 1 then fossil_char := true else fossil_char := false;
 End;


Procedure fossil_Parm(Baud:word; DataBits: Byte; Parity: Char; StopBits: Byte);
 Var
  C: Byte;
 Begin
  If Baud = 0 Then Exit;
  C := 0;
  C := databits - 5;
  c := c or ((stopbits - 1)shl 2);
  case upcase(parity) of
   'O': c := c or $08; { odd }
   'N': c := c or $00; { n }
   'E': c := c or $18; { even }
   end;
  case baud of
   300   : c := c or $40;
   600   : c := c or $60;
   1200  : c := c or $80;
   2400  : c := c or $A0;
   4800  : c := c or $C0;
   9600  : c := c or $E0;
   19200 : c := c or $00;
   38400 : c := c or $20;
   57600 : c := c or $40;

  end;
  asm
   xor ah, ah
   mov al, c
   mov dx, port
   xor dh, dh
   int 14h
  end;
end;

Procedure fossil_SendModemStr(str:string; display:boolean); { Send AT Commands            }
Var X : Byte;
Begin
  While fossil_char and display Do Write(fossil_recv);
  Delay(50);
  For X := 1 to Length(Str) Do
  Begin
    Case Str[X] of
      '|' : fossil_send(#13);
      '~' : Delay (300);
      Else  fossil_send(Str[X])
    End;
    Delay(50);
    If Display Then If fossil_char Then Write(fossil_recv);
  End;
  For X := 1 To 255 Do If Display and fossil_char Then Write(fossil_recv);
  Delay(50);
End;


end.
