{$I DIRECT.INC}
UNIT Init;

INTERFACE

PROCEDURE ValidConfiguration;
Procedure Initinfusion (CheckFiles30 : BOOLEAN);

IMPLEMENTATION

USES Crt, Dos, DosMem, GenTypes, Modem, MkAvatar, StatRet, ConfigRt,
MyComman, Flags, GenSubs, Subs1, Windows, TextRet, UserRet, SubsOvr,
Subs2, OverRet1, FileLock,skashit;

Procedure ValidConfiguration;
VAR errs : byte;
       f : file;

 Procedure writeIt;
  begin
   assign(f,configFile);
   rewrite(f,1);
   blockWrite(f,cfg,sizeOf(cfg));
   close(f);
  end;

  Procedure error (q : anystr);
  BEGIN
    inc(errs);
    skaWrite
    ('|08:|07:|15: |07Infusion has encountered configuration errors: |CR');
    skaWrite('|08:|07:|15: |07#'+strr(errs)+'. '+q+'|CR');
  END;

  Procedure ispath (VAR X : lstr; name : lstr);
  BEGIN
    If NOT DirExist (X) Then
    BEGIN
      error (name + ' Invalid Pathname, |15'+X);
      TextAttr := 7;
      skaWrite('|08:|07:|15: |07Should Infusion create this directory: ');
      If (gensubs.yesNo(7,25)=true) then
      BEGIN
       writeLn;
       If Not MakePath(X) Then skaWrite('|08:|07:|15: Error creating path..|CR') else DEC (errs);
      END else writeLn;
    END;
  END;

  Procedure isinteger (N, r1, r2 : integer; name : lstr);
  BEGIN
    If (N < r1) OR (N > r2) Then error ('Invalid ' + name + ' value: ' + strr(N));
  END;

  Procedure isword (N, r1, r2 : WORD; name : lstr);
  BEGIN
    If (N < r1) or (N > r2) Then error ('Invalid ' + name + ' value: ' + strr(N));
  END;

BEGIN
  Errs := 0;
  skaWrite('|08:|07:|15: |07Examining |15SHARE.EXE|07 file sharing driver..|CR');
  If not (ShareInstalled) {and not (OmitShare)} then
  BEGIN
   skaWrite('|08:|07:|15: |07Error, driver not found. Halting operation..|CR');
   showLine;
   skaWrite('|07  Infusion requires that the SHARE.EXE file driver is loaded at all|CR');
   skaWrite('|07  times.  Load SHARE.EXE and run Infusion again.|CR');
   showLine;
   HALT (5);
  END;
  skaWrite('|08:|07:|15: |07File sharing driver succesfully locked and located..|CR');
  if (cfg.DefBaudRate<3) then
   begin
   cfg.DefBaudRate := 1152;
   writeIt;
   end;
  if (cfg.useCom>8) then
   begin
   cfg.useCom := 8;
   writeIt;
   end;
  skaWrite('|08:|07:|15: |07Examining Infusion system directories..|CR');
  ispath (cfg.textdir, 'Path to Message Base');
  ispath (cfg.uploaddir, 'Path to ASCII Uploads');
  ispath (cfg.boarddir, 'Path to Sub-Board files');
  ispath (cfg.textfiledir, 'Path to Text Files');
  ispath (cfg.doordir, 'Path to door batch files');
  ispath (cfg.DataDir, 'Path to DATA Files');
  ispath (cfg.ExtractDir, 'Temp Path for File Extractions');
  ispath (cfg.MenuDir, 'Path to Menu Data');
  If errs > 0 Then
   begin
   showLine;
   Halt(5)
   end;
  skaWrite('|08:|07:|15: |07Examining Infusion system variables..|CR');
  isword (cfg.DefBaudRate, 3, 1152, 'Default BPS (Fossil)');
  isinteger (cfg.usecom, 0, 8, 'Communications Port');
  isinteger (cfg.mintimeout, 1, maxint, 'Input Time Out');
  isinteger (cfg.sysoplevel, 1, maxint, 'Co-Sysop Level');
  If errs > 0 Then
   begin
   showLine;
   Halt(5)
   end;
END;

Procedure Initinfusion (CheckFiles30 : Boolean);

  Procedure formatmfile;
  VAR m : mailrec;
  BEGIN
    REWRITE (mfile);
    fillchar (m, sizeof (m), 255);
    NWrite (mfile, m)
  END;

  Procedure openmfile;
  VAR i : byte;
  BEGIN
    if (checkFiles30=true) then skaWrite('|08:|07:|15: |07Examining email data and index files..|CR');
    Close (mfile);
    i := IoResult;
    ASSIGN (mfile, cfg.DataDir + 'MAIL');
    Reset (mfile);
    i := IoResult;
    If i <> 0 Then
      If i = 2 Then formatmfile
      else
      BEGIN
      if (checkFiles30=true) then begin
       skaWrite('|08:|07:|15: |07Error, mail datafiles cannot be initialized..|CR');
       showLine;
       end;
       Halt (5)
      END;
    if (checkFiles30=true) then skaWrite('|08:|07:|15: |07Email datafiles succesfully initialized..|CR');
  END;

  Procedure ResetUserFiles;
  Var U : UserRec;
      N : Byte;
  Begin
    if (checkFiles30=true) then skaWrite('|08:|07:|15: |07Examining Infusion userbase..|CR');
    If IsOpen(UFile) Then Close(UFile);
    Assign(UFile, cfg.DataDir + 'USERS');
    ResetOrReWrite(UFile, SizeOf(UserRec));
    If FileSize(UFile) = 0 Then
    Begin
      if (checkFiles30=true) then skaWrite('|08:|07:|15: |07Infusion userbase does not exist, creating new..|CR');
      FillChar(U, SizeOf(U), 0);
      NWrite(UFile,U);
      U.Handle := cfg.Sysopname;
      U.Password := 'SYSOP';
      U.RealName := U.Handle;
      U.PhoneNum := cfg.BoardPhone;
      U.Timetoday := 9999;
      U.Level := cfg.sysoplevel + 1;
      U.UDLevel := 101;
      U.UDPoints := 101;
      U.Config := [ansigraphics, asciigraphics, lowercase, eightycols, linefeeds, postprompts];
      U.Config := u.config + [mainsysop, udsysop, bulletinsysop, emailsysop, votingsysop, doorssysop, fseditor, usebars];
      U.Color1 := cfg.defcolor1;
      U.Color2 := cfg.defcolor2;
      U.Color3 := cfg.defcolor3;
      U.Color4 := cfg.defcolor4;
      U.Color5 := cfg.defcolor5;
      U.Color6 := cfg.defcolor6;
      U.Color7 := cfg.defcolor7;
      U.Prompt := Strng^.DefPrompt;
      U.Sysopnote := 'System Operator';
      U.KDownToday := 0;
      U.DailyKBLimit := 0;
      U.EmailAnnounce := -1;
      For N := 1 to 5 Do U.Infoform[N] := -1;
      U.Displaylen := 24;
      U.Config := u.config + [ansigraphics];
      NWrite(UFile, U);
    End else skaWrite('|08:|07:|15: |07Userbase succesfully initialized..|CR');
    NumUsers := FileSize(UFile) - 1;
  End;

  Procedure initfile (VAR f : FILE);
  VAR fi : fib absolute f;
  BEGIN
    fi.handle := 0;
    fi.name[0] := #0;
  END;

  Procedure OpenLogFile;
  Begin
    Assign(LogFile, cfg.DataDir + 'SYSLOG');
    ResetOrReWrite(LogFile,SizeOf(LogRec));
    If FileSize(LogFile) >= MaxSysLogSize Then
      DeleteRecs(LogFile,0,FileSize(LogFile) DIV 2);
  End;

  Procedure LoadErrorList;
  BEGIN
    IoErrors [1] := '001 Invalid function number';
    IoErrors [2] := '002 File not found';
    IoErrors [3] := '003 Path not found';
    IoErrors [4] := '004 Too many open files';
    IoErrors [5] := '005 Access denied';
    IoErrors [6] := '006 Invalid handle';
    IoErrors [7] := '008 Not enough memory';
    IoErrors [8] := '010 Invalid environment';
    IoErrors [9] := '011 Invalid format';
    IoErrors [10] := '012 Invalid file access code';
    IoErrors [12] := '015 Invalid drive number';
    IoErrors [13] := '016 Cannot remove current directory';
    IoErrors [14] := '017 Cannot rename across drives';
    IoErrors [15] := '018 No more files';
    IoErrors [16] := '100 Disk read error';
    IoErrors [17] := '101 Disk write error';
    IoErrors [18] := '102 File not assigned';
    IoErrors [19] := '103 File not open';
    IoErrors [20] := '104 File not open for input';
    IoErrors [21] := '105 File not open for output';
    IoErrors [22] := '106 Invalid numeric format';
    IoErrors [23] := '150 Disk is write-protected';
    IoErrors [24] := '151 Bad drive request struct length';
    IoErrors [25] := '152 Drive not ready';
    IoErrors [26] := '154 CRC error in data';
    IoErrors [27] := '156 Disk seek error';
    IoErrors [28] := '157 Unknown media type';
    IoErrors [29] := '158 Sector Not Found';
    IoErrors [30] := '159 Printer out of paper';
    IoErrors [31] := '160 Device write fault';
    IoErrors [32] := '161 Device read fault';
    IoErrors [33] := '162 Hardware failure';
    IoErrors [34] := '200 illegal math co-op';
    IoErrors [35] := '201 Range check error';
    IoErrors [36] := '202 Stack overflow error';
    IoErrors [37] := '203 Heap overflow error';
    IoErrors [38] := '204 Invalid pointer operation';
    IoErrors [39] := '205 Floating point overflow';
    IoErrors [40] := '206 Floating point underflow';
    IoErrors [41] := '207 Invalid floating point operation';
    IoErrors [42] := '208 Overlay manager not installed';
    IoErrors [43] := '209 Overlay file read error';
    IoErrors [44] := '210 Object not initialized';
    IoErrors [45] := '211 Call to abstract method';
    IoErrors [46] := '212 Stream registration error';
    IoErrors [47] := '213 Collection index out of range';
    IoErrors [48] := '214 Collection overflow error';
  END;

Procedure LoadSysLogDat;
Var TF : Text;
    Q  : LStr;
    B1, B2, P, S, N : Integer;
Begin
  NumSysLogDat := 0;
  With SysLogDat[0] Do
  Begin
    Menu := 0;
    SubCommand := 0;
    Text := 'SYSLOG.DAT entry not found: %'
  End;
  if not exist(cfg.dataDir+'SYSLOG.DAT') then exit;
  Assign(TF,cfg.Datadir + 'SYSLOG.DAT');
  Reset(TF);
  If IoResult = 0 Then
    While Not Eof(TF) Do
    Begin
      ReadLn(TF, Q);
      P := Pos(' ', Q);
      If P <> 0 Then
      Begin
        Val(Copy(Q, 1, P - 1), B1, S);
        If S = 0 Then
        Begin
          Delete(Q, 1, P);
          P := Pos (' ', Q);
          If P <> 0 Then
          Begin
            Val(Copy(Q, 1, P - 1), B2, S);
            If S = 0 Then
            Begin
              Delete(Q, 1, P);
              If NumSysLogDat = MaxSysLogDat Then
                WriteLn( 'Too many SYSLOG.DAT entries')
              Else
              Begin
                Inc(NumSysLogDat);
                With SysLogDat[NumSysLogDat] DO
                Begin
                  Menu := B1;
                  SubCommand := B2;
                  Text := Copy(Q, 1, 30)
                END
              END
            END
          END
        END
      END
    END;
  TextClose(TF);
  If numsyslogdat = 0 Then
    WriteLn( ' * - SYSLOG.DAT file is corrupted')
END;


VAR cnt : byte;
BEGIN
  fillchar (urec, sizeof (urec), 0);
  no_local_output := false;
  urec.config := [lowercase, eightycols, asciigraphics];
  iocode := 0;
  linecount := 0;
  Status.sysopavail := 2;
  errorparam := '';
  errorproc := '';
  unam := '';
  chainstr [0] := #0;
  inpt [0] := #0;
  chatreason := '';
  ulvl := 0;
  unum := - 1;
  logonunum := - 2;
  break := false;
  nochain := false;
  nobreak := false;
  wordwrap := false;
  beginwithspacesok := false;
  dots := false;
  online := false;
  local := true;
  chatmode := false;
  texttrap := false;
  printerecho := false;
  usecapsonly := false;
  uselinefeeds := true;
  curattrib := 0;
  buflen := 80;
  baudrate := cfg.DefBaudRate;
  timelock := false;
  ingetstr := false;
  modeminlock := false;
  modemoutlock := false;
  tempsysop := false;
  sysnext := false;
  forcehangup := false;
  requestbreak := false;
  disconnected := false;
  SplitMode := false;
  cursection := mainsysop;
  replynum := 0;
  regularlevel := 0;
  UseBottom := 1;
  replynum := 0;
  Non_Stop := false;
  CheckPageLength := false;
  for cnt := 1 to numsysfiles DO initfile (sysfiles [cnt]);
  loadsyslogdat;
  readstatus;
  readdailylog;
  openlogfile;
  openmfile;
  LastTextFile [0] := #0;
  LastMailFile [0] := #0;
  LastMsgConf  := 1;
  LastFileConf := 1;
  FileConf := 1;
  MsgConf  := 1;
  If CheckFiles30 Then
  BEGIN
    UpdateNode ('0','');
    ResetUserFiles;
    LoadErrorList;
    Dos_GetMem (BatchDown, sizeof (BatchRec) * 100 + 1);
    Load_Theme (1);
  END
  else
    Dos_FreeMem (BatchDown);
END;

BEGIN
checkbreak := false;
checkeof := false;
Positions(False);
directvideo := cfg.directvideomode;
checksnow := cfg.checksnowmode;
END.
