{$I DIRECT.INC}
{ $DEFINE NEWCONFIG}
unit configrt;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
interface
   uses GenTypes,skashit,crt;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Var CfgHash, KeeHash : LongInt;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
const configfile : string = 'NODE1.DAT';
Var  Cfg   : ConfigSetType;
     Strng : ^StringRec;
     cChange : boolean;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure ReadCfg(Hash : Boolean);
Procedure ReadStrings;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
implementation

FUNCTION Exist(FileName : LStr) : Boolean; ASSEMBLER;
ASM
  PUSH DS          {Save DS                         }
  LDS  SI,Filename {DS:SI => Filename               }
  XOR  BX,BX       {Clear BX                        }
  MOV  BL,[SI]     {BX = Length(Filename)           }
  INC  SI          {DS:SI => Filename[1]            }
  MOV  DX,SI       {DS:DX => Filename[1]            }
  MOV  [SI+BX],BH  {Append Ascii 0 to Filename      }
  MOV  AX,4300h    {Get Attribute Function Code     }
  INT  21h         {Get File Attributes             }
  MOV  AL,BH       {Default Result = FALSE          }
  ADC  CL,CL       {Attribute * 2 + Carry Flag      }
  AND  CL,31h      {Directory or VolumeID or Failed }
  JNZ  @@Done      {Yes - Exit                      }
  INC  AL          {No - Change Result to TRUE      }
@@Done:
  POP  DS          {Restore DS                      }
END;

Procedure showElite(s : string);
 begin
 gotoxy(3,wherey);
 skawrite('|07.,:$%'' |07'+S);
 end;

Procedure showMainLogo;
 begin
 textAttr := 7;
 clrscr;
 writeLn('    _,s$''    _,s$$,s$,  _,s$_.s$.          _,s$,`$s,_              _,s$,');
 writeLn('    `$$$ $$$"^"$$$`$$$"^"$$$`$$$  $$$ .s$"^"$$$ $$$''.s$"^"$s. $$$"^"$$$');
 writeLn('     $$$ $$$   $$$ $$$ss     $$$   $$$ $$$   "& $$$ $$$   $$$ $$$   $$$');
 writeLn('     $$$ $$$   $$$ $$$       $$$   $$$ `&$s,_   $$$ $$$   $$$ $$$   $$$');
 writeLn('     $$$ $$$   $$$ $$$       $$$   $$$_,s, `$s, $$$ $$$   $$$ $$$   $$$');
 writeLn('     $$$ $$$   $$$ $$$       $$$   $$$`$$$   $$$ $$$ $$$   $$$ $$$   $$$');
 writeLn('     $$$,$$$   $$$_$$$,     ,$$$s,s$$$ `&s,s$$$,$$$ `&s,s&'' $$$  _$$$,');
 writeLn('    ,$''          `^"&     `&''          `^&$'' `$,               `&''');
 writeLn('');
 end;

Procedure Readcfg(Hash : Boolean);
Var Q : File of Configsettype;
    B : Byte;
    TempStr : STRING;
    L : LongInt;
    M : LongInt;
Begin
  B := IoResult;
  Assign (q,configfile);
  Reset (q);
  if ioresult=0 then begin
    FillChar(Cfg,SizeOf(Cfg),0);
    read (q,cfg);
    If IOResult = 100 Then Reset(Q);
  end else
  begin
     textAttr := 7;
     window(1,1,80,25); clrscr;
     showMainLogo;
     showElite('|15error, the supplied configuration file is invalid or does not exist|CR');
     showElite('|15troubleshooting tip, check to make sure that you supplied a valid node|CR|CR');
     halt (5)
  end;
  close (q);
  {$IFDEF NEWCONFIG}
  cfg.totalanimatedprompts := 7;
  cfg.useanimatedprompts := true;
  rewrite(q);
  write(q,cfg);
  close(q);
  {$ENDIF}
End;

Procedure ReadStrings;
Var S : File of StringRec;
Begin
  FillChar(Strng^,SizeOf(Strng^),0);
  Assign(S,cfg.infusionDir+'STRINGS.DAT');
  Reset(S);
  If Ioresult = 0
     Then Read(S,Strng^)
     Else
       Begin
         textAttr := 7;
         window(1,1,80,25); clrscr;
         showMainLogo;
         showElite('|15error, the strings.dat language datafile cannot be located|CR');
         showElite('|15troubleshooting tip, re-create them with the string editor|CR|CR');
         Halt(5);
       End;
  System.Close(S);
End;

End.