@REM !/bin/sh
@REM TargetD64 test suite
@REM (c) 1999 Karlheinz Langguth under the terms of GPL
@REM TargetD64 homepage at
@REM http://skyscraper.fortunecity.com/quadra/251/targetd64.html
@REM Contact the author by mailto:klangguth@netscape.net
@REM 
@REM This program is free software; you can redistribute it and/or
@REM modify it under the terms of the GNU General Public License
@REM as published by the Free Software Foundation; either version 2
@REM of the License, or (at your option) any later version.
@REM This program is distributed in the hope that it will be useful,
@REM but WITHOUT ANY WARRANTY; without even the implied warranty of
@REM MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
@REM GNU General Public License for more details.

@REM ATTENTION: restrict the commands to M$ syntax as batchfile
@REM            is generated automatically

@REM usage: test.sh [-c dir]
@REM without parameters test suite is executed
@REM -c dir executes MERELY result check of results in dir

@REM The following section will be commented out in the windows batchfile

@REM #################################################################
@REM Testseries "builtin D64 support"
@REM #################################################################

@REM ################################################################
@REM Testcase D64_1
@REM Insert files of the following length:
@REM 253, 254, 255, 8127, 8128, 8129, 42163, 42164, 42165 bytes
@REM Should lead to one disk with blocksizes
@REM 1  , 1  , 2  , 32  , 32  , 33  , 166  , 166  , 167
@REM Disk should have 64 Blocks free
@REM Load and run the files from the disk(s) and compare the output to
@REM the filelength (use CBM LOAD statement)
@REM 
@REM Tests general function and blocksize overflow in data
@REM and directory (> 8 entries)

echo ================ Executing testcase D64_1
del D64_1\*.d64
mkdir D64_1
TargetD64  -c D64_1 253bytes 254bytes 255bytes 8127bytes 8128bytes 8129bytes 42163bytes 42164bytes 42165bytes

@REM ################################################################
@REM Testcase D64_2
@REM Insert files of the following length:
@REM 42164, 42164, 42164, 42164
@REM Should lead to one disk with blocksizes
@REM 166  , 166  , 166  , 166
@REM Disk should have 0 Blocks free
@REM Load and run the files from the disk(s) and compare the output to
@REM the filelength (use CBM LOAD statement)
@REM 
@REM Tests disk filled up to the last data byte

echo ================ Executing testcase D64_2
del D64_2\*.d64
mkdir D64_2
TargetD64  -c D64_2 42164bytes 42164bytes2 42164bytes3 42164bytes4

@REM ################################################################
@REM Testcase D64_3
@REM Insert files of the following length:
@REM 42164, 42164, 42164, 42164, 253
@REM Should lead to two disk with blocksizes
@REM 166  , 166  , 166  , 166
@REM                             1
@REM Disk1 should have 0 Blocks free
@REM Disk2 should have 663 Blocks free
@REM Load and run the files from the disk(s) and compare the output to
@REM the filelength (use CBM LOAD statement)
@REM 
@REM Tests disk overflow. There have to be two disks created.

echo ================ Executing testcase D64_3
del D64_3\*.d64
mkdir D64_3
TargetD64  -c D64_3 42164bytes 42164bytes2 42164bytes3 42164bytes4 253bytes

@REM ################################################################
@REM Testcase D64_4
@REM Insert files of the following length:
@REM 42164, 42164, 42165, 42164
@REM Should lead to two disk with blocksizes
@REM 166  , 166  , 167
@REM                      166
@REM Disk1 should have 165 Blocks free
@REM Disk2 should have 498 Blocks free
@REM Load and run the files from the disk(s) and compare the output to
@REM the filelength (use CBM LOAD statement)
@REM 
@REM Tests disk overflow by one byte. There have to be two disks created.

echo ================ Executing testcase D64_4
del D64_4\*.d64
mkdir D64_4
TargetD64  -c D64_4 42164bytes 42164bytes2 42165bytes 42164bytes3

@REM ################################################################
@REM Testcase D64_5
@REM The source disk contains the same programs as written in D64_1.
@REM The source disk is not converted and provided as is (nothing to resolve).
@REM 
@REM Test a "straight" D64 image

echo ================ Executing testcase D64_5
del D64_5\*.d64
mkdir D64_5
TargetD64  -c D64_5 d64_5.d64

@REM ################################################################
@REM Testcase D64_6
@REM The source disk contains:
@REM 1!disk
@REM 2!disk
@REM 3!disk
@REM 4!disk
@REM soccermania
@REM 
@REM Results in two disks containing:
@REM -------------------
@REM 253bytes
@REM 254bytes
@REM 255bytes
@REM 8127bytes
@REM 8128bytes            [1-4]!disk extracted
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM -------------------
@REM 1!disk               source disk is kept as there is soccermania          
@REM 2!disk               as an unresolvable program on it
@REM 3!disk
@REM 4!disk
@REM soccermania
@REM -------------------

echo ================ Executing testcase D64_6
del D64_6\*.d64
mkdir D64_6
TargetD64  -c D64_6 d64_6.d64

@REM ################################################################
@REM Testcase D64_7
@REM 
@REM The source disk contains:
@REM 1!disk
@REM 2!disk
@REM 3!disk
@REM 4!disk
@REM 
@REM Results in one disk containing:
@REM 253bytes           
@REM 254bytes                 [1-4]!disk extracted.
@REM 255bytes                 No need to keep the source disk as
@REM 8127bytes                there is no more data on it.
@REM 8128bytes
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes

echo ================ Executing testcase D64_7
del D64_7\*.d64
mkdir D64_7
TargetD64  -c D64_7 d64_7.d64

@REM ################################################################
@REM Testcase D64_8
@REM 
@REM The source disk contains:
@REM soccermania
@REM soccermania.lnx
@REM 
@REM Results in two disks:
@REM -------------------
@REM soccermania          source disk is kept as there is soccermania
@REM soccermania.lnx      as an unresolvable program on it
@REM -------------------
@REM soccermania          from soccermania.lnx
@REM -------------------

echo ================ Executing testcase D64_8
del D64_8\*.d64
mkdir D64_8
TargetD64  -c D64_8 d64_8.d64

@REM ################################################################
@REM Testcase D64_9
@REM 
@REM The source disk is a 175531 bytes D64 containing:
@REM soccermania
@REM soccermania.lnx
@REM 1!disk
@REM 2!disk
@REM 3!disk
@REM 4!disk
@REM 
@REM Results in three disks:
@REM -------------------
@REM soccermania          source disk is kept as there is soccermania
@REM soccermania.lnx      as an unresolvable program on it
@REM 1!disk
@REM 2!disk
@REM 3!disk
@REM 4!disk
@REM -------------------
@REM soccermania          from soccermania.lnx
@REM -------------------
@REM 253bytes           
@REM 254bytes             [1-4]!disk extracted.
@REM 255bytes
@REM 8127bytes 
@REM 8128bytes
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM -------------------

echo ================ Executing testcase D64_9
del D64_9\*.d64
mkdir D64_9
TargetD64  -c D64_9 d64_9.d64

@REM ################################################################
@REM Testcase D64_10
@REM 
@REM The source disk is a 196608 bytes D64 containing:
@REM 253bytes
@REM 254bytes
@REM 255bytes
@REM 8127bytes
@REM 8128bytes
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM 1!disk
@REM 2!disk
@REM 3!disk
@REM 4!disk
@REM soccermania.lnx
@REM 
@REM Results in three disks:
@REM -------------------
@REM 253bytes        source disk is kept as there is soccermania
@REM 254bytes        as an unresolvable program on it
@REM 255bytes
@REM 8127bytes
@REM 8128bytes
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM 1!disk
@REM 2!disk
@REM 3!disk
@REM 4!disk
@REM soccermania.lnx
@REM -------------------
@REM 253bytes           
@REM 254bytes             [1-4]!disk extracted.
@REM 255bytes
@REM 8127bytes
@REM 8128bytes
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM -------------------
@REM soccermania          from soccermania.lnx
@REM -------------------

echo ================ Executing testcase D64_10
del D64_10\*.d64
mkdir D64_10
TargetD64  -c D64_10 d64_10.d64

@REM ################################################################
@REM Testcase D64_11
@REM 
@REM The source disk is a 197376 bytes D64 containing:
@REM 253bytes
@REM 254bytes
@REM 255bytes
@REM 8127bytes
@REM 8128bytes
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM 1!disk
@REM 2!disk
@REM 3!disk
@REM 4!disk
@REM soccermania.lnx
@REM 
@REM Results in three disks:
@REM -------------------
@REM 253bytes        source disk is kept as there is soccermania
@REM 254bytes        as an unresolvable program on it
@REM 255bytes
@REM 8127bytes
@REM 8128bytes
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM 1!disk
@REM 2!disk
@REM 3!disk
@REM 4!disk
@REM soccermania.lnx
@REM -------------------
@REM 253bytes           
@REM 254bytes             [1-4]!disk extracted.
@REM 255bytes 
@REM 8127bytes 
@REM 8128bytes
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM -------------------
@REM soccermania          from soccermania.lnx
@REM -------------------

echo ================ Executing testcase D64_11
del D64_11\*.d64
mkdir D64_11
TargetD64  -c D64_11 d64_11.d64

@REM #################################################################
@REM Testseries "builtin X64 support"
@REM #################################################################

@REM ################################################################
@REM Testcase X64_1
@REM 
@REM x64_1.x64 contains:
@REM Result of D64_7
@REM x64_2.x64 contains:
@REM Result of LNX_1

echo ================ Executing testcase X64_1
del X64_1\*.d64
mkdir X64_1
TargetD64  -c X64_1 x64_1.x64 x64_2.x64


@REM #################################################################
@REM Testseries "builtin T64 support"
@REM #################################################################

@REM ################################################################
@REM Testcase T64_1
@REM 
@REM The source tape contains:
@REM soccermania
@REM 
@REM Results in one disk containing soccermania

echo ================ Executing testcase T64_1
del T64_1\*.d64
mkdir T64_1
TargetD64  -c T64_1 soccermania.t64

@REM ################################################################
@REM Testcase T64_2
@REM 
@REM The source tape contains:
@REM 253bytes
@REM 254bytes
@REM 255bytes
@REM 8127bytes
@REM 8128bytes
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM 
@REM Results in one disk containing all programs
@REM Start the programs from disk and compare sizes.

echo ================ Executing testcase T64_2
del T64_2\*.d64
mkdir T64_2
TargetD64  -c T64_2 t64_2.t64

@REM ################################################################
@REM Testcase T64_3
@REM 
@REM The source tape contains:
@REM 42164bytes2
@REM 42165bytes
@REM 42164bytes3
@REM 42164bytes
@REM 
@REM Results in two disks (due to disk overflow) containing
@REM -------------------
@REM 42164bytes
@REM 42164bytes2
@REM 42164bytes3
@REM -------------------
@REM 42165bytes
@REM -------------------
@REM Start the programs from disk and compare sizes.

echo ================ Executing testcase T64_3
del T64_3\*.d64
mkdir T64_3
TargetD64  -c T64_3 t64_3.t64

@REM ################################################################
@REM Testcase T64_4
@REM 
@REM The source tape contains:
@REM 1!disk
@REM 2!disk
@REM 3!disk
@REM 4!disk
@REM soccermania
@REM 
@REM Results in two disks containing:
@REM -------------------
@REM soccermania          unresolvable program
@REM -------------------
@REM 253bytes
@REM 254bytes
@REM 255bytes
@REM 8127bytes
@REM 8128bytes            [1-4]!disk extracted
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM -------------------

echo ================ Executing testcase T64_4
del T64_4\*.d64
mkdir T64_4
TargetD64  -c T64_4 t64_4.t64

@REM ################################################################
@REM Testcase T64_5
@REM 
@REM The source tape contains:
@REM soccermania
@REM disk.lnx
@REM 
@REM Results in two disks containing
@REM -------------------
@REM soccermania
@REM -------------------
@REM 253bytes
@REM 254bytes
@REM 255bytes
@REM 8127bytes
@REM 8128bytes            disk.lnx extracted
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM -------------------

echo ================ Executing testcase T64_5
del T64_5\*.d64
mkdir T64_5
TargetD64  -c T64_5 t64_5.t64

@REM ################################################################
@REM Testcase T64_6
@REM 
@REM The source tape is empty
@REM An error is indicated

echo ================ Executing testcase T64_6
del T64_6\*.d64
mkdir T64_6
TargetD64  -c T64_6 empty.t64

@REM ################################################################
@REM Testcase T64_7
@REM 
@REM The source tape contains two files
@REM first file has an empty filename second file uses 16 chars for
@REM filename
@REM 
@REM This tests the removing of trailing blanks in filenames of T64

echo ================ Executing testcase T64_7
del T64_7\*.d64
mkdir T64_7
TargetD64  -c T64_7 filenames.t64

@REM #################################################################
@REM Testseries "builtin LNX support"
@REM #################################################################

@REM ################################################################
@REM Testcase LNX_1
@REM 
@REM The source archive contains:
@REM soccermania
@REM 
@REM Results in one disk containing soccermania

echo ================ Executing testcase LNX_1
del LNX_1\*.d64
mkdir LNX_1
TargetD64  -c LNX_1 soccermania.lnx

@REM ################################################################
@REM Testcase LNX_2
@REM 
@REM The source archive contains:
@REM 253bytes
@REM 254bytes
@REM 255bytes
@REM 8127bytes
@REM 8128bytes
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM 
@REM Results in one disk containing all programs

echo ================ Executing testcase LNX_2
del LNX_2\*.d64
mkdir LNX_2
TargetD64  -c LNX_2 lnx_2.lnx

@REM ################################################################
@REM Testcase LNX_3
@REM 
@REM The source archive contains:
@REM soccermania
@REM disk.lnx
@REM 
@REM Results in two disks containing
@REM -------------------
@REM soccermania
@REM -------------------
@REM 253bytes
@REM 254bytes
@REM 255bytes
@REM 8127bytes
@REM 8128bytes            disk.lnx extracted
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM -------------------

echo ================ Executing testcase LNX_3
del LNX_3\*.d64
mkdir LNX_3
TargetD64  -c LNX_3 lnx_3.lnx

@REM ################################################################
@REM Testcase LNX_4
@REM 
@REM The source archive contains:
@REM soccermania
@REM 1!disk
@REM 2!disk
@REM 3!disk
@REM 4!disk
@REM 
@REM Results in two disks containing:
@REM -------------------
@REM soccermania
@REM 1!disk               disk reflects source archive          
@REM 2!disk               as an unresolvable program is on it
@REM 3!disk               and initial conversion is done
@REM 4!disk               source archive->d64 (keep the d64)
@REM -------------------
@REM 253bytes
@REM 254bytes
@REM 255bytes
@REM 8127bytes
@REM 8128bytes            [1-4]!disk extracted
@REM 8129bytes
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM -------------------

echo ================ Executing testcase LNX_4
del LNX_4\*.d64
mkdir LNX_4
TargetD64  -c LNX_4 lnx_4.lnx

@REM ################################################################
@REM Testcase LNX_5
@REM 
@REM The source archive contains:
@REM soccermania.lnx
@REM 
@REM Results in one disk containing soccermania (via double unlynx)

echo ================ Executing testcase LNX_5
del LNX_5\*.d64
mkdir LNX_5
TargetD64  -c LNX_5 soccermania_doublelynx.lnx

@REM #################################################################
@REM Testseries "builtin C64ZIP support"
@REM #################################################################

@REM ################################################################
@REM Testcase C64ZIP_1
@REM 
@REM Only one part of the c64zip archive as command line parameter.
@REM 
@REM Results in one disk containing
@REM -------------------
@REM 253bytes
@REM 254bytes
@REM 255bytes
@REM 8127bytes
@REM 8128bytes            [1-4]!disk extracted. Missing parts are
@REM 8129bytes            automatically located
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM -------------------

echo ================ Executing testcase C64ZIP_1
del C64ZIP_1\*.d64
mkdir C64ZIP_1
TargetD64  -c C64ZIP_1 1!disk

@REM ################################################################
@REM Testcase C64ZIP_2
@REM 
@REM All parts of the c64zip archive as command line parameter.
@REM 
@REM Results in one disk containing
@REM -------------------
@REM 253bytes
@REM 254bytes
@REM 255bytes
@REM 8127bytes
@REM 8128bytes            [1-4]!disk extracted. Missing parts are
@REM 8129bytes            automatically located
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM -------------------

echo ================ Executing testcase C64ZIP_2
del C64ZIP_2\*.d64
mkdir C64ZIP_2
TargetD64  -c C64ZIP_2 1!disk 2!disk 3!disk 4!disk

@REM ################################################################
@REM Testcase C64ZIP_3
@REM 
@REM Parts of the c64zip archive distributed in two lynx files.
@REM a.lnx contains:
@REM 1!disk
@REM 2!disk
@REM b.lnx contains:
@REM 3!disk
@REM 4!disk
@REM 
@REM Results in one disk containing
@REM -------------------
@REM 253bytes
@REM 254bytes
@REM 255bytes
@REM 8127bytes
@REM 8128bytes            [1-4]!disk extracted. Parts are automatically 
@REM 8129bytes            associated from different source archives
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM -------------------

echo ================ Executing testcase C64ZIP_3
del C64ZIP_3\*.d64
mkdir C64ZIP_3
TargetD64  -c C64ZIP_3 a.lnx b.lnx

@REM ################################################################
@REM Testcase C64ZIP_4
@REM 
@REM Double c64zipped archive.
@REM [1-4]!double_zipped contains:
@REM 1!disk
@REM 2!disk
@REM 3!disk
@REM 4!disk
@REM 
@REM Results in one disk containing
@REM -------------------
@REM 253bytes
@REM 254bytes
@REM 255bytes
@REM 8127bytes
@REM 8128bytes            [1-4]!disk extracted 
@REM 8129bytes           
@REM 42163bytes
@REM 42164bytes
@REM 42165bytes
@REM -------------------

echo ================ Executing testcase C64ZIP_4
del C64ZIP_4\*.d64
mkdir C64ZIP_4
TargetD64  -c C64ZIP_4 1!double_zipped

@REM ################################################################
@REM Testcase C64ZIP_5
@REM 
@REM Missing c64zip archive (processing terminates)
@REM misssing_c64zip.zip contains:
@REM 1!disk
@REM 2!disk
@REM 3!disk (BUT NOT 4!disk)
@REM 
@REM Results in error termination of processing

echo ================ Executing testcase C64ZIP_5
del C64ZIP_5\*.d64
mkdir C64ZIP_5
TargetD64  -c C64ZIP_5 missing_c64zip.zip

@REM #################################################################
@REM Testseries "builtin PC64 file support"
@REM #################################################################

@REM ################################################################
@REM Testcase PC64_1
@REM 
@REM Pass mixture of PC64 archives, unresolvable archives to TD64
@REM PC64 archives and unresolvable archives are put into the same D64 image
@REM TD64 treats PC64 archives as a special form of unresolvable archives
@REM so no isolated D64 images are created
@REM soccermania.p00 contains soccermania.lnx which leads to a new D64 image
@REM 
@REM Results in two disks containing
@REM -------------------------------
@REM 254BYTES   PRG
@REM 254BYTES   DEL<
@REM 254BYTES   SEQ
@REM 254BYTES   USR
@REM 255BYTES   PRG
@REM 8128BYTES  PRG
@REM -------------------------------
@REM soccermania
@REM -------------------------------

echo ================ Executing testcase PC64_1
del PC64_1\*.d64
mkdir PC64_1
TargetD64  -c PC64_1 254bytes.p00 254bytes.d00 soccermania.p00 254bytes.s00 254bytes.u00 255bytes.p00 8128bytes

@REM #################################################################
@REM Testseries "builtin ZIP support"
@REM #################################################################

@REM ################################################################
@REM Testcase ZIP_1
@REM 
@REM Zip archive contains program with dirpath component:
@REM soccermania/soccermania.t64
@REM 
@REM Results in one disk containing
@REM soccermania         dirpath ignored

echo ================ Executing testcase ZIP_1
del ZIP_1\*.d64
mkdir ZIP_1
TargetD64  -c ZIP_1 path.zip

@REM ################################################################
@REM Testcase ZIP_2
@REM 
@REM Zip archive contains all incoming files of testcase D64_1.
@REM 
@REM Results are exactly the same than for D64_1

echo ================ Executing testcase ZIP_2 - compare D64_1
del ZIP_2\*.d64
mkdir ZIP_2
TargetD64  -c ZIP_2 zip_2.zip

@REM ################################################################
@REM Testcase ZIP_3

echo ================ Executing testcase ZIP_3 - compare D64_2
del ZIP_3\*.d64
mkdir ZIP_3
TargetD64  -c ZIP_3 zip_3.zip

@REM ################################################################
@REM Testcase ZIP_4

echo ================ Executing testcase ZIP_4 - compare D64_3
del ZIP_4\*.d64
mkdir ZIP_4
TargetD64  -c ZIP_4 zip_4.zip

@REM ################################################################
@REM Testcase ZIP_5

echo ================ Executing testcase ZIP_5 - compare D64_4
del ZIP_5\*.d64
mkdir ZIP_5
TargetD64  -c ZIP_5 zip_5.zip

@REM ################################################################
@REM Testcase ZIP_6

echo ================ Executing testcase ZIP_6 - compare D64_5
del ZIP_6\*.d64
mkdir ZIP_6
TargetD64  -c ZIP_6 zip_6.zip

@REM ################################################################
@REM Testcase ZIP_7

echo ================ Executing testcase ZIP_7 - compare D64_6
del ZIP_7\*.d64
mkdir ZIP_7
TargetD64  -c ZIP_7 zip_7.zip

@REM ################################################################
@REM Testcase ZIP_8

echo ================ Executing testcase ZIP_8 - compare D64_7
del ZIP_8\*.d64
mkdir ZIP_8
TargetD64  -c ZIP_8 zip_8.zip

@REM ################################################################
@REM Testcase ZIP_9

echo ================ Executing testcase ZIP_9 - compare D64_8
del ZIP_9\*.d64
mkdir ZIP_9
TargetD64  -c ZIP_9 zip_9.zip

@REM ################################################################
@REM Testcase ZIP_10

echo ================ Executing testcase ZIP_10 - compare T64_1
del ZIP_10\*.d64
mkdir ZIP_10
TargetD64  -c ZIP_10 zip_10.zip

@REM ################################################################
@REM Testcase ZIP_11

echo ================ Executing testcase ZIP_11 - compare T64_2
del ZIP_11\*.d64
mkdir ZIP_11
TargetD64  -c ZIP_11 zip_11.zip

@REM ################################################################
@REM Testcase ZIP_12

echo ================ Executing testcase ZIP_12 - compare T64_3
del ZIP_12\*.d64
mkdir ZIP_12
TargetD64  -c ZIP_12 zip_12.zip

@REM ################################################################
@REM Testcase ZIP_13

echo ================ Executing testcase ZIP_13 - compare T64_4
del ZIP_13\*.d64
mkdir ZIP_13
TargetD64  -c ZIP_13 zip_13.zip

@REM ################################################################
@REM Testcase ZIP_14

echo ================ Executing testcase ZIP_14 - compare T64_5
del ZIP_14\*.d64
mkdir ZIP_14
TargetD64  -c ZIP_14 zip_14.zip

@REM ################################################################
@REM Testcase ZIP_15

echo ================ Executing testcase ZIP_15 - compare LNX_1
del ZIP_15\*.d64
mkdir ZIP_15
TargetD64  -c ZIP_15 zip_15.zip

@REM ################################################################
@REM Testcase ZIP_16

echo ================ Executing testcase ZIP_16 - compare LNX_2
del ZIP_16\*.d64
mkdir ZIP_16
TargetD64  -c ZIP_16 zip_16.zip

@REM ################################################################
@REM Testcase ZIP_17

echo ================ Executing testcase ZIP_17 - compare LNX_3
del ZIP_17\*.d64
mkdir ZIP_17
TargetD64  -c ZIP_17 zip_17.zip

@REM ################################################################
@REM Testcase ZIP_18

echo ================ Executing testcase ZIP_18 - compare LNX_4
del ZIP_18\*.d64
mkdir ZIP_18
TargetD64  -c ZIP_18 zip_18.zip

@REM ################################################################
@REM Testcase ZIP_19

echo ================ Executing testcase ZIP_19 - compare LNX_5
del ZIP_19\*.d64
mkdir ZIP_19
TargetD64  -c ZIP_19 zip_19.zip

@REM ################################################################
@REM Testcase ZIP_20

echo ================ Executing testcase ZIP_20 - compare C64ZIP_1
del ZIP_20\*.d64
mkdir ZIP_20
TargetD64  -c ZIP_20 zip_20.zip

@REM ################################################################
@REM Testcase ZIP_21

echo ================ Executing testcase ZIP_21 - compare C64ZIP_3
del ZIP_21\*.d64
mkdir ZIP_21
TargetD64  -c ZIP_21 zip_21.zip

@REM ################################################################
@REM Testcase ZIP_22

echo ================ Executing testcase ZIP_22 - compare C64ZIP_4
del ZIP_22\*.d64
mkdir ZIP_22
TargetD64  -c ZIP_22 zip_22.zip

@REM #################################################################
@REM Testseries "builtin LHA support"
@REM #################################################################

@REM ################################################################
@REM Testcase LHA_1
@REM 
@REM Zip archive contains program with dirpath component:
@REM soccermania/soccermania.t64
@REM 
@REM Results in one disk containing
@REM soccermania         dirpath ignored

echo ================ Executing testcase LHA_1
del LHA_1\*.d64
mkdir LHA_1
TargetD64  -c LHA_1 path.lha

@REM ################################################################
@REM Testcase LHA_2
@REM 
@REM Zip archive contains all incoming files of testcase D64_1.
@REM 
@REM Results are exactly the same than for D64_1

echo ================ Executing testcase LHA_2 - compare D64_1
del LHA_2\*.d64
mkdir LHA_2
TargetD64  -c LHA_2 lha_2.lha

@REM ################################################################
@REM Testcase LHA_3

echo ================ Executing testcase LHA_3 - compare D64_2
del LHA_3\*.d64
mkdir LHA_3
TargetD64  -c LHA_3 lha_3.lha

@REM ################################################################
@REM Testcase LHA_4

echo ================ Executing testcase LHA_4 - compare D64_3
del LHA_4\*.d64
mkdir LHA_4
TargetD64  -c LHA_4 lha_4.lha

@REM ################################################################
@REM Testcase LHA_5

echo ================ Executing testcase LHA_5 - compare D64_4
del LHA_5\*.d64
mkdir LHA_5
TargetD64  -c LHA_5 lha_5.lha

@REM ################################################################
@REM Testcase LHA_6

echo ================ Executing testcase LHA_6 - compare D64_5
del LHA_6\*.d64
mkdir LHA_6
TargetD64  -c LHA_6 lha_6.lha

@REM ################################################################
@REM Testcase LHA_7

echo ================ Executing testcase LHA_7 - compare D64_6
del LHA_7\*.d64
mkdir LHA_7
TargetD64  -c LHA_7 lha_7.lha

@REM ################################################################
@REM Testcase LHA_8

echo ================ Executing testcase LHA_8 - compare D64_7
del LHA_8\*.d64
mkdir LHA_8
TargetD64  -c LHA_8 lha_8.lha

@REM ################################################################
@REM Testcase LHA_9

echo ================ Executing testcase LHA_9 - compare D64_8
del LHA_9\*.d64
mkdir LHA_9
TargetD64  -c LHA_9 lha_9.lha

@REM ################################################################
@REM Testcase LHA_10

echo ================ Executing testcase LHA_10 - compare T64_1
del LHA_10\*.d64
mkdir LHA_10
TargetD64  -c LHA_10 lha_10.lha

@REM ################################################################
@REM Testcase LHA_11

echo ================ Executing testcase LHA_11 - compare T64_2
del LHA_11\*.d64
mkdir LHA_11
TargetD64  -c LHA_11 lha_11.lha

@REM ################################################################
@REM Testcase LHA_12

echo ================ Executing testcase LHA_12 - compare T64_3
del LHA_12\*.d64
mkdir LHA_12
TargetD64  -c LHA_12 lha_12.lha

@REM ################################################################
@REM Testcase LHA_13

echo ================ Executing testcase LHA_13 - compare T64_4
del LHA_13\*.d64
mkdir LHA_13
TargetD64  -c LHA_13 lha_13.lha

@REM ################################################################
@REM Testcase LHA_14

echo ================ Executing testcase LHA_14 - compare T64_5
del LHA_14\*.d64
mkdir LHA_14
TargetD64  -c LHA_14 lha_14.lha

@REM ################################################################
@REM Testcase LHA_15

echo ================ Executing testcase LHA_15 - compare LNX_1
del LHA_15\*.d64
mkdir LHA_15
TargetD64  -c LHA_15 lha_15.lha

@REM ################################################################
@REM Testcase LHA_16

echo ================ Executing testcase LHA_16 - compare LNX_2
del LHA_16\*.d64
mkdir LHA_16
TargetD64  -c LHA_16 lha_16.lha

@REM ################################################################
@REM Testcase LHA_17

echo ================ Executing testcase LHA_17 - compare LNX_3
del LHA_17\*.d64
mkdir LHA_17
TargetD64  -c LHA_17 lha_17.lha

@REM ################################################################
@REM Testcase LHA_18

echo ================ Executing testcase LHA_18 - compare LNX_4
del LHA_18\*.d64
mkdir LHA_18
TargetD64  -c LHA_18 lha_18.lha

@REM ################################################################
@REM Testcase LHA_19

echo ================ Executing testcase LHA_19 - compare LNX_5
del LHA_19\*.d64
mkdir LHA_19
TargetD64  -c LHA_19 lha_19.lha

@REM ################################################################
@REM Testcase LHA_20

echo ================ Executing testcase LHA_20 - compare C64ZIP_1
del LHA_20\*.d64
mkdir LHA_20
TargetD64  -c LHA_20 lha_20.lha

@REM ################################################################
@REM Testcase LHA_21

echo ================ Executing testcase LHA_21 - compare C64ZIP_3
del LHA_21\*.d64
mkdir LHA_21
TargetD64  -c LHA_21 lha_21.lha

@REM ################################################################
@REM Testcase LHA_22

echo ================ Executing testcase LHA_22 - compare C64ZIP_4
del LHA_22\*.d64
mkdir LHA_22
TargetD64  -c LHA_22 lha_22.lha

@REM #################################################################
@REM Testseries "builtin GZ support"
@REM #################################################################

@REM ################################################################
@REM Testcase GZ_1
@REM 
@REM Gnuzip archive contains incoming file of testcase D64_5.
@REM 
@REM Results are exactly the same than for D64_5

echo ================ Executing testcase GZ_1 - compare D64_5
del GZ_1\*.d64
mkdir GZ_1
TargetD64  -c GZ_1 d64_5.d64.gz

@REM ################################################################
@REM Testcase GZ_2

echo ================ Executing testcase GZ_2 - compare D64_6
del GZ_2\*.d64
mkdir GZ_2
TargetD64  -c GZ_2 d64_6.d64.gz

@REM ################################################################
@REM Testcase GZ_3

echo ================ Executing testcase GZ_3 - compare D64_7
del GZ_3\*.d64
mkdir GZ_3
TargetD64  -c GZ_3 d64_7.d64.gz

@REM ################################################################
@REM Testcase GZ_4

echo ================ Executing testcase GZ_4 - compare D64_8
del GZ_4\*.d64
mkdir GZ_4
TargetD64  -c GZ_4 d64_8.d64.gz

@REM ################################################################
@REM Testcase GZ_5

echo ================ Executing testcase GZ_5 - compare T64_1
del GZ_5\*.d64
mkdir GZ_5
TargetD64  -c GZ_5 soccermania.t64.gz

@REM ################################################################
@REM Testcase GZ_6

echo ================ Executing testcase GZ_6 - compare T64_2
del GZ_6\*.d64
mkdir GZ_6
TargetD64  -c GZ_6 t64_2.t64.gz

@REM ################################################################
@REM Testcase GZ_7

echo ================ Executing testcase GZ_7 - compare T64_3
del GZ_7\*.d64
mkdir GZ_7
TargetD64  -c GZ_7 t64_3.t64.gz

@REM ################################################################
@REM Testcase GZ_8

echo ================ Executing testcase GZ_8 - compare T64_4
del GZ_8\*.d64
mkdir GZ_8
TargetD64  -c GZ_8 t64_4.t64.gz

@REM ################################################################
@REM Testcase GZ_9

echo ================ Executing testcase GZ_9 - compare T64_5
del GZ_9\*.d64
mkdir GZ_9
TargetD64  -c GZ_9 t64_5.t64.gz

@REM ################################################################
@REM Testcase GZ_10

echo ================ Executing testcase GZ_10 - compare LNX_1
del GZ_10\*.d64
mkdir GZ_10
TargetD64  -c GZ_10 soccermania.lnx.gz

@REM ################################################################
@REM Testcase GZ_11

echo ================ Executing testcase GZ_11 - compare LNX_2
del GZ_11\*.d64
mkdir GZ_11
TargetD64  -c GZ_11 lnx_2.lnx.gz

@REM ################################################################
@REM Testcase GZ_12

echo ================ Executing testcase GZ_12 - compare LNX_3
del GZ_12\*.d64
mkdir GZ_12
TargetD64  -c GZ_12 lnx_3.lnx.gz

@REM ################################################################
@REM Testcase GZ_13

echo ================ Executing testcase GZ_13 - compare LNX_4
del GZ_13\*.d64
mkdir GZ_13
TargetD64  -c GZ_13 lnx_4.lnx.gz

@REM ################################################################
@REM Testcase GZ_14

echo ================ Executing testcase GZ_14 - compare LNX_5
del GZ_14\*.d64
mkdir GZ_14
TargetD64  -c GZ_14 soccermania_doublelynx.lnx.gz

@REM The following sections will be commented out in the windows batchfile

@REM #################################################################
@REM Testseries "exception handling"
@REM #################################################################

@REM ################################################################
@REM Testcase EXC_1
@REM An empty archive is passed to TD64 - no emulator image created

echo ================ Executing testcase EXC_1
del EXC_1\*.d64
mkdir EXC_1
TargetD64  -c EXC_1 exc_1.zip

@REM ################################################################
@REM Testcase EXC_2
@REM An directory is passed to TD64 - no emulator image created

echo ================ Executing testcase EXC_2
del EXC_2\*.d64
mkdir EXC_2
TargetD64  -c EXC_2 EXC_2

@REM ################################################################
@REM Testcase EXC_3
@REM An directory and an empty archive are passed to TD64
@REM - no emulator image created

echo ================ Executing testcase EXC_3
del EXC_3\*.d64
mkdir EXC_3
TargetD64  -c EXC_3 EXC_3 exc_1.zip

@REM ################################################################
@REM Testcase EXC_4
@REM An non existing file is passed to TD64
@REM - no emulator image created

echo ================ Executing testcase EXC_4
del EXC_4\*.d64
mkdir EXC_4
TargetD64  -c EXC_4 blabla


@REM ################################################################
@REM Testcase EXC_5
@REM A directory, a non existing file and soccermania.lnx are passed to TD64
@REM The emulator image for soccermania.lnx has to be created. Others produce
@REM exception messages.

echo ================ Executing testcase EXC_5
del EXC_5\*.d64
mkdir EXC_5
TargetD64  -c EXC_5 EXC_5 blabla soccermania.lnx


@REM ################################################################
@REM Testcase EXC_6
@REM A zero byte length archive is passed to TD64

echo ================ Executing testcase EXC_6
del EXC_6\*.d64
mkdir EXC_6
TargetD64  -c EXC_6 0bytes
