/*----------------------------------------------------------------------*/
/*		LHarc Archiver Driver for UNIX				*/
/*		This is part of LHarc UNIX Archiver Driver		*/
/*									*/
/*		Copyright(C) MCMLXXXIX  Yooichi.Tagawa			*/
/*		Thanks to H.Yoshizaki. (MS-DOS LHarc)			*/
/*									*/
/*  V0.00  Original				1988.05.23  Y.Tagawa	*/
/*  V0.01  Alpha Version (for 4.2BSD)		1989.05.28  Y.Tagawa	*/
/*  V0.02  Alpha Version Rel.2			1989.05.29  Y.Tagawa	*/
/*  V0.03  Release #3  Beta Version		1989.07.02  Y.Tagawa	*/
/*  V0.03a Debug				1989.07.03  Y.Tagawa	*/
/*  V0.03b Modified				1989.07.13  Y.Tagawa	*/
/*  V0.03c Debug (Thanks to void@rena.dit.junet)1989.08.09  Y.Tagawa	*/
/*  V0.03d Modified (quiet and verbose)		1989.09.14  Y.Tagawa	*/
/*  V1.00  Fixed				1989.09.22  Y.Tagawa	*/
/*  V1.01  Bug Fixed				1989.12.25  Y.Tagawa	*/
/*									*/
/*  DOS-Version Original LHx V C2.01 		(C) H.Yohizaki		*/
/*									*/
/*  V2.00  UNIX Lharc + DOS LHx -> OSK LHx	1990.11.01  Momozou	*/
/*  V2.01  Minor Modified			1990.11.24  Momozou	*/
/*									*/
/*  V0.02  LHx for UNIX				1991.11.18  M.Oki	*/
/*  V0.03  LHa for UNIX				1991.12.17  M.Oki	*/
/*  V0.04  LHa for UNIX	beta version		1992.01.20  M.Oki	*/
/*  V1.00  LHa for UNIX	Fixed			1992.03.19  M.Oki	*/
/*----------------------------------------------------------------------*/

/*
this LHA package is the WORST code I have seen for a long time
in general no files are closed and no allocated heap is freed
information is preferably passed via global variables

I have rewritten this file (lharc.c) completly
but do not expect it to be much better than the original
at least I have introduced an error handling which
closes all resources after execution

well I do not have anything better so thanks anyway to the original authors
All changes (except this file) marked with TD64_MODIFIED
Those modifications by Karlheinz Langguth klangguth@netscape.net
*/

#include <setjmp.h>
#include "lharc.h"

char	*archive_name;
char *extract_directory = NULL;

static char *errorText = NULL; /*in case of error the text is stored here*/


/*
it would be too much effort to change the code so I simply
keep track of all allocations and fopens to free everything later on
*/
#undef fopen
#undef fclose
#undef malloc
#undef free

#define TRACKSIZE 50
static void* allocs[TRACKSIZE] = { NULL };
static FILE* opens[TRACKSIZE] = { NULL };


void* trackMalloc(size_t size)
{
	int i;
	for (i = 0; i < TRACKSIZE; i++)
	{
		if (allocs[i] == NULL)
			return (allocs[i] = malloc(size));
	}
	fatal_error("Alloc in tracker failed");
	return NULL;
}


void trackFree(void *p)
{
	int i;
	for (i = 0; i < TRACKSIZE; i++)
	{
		if (allocs[i] == p)
		{
			free(p);
			allocs[i] = NULL;
			return;
		}
	}
	fatal_error("Free in tracker failed");
}


static void freeAll(void)
{
	int i;
	for (i = 0; i < TRACKSIZE; i++)
	{
		if (allocs[i] != NULL)
		{
			free(allocs[i]);
			allocs[i] = NULL;
		}
	}
}


void* trackFopen(const char *filename, const char *mode)
{
	int i;
	for (i = 0; i < TRACKSIZE; i++)
	{
		if (opens[i] == NULL)
			return (opens[i] = fopen(filename, mode));
	}
	fatal_error("Fopen in tracker failed");
	return NULL;
}


void trackFclose(FILE *fp)
{
	int i;
	for (i = 0; i < TRACKSIZE; i++)
	{
		if (opens[i] == fp)
		{
			fclose(fp);
			opens[i] = NULL;
			return;
		}
	}
	fatal_error("Fclose in tracker failed");
}


static void fcloseAll(void)
{
	int i;
	for (i = 0; i < TRACKSIZE; i++)
	{
		if (opens[i] != NULL)
		{
			fclose(opens[i]);
			opens[i] = NULL;
		}
	}
}


static jmp_buf mark;

int Unlha(char *lhaFile, char *extractDir, char **errorMsg)
{
	int jmpret;

	errorText = NULL;
	extract_directory = extractDir;
	archive_name = lhaFile;
	jmpret = setjmp(mark); /*return here in case of error*/
	if (jmpret == 0)
	{
		/*only call cmd_extract after saving the stack environment*/
		/*it is NOT called after longjmp has been executed*/
		cmd_extract();
	}
	/*clean up in case of error AND normal operation*/
	freeAll(); /*free all allocated memory*/
	fcloseAll(); /*close all opened files*/

	*errorMsg = errorText; /*set error message for caller*/
	if (errorText == NULL)
		return 0; /*success*/
	else
		return -1; /*error*/
}


void fatal_error (char *msg)
{
	errorText = msg;
	longjmp(mark, 1);
}




