//////////////////////////////////////////////////////////////////////
//TargetD64 - C64 archive related conversion tool and emulator frontend
//////////////////////////////////////////////////////////////////////
//Copyright (C) 1998, 1999  Karlheinz Langguth klangguth@netscape.net
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
//COMPILE SWITCHES
// _MSC_VER
// indicates MS compiler
// _DEBUG
// for debug version which activates ASSERT and TRACE
// TD64_MODIFIED
// marks changes in foreign sources to fit into TargetD64
// must be set everywhere because also used for header files

#ifdef _DEBUG

#include <stdlib.h>

#include <string>
#include <iostream>
#include <fstream>
#ifdef _MSC_VER
#include <typeinfo.h>
#else
#include <typeinfo>
#endif

using namespace std;

#include "Tracing.h"

//this variable is used for system wide trace
CTrace _glbTrace(cerr.rdbuf());
 
CTrace::CTrace(streambuf* sb) : ostream(sb), m_nesting(0), m_attachedFile(NULL)
{
	char *tmp = getenv("TRACE");
	string trace(tmp ? tmp : "");
	if ((trace == "on") || (trace == "ON") || (trace == "On"))
	{
		m_bActive = true;
	}
	else
	{
		m_bActive = false;
	}
}


void CTrace::AttachTraceDumpToFile(const string& filename)
{
	if (m_attachedFile != NULL)
	{
		delete m_attachedFile;
		m_attachedFile = NULL;
	}
	//check if stdout is required for output stream
	if ((filename != "cout") && (filename != "stdout"))
	{
		//file
		m_attachedFile = new ofstream(filename.c_str(), ios::out | ios::binary);
		ASSERT(m_attachedFile != NULL);
		if (!(*m_attachedFile))
		{
			delete m_attachedFile;
			m_attachedFile = NULL;
		}
		else
		{
			(void)rdbuf(m_attachedFile->rdbuf());
		}
	}
	else
	{
		//stdout
		(void)rdbuf(cout.rdbuf());
	}
}


bool CTrace::TraceBegin(void)
{
	if (!m_bActive)
	{
		m_nesting++; //still keep track of nesting level
		return false;
	}
	(void)TraceMargin();
	*this << "+-BEGIN ";
	m_nesting++;
	return true;
}


bool CTrace::TraceEnd(void)
{
	if (!m_bActive)
	{
		m_nesting--; //still keep track of nesting level
		return false;
	}
	m_nesting--;
	(void)TraceMargin();
	*this << "+-END " <<endl;
	return true;
}


bool CTrace::TraceMargin(void)
{
	if (!m_bActive)
		return false;
	for (int i = 0; i < m_nesting; i++)
		*this << "|";
	return true;
}

void CTrace::TraceOff(void)
{
	m_bActive = false;
}

void CTrace::TraceOn(void)
{
	m_bActive = true;
}


bool CTrace::TestTraceOn(void) const
{
	return m_bActive;
}

#endif
