/*
 * Copyright (C) 1998, 1999 Wolfgang Moser
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Commodore CBM 1581 floppy disk copy util for PC's, CENTRAL.H
 *
 * Wolfgang Moser <womo@mindless.com>
 *   http://www.gm.fh-koeln.de/~womo (up to Dezember 1999)
 *
 *
 * Basic informations from Dan Fandrich <dan@fch.wimsey.bc.ca>.
 *   His readme of the cbmfs-0.3 driver for Linux explained me, what the
 *   difference between a DOS formatted 800 kb disk and a CBM 1581 disk is.
 *   (check: http://vanbc.wimsey.com/~danf/software/)
 *
 *
 * Basic implementations by Ciriaco Garca de Celis <ciri@gui.uva.es>
 *   His util 765Debug, Version 5.0 is great for learning dma based
 *   direct floppy disk controller programming.
 *   (check: ftp://ftp.gui.uva.es/pub/pc/2m/765d50sr.zip)
 *
 * Check out for his floppy disk utils 2M and 2MGUI, the last words
 * in improving floppy disk storage capacity.
 *   http://www.gui.uva.es/2m, ftp://ftp.gui.uva.es/pub/pc/2m
 *
 *
 * For additional informations to FDC programming check:
 *     http://developer.intel.com/design/periphrl/datashts/290468.htm
 *   and get the intel 82078 CHMOS Single-Chip Floppy Disk Controller
 *   PDF document:
 *     http://www.intel.nl/design/periphrl/datashts/29047403.pdf
 *   National Semiconductor has also some pages about their PC
 *   compatible controllers:
 *     http://www.national.com/pf/DP/DP8473.html
 *     http://www.national.com/pf/DP/DP8477B.html
 *
 * Another good source for floppy disk controller programming information
 * are the linux kernal sources, you could have a look into:
 *     http://www.cs.utexas.edu/users/peterson/linux/include/linux/fdreg.h
 *     http://www.cs.utexas.edu/users/peterson/linux/drivers/block/floppy.c
 *
 * Now, that I started talking about Linux: Check out the most massive
 * attack against floppy disks ever made, Alain Knaff's fdutils:
 *     http://fdutils.linux.lu/
 *     http://alain.knaff.linux.lu/
 */


#ifndef __Central_1581COPY__
#define __Central_1581COPY__

// version information

#define _1581COPY_version_ \
"1581-Copy/FLT, ver. 0.51, 199908171959. "\
"Copyright (C) 1998, 1999 Wolfgang Moser\n"

// central #defines

#define MaxSectors 10					// This controls the size of the internal buffer
												// that is needed for formatting and single sector track
												// copying, it must be greater than or equal to the
												// number of sectors per side (track), that may be used
												// with a desired disk layout

#define TrBufSize 10*1024				// This controls the size of the track buffer, it must
												// be big enough to hold all the sector data of one side
												// currently: 10 sectors a 1024 bytes for FD2000

#define DISABLE_INTS						// disabling INTs, when programming the DMA controller

#define DoubleTrackBuffer				// enable a double sized track buffer for two track sides

//	#define MESSAGES 3					// enable some debugging messages
												// >= 6  - enable all messages
                                    // >= 5  - enable all high level code messages
                                    // >= 3  - enable working stage high level info
                                    // >= 2  - enable sector processing high level info
                                    // >= 1  - enable all main program messages
                                    // >= 0  - main program error reportations

//	#define USE_TSC						// use system timestamp counter for debug measurements
//	#define USE_P_RDTSC					// use pentium timestamp counter instead of system timer

#define TimeEstimation
//	#define FDCintel82078				// enabling support for the intel 82078 FDC

//	#define ScanEqual						// enable real a comparison instead of simple CRC verify
												// scanEqual doesn't work, so it let the processor
												// compare, but this is much too lame
			// needs an extra interleave after the verify operation
         // the comparison speed would have to be increased

//	#define CreateMaverickDisk	0		// enabling special (wrong) formatting to create
												// Maverick like disks for test purposes
                                    // define the number to store in the side ID field
//	#define CreateMaverickDisk	3		// to test the swap ID check disabling
//	#define CreateMaverickDisk	i		// store the number of the sector into the side ID field
                                    // this is a format, that 1581-Copy definetly cannot handle
//	#define CreateMaverickDisk	side	// the correct CBM1581 format
//	#define CreateMaverickDisk	!side	// this one would be a correct DOS like format but without a
												// correct bootblock, cannot be read with DOS tools normally

#endif

