#!/bin/sh
#TargetD64 test suite
#(c) 1999 Karlheinz Langguth under the terms of GPL
#TargetD64 homepage at
#http://skyscraper.fortunecity.com/quadra/251/targetd64.html
#Contact the author by mailto:klangguth@netscape.net
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#ATTENTION: restrict the commands to M$ syntax as batchfile
#           is generated automatically

#usage: test.sh [-c dir]
#without parameters test suite is executed
#-c dir executes MERELY result check of results in dir

#The following section will be commented out in the windows batchfile
#start no win

#no interference with my own setup
unset TD64_GENERIC_EXT1
unset TD64_GENERIC_EXT2
unset TD64_GENERIC_EXT3
unset TD64_GENERIC_EXT4
unset TD64_GENERIC_EXT5
unset TD64_GENERIC_EXT6
unset TD64_GENERIC_EXT7
unset TD64_GENERIC_EXT8
unset TD64_GENERIC_EXT9
unset TD64_GENERIC_CMD1
unset TD64_GENERIC_CMD2
unset TD64_GENERIC_CMD3
unset TD64_GENERIC_CMD4
unset TD64_GENERIC_CMD5
unset TD64_GENERIC_CMD6
unset TD64_GENERIC_CMD7
unset TD64_GENERIC_CMD8
unset TD64_GENERIC_CMD9
unset TD64_DEFAULT_OPTIONS

options=""


#this does the comparison between all files in $1 and $2
#$1 is the produced result dir, $2 the expected result dir
CmpDirs()
{
#  filter out those unhealthy PIDs in filenames and linenumbers 
#  which make comparison fail!
   if test -e $1/stderr
   then
      sed -e "/^Exception param1:/ d" \
          -e "/^Location lineno : / d" \
          -e "/^Location source : / d" \
          $1/stderr >$1/stderr.unfiltered 
      mv $1/stderr.unfiltered $1/stderr
   fi
#  do the verification
   failed=0
   for i in `ls $1/* 2>/dev/null`
   do
      expected_result_file=$2/`basename $i`
      cmp -s $i $expected_result_file
	  if test $? -ne 0
	  then
	     failed=1
		 echo "RESULT VERIFY ERROR: $i $expected_result_file"
      fi
   done
   if test $failed -eq 0 -a `ls $1 | wc -l` -ne `ls $2 | wc -l`
   then
      failed=1
	  diff -q $1 $2
      echo "RESULT VERIFY ERROR: overall count of produced files wrong"
   fi
   if test $failed -ne 0
   then
      echo "$1 FAILED automatic result verification"
   else
      echo "$1 PASSED automatic result verification"
   fi
}


#this does the automatic result verification for linux
#no such thing for win32 - will call targetd64 directly
#because filenames are case insensitive
TargetD64()
{
   index=2
#  determine the directory of test case 
   for i
   do
#     first argument after options must be directory   
      if test `expr "$i" : '\(.\)'` = "-"
	  then
	     dir=`eval echo "$""${index}"`
      fi
	  index=`expr $index + 1`	  
   done
   targetd64 $* >$dir/stdout 2>$dir/stderr
# do the result verify
   CmpDirs $dir $dir.OK
}

#Provide the Windows 32 bit version of this batchfile
#(thank god I don't have to perform this task on Win32)
sed -e "s/\\\!/!/g" -e "/^#start no win/,/^#end no win/ d" -e "s/^#/@REM /" -e "s/\$options/$options/g" $0 >test.tmp
#DOS newlines
sed -e "s/$/`echo -n -e "\r"`/" test.tmp >test.bat
rm -f test.tmp

#wipe the result directory of a testcase if wanted
#this emulates the DOS del command
del()
{
	last=`expr $1 : '.*\(.....\)'`
	first=`expr $1 : '\(.*\).....'`
	if test "$last" = '*.d64'
	then
		if test -d "$first"
		then
			rm -f $first/*
			rmdir $first
		fi
	else
		rm -f $*
	fi
}


#check for command line options
if test "$1" = "-c"
then
# check the expected results from this dir against the results in $2
	if test -d "$2"
	then
		for i in `find $2 -type d -name "*_[0-9]*" | sed -e "/\.OK/ d" -e "/\.ok/ d"`
		do
#           DOS filenames are case insensitive		
			u=`echo $i | tr a-z A-Z`
			CmpDirs $i ./`basename $u`.OK
		done
	else
		echo "Argument is no directory: $2" >&2
	fi
	exit 0
fi


#end no win

##################################################################
#Testseries "builtin D64 support"
##################################################################

#################################################################
#Testcase D64_1
#Insert files of the following length:
#253, 254, 255, 8127, 8128, 8129, 42163, 42164, 42165 bytes
#Should lead to one disk with blocksizes
#1  , 1  , 2  , 32  , 32  , 33  , 166  , 166  , 167
#Disk should have 64 Blocks free
#Load and run the files from the disk(s) and compare the output to
#the filelength (use CBM LOAD statement)
#
#Tests general function and blocksize overflow in data
#and directory (> 8 entries)

echo ================ Executing testcase D64_1
del D64_1\*.d64
mkdir D64_1
TargetD64 $options -c D64_1 253bytes 254bytes 255bytes 8127bytes 8128bytes 8129bytes 42163bytes 42164bytes 42165bytes

#################################################################
#Testcase D64_2
#Insert files of the following length:
#42164, 42164, 42164, 42164
#Should lead to one disk with blocksizes
#166  , 166  , 166  , 166
#Disk should have 0 Blocks free
#Load and run the files from the disk(s) and compare the output to
#the filelength (use CBM LOAD statement)
#
#Tests disk filled up to the last data byte

echo ================ Executing testcase D64_2
del D64_2\*.d64
mkdir D64_2
TargetD64 $options -c D64_2 42164bytes 42164bytes2 42164bytes3 42164bytes4

#################################################################
#Testcase D64_3
#Insert files of the following length:
#42164, 42164, 42164, 42164, 253
#Should lead to two disk with blocksizes
#166  , 166  , 166  , 166
#                            1
#Disk1 should have 0 Blocks free
#Disk2 should have 663 Blocks free
#Load and run the files from the disk(s) and compare the output to
#the filelength (use CBM LOAD statement)
#
#Tests disk overflow. There have to be two disks created.

echo ================ Executing testcase D64_3
del D64_3\*.d64
mkdir D64_3
TargetD64 $options -c D64_3 42164bytes 42164bytes2 42164bytes3 42164bytes4 253bytes

#################################################################
#Testcase D64_4
#Insert files of the following length:
#42164, 42164, 42165, 42164
#Should lead to two disk with blocksizes
#166  , 166  , 167
#                     166
#Disk1 should have 165 Blocks free
#Disk2 should have 498 Blocks free
#Load and run the files from the disk(s) and compare the output to
#the filelength (use CBM LOAD statement)
#
#Tests disk overflow by one byte. There have to be two disks created.

echo ================ Executing testcase D64_4
del D64_4\*.d64
mkdir D64_4
TargetD64 $options -c D64_4 42164bytes 42164bytes2 42165bytes 42164bytes3

#################################################################
#Testcase D64_5
#The source disk contains the same programs as written in D64_1.
#The source disk is not converted and provided as is (nothing to resolve).
#
#Test a "straight" D64 image

echo ================ Executing testcase D64_5
del D64_5\*.d64
mkdir D64_5
TargetD64 $options -c D64_5 d64_5.d64

#################################################################
#Testcase D64_6
#The source disk contains:
#1!disk
#2!disk
#3!disk
#4!disk
#soccermania
#
#Results in two disks containing:
#-------------------
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes            [1-4]!disk extracted
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#-------------------
#1!disk               source disk is kept as there is soccermania          
#2!disk               as an unresolvable program on it
#3!disk
#4!disk
#soccermania
#-------------------

echo ================ Executing testcase D64_6
del D64_6\*.d64
mkdir D64_6
TargetD64 $options -c D64_6 d64_6.d64

#################################################################
#Testcase D64_7
#
#The source disk contains:
#1!disk
#2!disk
#3!disk
#4!disk
#
#Results in one disk containing:
#253bytes           
#254bytes                 [1-4]!disk extracted.
#255bytes                 No need to keep the source disk as
#8127bytes                there is no more data on it.
#8128bytes
#8129bytes
#42163bytes
#42164bytes
#42165bytes

echo ================ Executing testcase D64_7
del D64_7\*.d64
mkdir D64_7
TargetD64 $options -c D64_7 d64_7.d64

#################################################################
#Testcase D64_8
#
#The source disk contains:
#soccermania
#soccermania.lnx
#
#Results in two disks:
#-------------------
#soccermania          source disk is kept as there is soccermania
#soccermania.lnx      as an unresolvable program on it
#-------------------
#soccermania          from soccermania.lnx
#-------------------

echo ================ Executing testcase D64_8
del D64_8\*.d64
mkdir D64_8
TargetD64 $options -c D64_8 d64_8.d64

#################################################################
#Testcase D64_9
#
#The source disk is a 175531 bytes D64 containing:
#soccermania
#soccermania.lnx
#1!disk
#2!disk
#3!disk
#4!disk
#
#Results in three disks:
#-------------------
#soccermania          source disk is kept as there is soccermania
#soccermania.lnx      as an unresolvable program on it
#1!disk
#2!disk
#3!disk
#4!disk
#-------------------
#soccermania          from soccermania.lnx
#-------------------
#253bytes           
#254bytes             [1-4]!disk extracted.
#255bytes
#8127bytes 
#8128bytes
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#-------------------

echo ================ Executing testcase D64_9
del D64_9\*.d64
mkdir D64_9
TargetD64 $options -c D64_9 d64_9.d64

#################################################################
#Testcase D64_10
#
#The source disk is a 196608 bytes D64 containing:
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#1!disk
#2!disk
#3!disk
#4!disk
#soccermania.lnx
#
#Results in three disks:
#-------------------
#253bytes        source disk is kept as there is soccermania
#254bytes        as an unresolvable program on it
#255bytes
#8127bytes
#8128bytes
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#1!disk
#2!disk
#3!disk
#4!disk
#soccermania.lnx
#-------------------
#253bytes           
#254bytes             [1-4]!disk extracted.
#255bytes
#8127bytes
#8128bytes
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#-------------------
#soccermania          from soccermania.lnx
#-------------------

echo ================ Executing testcase D64_10
del D64_10\*.d64
mkdir D64_10
TargetD64 $options -c D64_10 d64_10.d64

#################################################################
#Testcase D64_11
#
#The source disk is a 197376 bytes D64 containing:
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#1!disk
#2!disk
#3!disk
#4!disk
#soccermania.lnx
#
#Results in three disks:
#-------------------
#253bytes        source disk is kept as there is soccermania
#254bytes        as an unresolvable program on it
#255bytes
#8127bytes
#8128bytes
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#1!disk
#2!disk
#3!disk
#4!disk
#soccermania.lnx
#-------------------
#253bytes           
#254bytes             [1-4]!disk extracted.
#255bytes 
#8127bytes 
#8128bytes
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#-------------------
#soccermania          from soccermania.lnx
#-------------------

echo ================ Executing testcase D64_11
del D64_11\*.d64
mkdir D64_11
TargetD64 $options -c D64_11 d64_11.d64

##################################################################
#Testseries "builtin X64 support"
##################################################################

#################################################################
#Testcase X64_1
#
#x64_1.x64 contains:
#Result of D64_7
#x64_2.x64 contains:
#Result of LNX_1

echo ================ Executing testcase X64_1
del X64_1\*.d64
mkdir X64_1
TargetD64 $options -c X64_1 x64_1.x64 x64_2.x64


##################################################################
#Testseries "builtin T64 support"
##################################################################

#################################################################
#Testcase T64_1
#
#The source tape contains:
#soccermania
#
#Results in one disk containing soccermania

echo ================ Executing testcase T64_1
del T64_1\*.d64
mkdir T64_1
TargetD64 $options -c T64_1 soccermania.t64

#################################################################
#Testcase T64_2
#
#The source tape contains:
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#
#Results in one disk containing all programs
#Start the programs from disk and compare sizes.

echo ================ Executing testcase T64_2
del T64_2\*.d64
mkdir T64_2
TargetD64 $options -c T64_2 t64_2.t64

#################################################################
#Testcase T64_3
#
#The source tape contains:
#42164bytes2
#42165bytes
#42164bytes3
#42164bytes
#
#Results in two disks (due to disk overflow) containing
#-------------------
#42164bytes
#42164bytes2
#42164bytes3
#-------------------
#42165bytes
#-------------------
#Start the programs from disk and compare sizes.

echo ================ Executing testcase T64_3
del T64_3\*.d64
mkdir T64_3
TargetD64 $options -c T64_3 t64_3.t64

#################################################################
#Testcase T64_4
#
#The source tape contains:
#1!disk
#2!disk
#3!disk
#4!disk
#soccermania
#
#Results in two disks containing:
#-------------------
#soccermania          unresolvable program
#-------------------
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes            [1-4]!disk extracted
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#-------------------

echo ================ Executing testcase T64_4
del T64_4\*.d64
mkdir T64_4
TargetD64 $options -c T64_4 t64_4.t64

#################################################################
#Testcase T64_5
#
#The source tape contains:
#soccermania
#disk.lnx
#
#Results in two disks containing
#-------------------
#soccermania
#-------------------
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes            disk.lnx extracted
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#-------------------

echo ================ Executing testcase T64_5
del T64_5\*.d64
mkdir T64_5
TargetD64 $options -c T64_5 t64_5.t64

#################################################################
#Testcase T64_6
#
#The source tape is empty
#An error is indicated

echo ================ Executing testcase T64_6
del T64_6\*.d64
mkdir T64_6
TargetD64 $options -c T64_6 empty.t64

#################################################################
#Testcase T64_7
#
#The source tape contains two files
#first file has an empty filename second file uses 16 chars for
#filename
#
#This tests the removing of trailing blanks in filenames of T64

echo ================ Executing testcase T64_7
del T64_7\*.d64
mkdir T64_7
TargetD64 $options -c T64_7 filenames.t64

##################################################################
#Testseries "builtin LNX support"
##################################################################

#################################################################
#Testcase LNX_1
#
#The source archive contains:
#soccermania
#
#Results in one disk containing soccermania

echo ================ Executing testcase LNX_1
del LNX_1\*.d64
mkdir LNX_1
TargetD64 $options -c LNX_1 soccermania.lnx

#################################################################
#Testcase LNX_2
#
#The source archive contains:
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#
#Results in one disk containing all programs

echo ================ Executing testcase LNX_2
del LNX_2\*.d64
mkdir LNX_2
TargetD64 $options -c LNX_2 lnx_2.lnx

#################################################################
#Testcase LNX_3
#
#The source archive contains:
#soccermania
#disk.lnx
#
#Results in two disks containing
#-------------------
#soccermania
#-------------------
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes            disk.lnx extracted
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#-------------------

echo ================ Executing testcase LNX_3
del LNX_3\*.d64
mkdir LNX_3
TargetD64 $options -c LNX_3 lnx_3.lnx

#################################################################
#Testcase LNX_4
#
#The source archive contains:
#soccermania
#1!disk
#2!disk
#3!disk
#4!disk
#
#Results in two disks containing:
#-------------------
#soccermania
#1!disk               disk reflects source archive          
#2!disk               as an unresolvable program is on it
#3!disk               and initial conversion is done
#4!disk               source archive->d64 (keep the d64)
#-------------------
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes            [1-4]!disk extracted
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#-------------------

echo ================ Executing testcase LNX_4
del LNX_4\*.d64
mkdir LNX_4
TargetD64 $options -c LNX_4 lnx_4.lnx

#################################################################
#Testcase LNX_5
#
#The source archive contains:
#soccermania.lnx
#
#Results in one disk containing soccermania (via double unlynx)

echo ================ Executing testcase LNX_5
del LNX_5\*.d64
mkdir LNX_5
TargetD64 $options -c LNX_5 soccermania_doublelynx.lnx

##################################################################
#Testseries "builtin C64ZIP support"
##################################################################

#################################################################
#Testcase C64ZIP_1
#
#Only one part of the c64zip archive as command line parameter.
#
#Results in one disk containing
#-------------------
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes            [1-4]!disk extracted. Missing parts are
#8129bytes            automatically located
#42163bytes
#42164bytes
#42165bytes
#-------------------

echo ================ Executing testcase C64ZIP_1
del C64ZIP_1\*.d64
mkdir C64ZIP_1
TargetD64 $options -c C64ZIP_1 1\!disk

#################################################################
#Testcase C64ZIP_2
#
#All parts of the c64zip archive as command line parameter.
#
#Results in one disk containing
#-------------------
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes            [1-4]!disk extracted. Missing parts are
#8129bytes            automatically located
#42163bytes
#42164bytes
#42165bytes
#-------------------

echo ================ Executing testcase C64ZIP_2
del C64ZIP_2\*.d64
mkdir C64ZIP_2
TargetD64 $options -c C64ZIP_2 1\!disk 2\!disk 3\!disk 4\!disk

#################################################################
#Testcase C64ZIP_3
#
#Parts of the c64zip archive distributed in two lynx files.
#a.lnx contains:
#1!disk
#2!disk
#b.lnx contains:
#3!disk
#4!disk
#
#Results in one disk containing
#-------------------
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes            [1-4]!disk extracted. Parts are automatically 
#8129bytes            associated from different source archives
#42163bytes
#42164bytes
#42165bytes
#-------------------

echo ================ Executing testcase C64ZIP_3
del C64ZIP_3\*.d64
mkdir C64ZIP_3
TargetD64 $options -c C64ZIP_3 a.lnx b.lnx

#################################################################
#Testcase C64ZIP_4
#
#Double c64zipped archive.
#[1-4]!double_zipped contains:
#1!disk
#2!disk
#3!disk
#4!disk
#
#Results in one disk containing
#-------------------
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes            [1-4]!disk extracted 
#8129bytes           
#42163bytes
#42164bytes
#42165bytes
#-------------------

echo ================ Executing testcase C64ZIP_4
del C64ZIP_4\*.d64
mkdir C64ZIP_4
TargetD64 $options -c C64ZIP_4 1\!double_zipped

#################################################################
#Testcase C64ZIP_5
#
#Missing c64zip archive (processing terminates)
#misssing_c64zip.zip contains:
#1!disk
#2!disk
#3!disk (BUT NOT 4!disk)
#
#Results in error termination of processing

echo ================ Executing testcase C64ZIP_5
del C64ZIP_5\*.d64
mkdir C64ZIP_5
TargetD64 $options -c C64ZIP_5 missing_c64zip.zip

##################################################################
#Testseries "builtin PC64 file support"
##################################################################

#################################################################
#Testcase PC64_1
#
#Pass mixture of PC64 archives, unresolvable archives to TD64
#PC64 archives and unresolvable archives are put into the same D64 image
#TD64 treats PC64 archives as a special form of unresolvable archives
#so no isolated D64 images are created
#soccermania.p00 contains soccermania.lnx which leads to a new D64 image
#
#Results in two disks containing
#-------------------------------
#254BYTES   PRG
#254BYTES   DEL<
#254BYTES   SEQ
#254BYTES   USR
#255BYTES   PRG
#8128BYTES  PRG
#-------------------------------
#soccermania
#-------------------------------

echo ================ Executing testcase PC64_1
del PC64_1\*.d64
mkdir PC64_1
TargetD64 $options -c PC64_1 254bytes.p00 254bytes.d00 soccermania.p00 254bytes.s00 254bytes.u00 255bytes.p00 8128bytes

##################################################################
#Testseries "builtin ZIP support"
##################################################################

#################################################################
#Testcase ZIP_1
#
#Zip archive contains program with dirpath component:
#soccermania/soccermania.t64
#
#Results in one disk containing
#soccermania         dirpath ignored

echo ================ Executing testcase ZIP_1
del ZIP_1\*.d64
mkdir ZIP_1
TargetD64 $options -c ZIP_1 path.zip

#################################################################
#Testcase ZIP_2
#
#Zip archive contains all incoming files of testcase D64_1.
#
#Results are exactly the same than for D64_1

echo ================ Executing testcase ZIP_2 - compare D64_1
del ZIP_2\*.d64
mkdir ZIP_2
TargetD64 $options -c ZIP_2 zip_2.zip

#################################################################
#Testcase ZIP_3

echo ================ Executing testcase ZIP_3 - compare D64_2
del ZIP_3\*.d64
mkdir ZIP_3
TargetD64 $options -c ZIP_3 zip_3.zip

#################################################################
#Testcase ZIP_4

echo ================ Executing testcase ZIP_4 - compare D64_3
del ZIP_4\*.d64
mkdir ZIP_4
TargetD64 $options -c ZIP_4 zip_4.zip

#################################################################
#Testcase ZIP_5

echo ================ Executing testcase ZIP_5 - compare D64_4
del ZIP_5\*.d64
mkdir ZIP_5
TargetD64 $options -c ZIP_5 zip_5.zip

#################################################################
#Testcase ZIP_6

echo ================ Executing testcase ZIP_6 - compare D64_5
del ZIP_6\*.d64
mkdir ZIP_6
TargetD64 $options -c ZIP_6 zip_6.zip

#################################################################
#Testcase ZIP_7

echo ================ Executing testcase ZIP_7 - compare D64_6
del ZIP_7\*.d64
mkdir ZIP_7
TargetD64 $options -c ZIP_7 zip_7.zip

#################################################################
#Testcase ZIP_8

echo ================ Executing testcase ZIP_8 - compare D64_7
del ZIP_8\*.d64
mkdir ZIP_8
TargetD64 $options -c ZIP_8 zip_8.zip

#################################################################
#Testcase ZIP_9

echo ================ Executing testcase ZIP_9 - compare D64_8
del ZIP_9\*.d64
mkdir ZIP_9
TargetD64 $options -c ZIP_9 zip_9.zip

#################################################################
#Testcase ZIP_10

echo ================ Executing testcase ZIP_10 - compare T64_1
del ZIP_10\*.d64
mkdir ZIP_10
TargetD64 $options -c ZIP_10 zip_10.zip

#################################################################
#Testcase ZIP_11

echo ================ Executing testcase ZIP_11 - compare T64_2
del ZIP_11\*.d64
mkdir ZIP_11
TargetD64 $options -c ZIP_11 zip_11.zip

#################################################################
#Testcase ZIP_12

echo ================ Executing testcase ZIP_12 - compare T64_3
del ZIP_12\*.d64
mkdir ZIP_12
TargetD64 $options -c ZIP_12 zip_12.zip

#################################################################
#Testcase ZIP_13

echo ================ Executing testcase ZIP_13 - compare T64_4
del ZIP_13\*.d64
mkdir ZIP_13
TargetD64 $options -c ZIP_13 zip_13.zip

#################################################################
#Testcase ZIP_14

echo ================ Executing testcase ZIP_14 - compare T64_5
del ZIP_14\*.d64
mkdir ZIP_14
TargetD64 $options -c ZIP_14 zip_14.zip

#################################################################
#Testcase ZIP_15

echo ================ Executing testcase ZIP_15 - compare LNX_1
del ZIP_15\*.d64
mkdir ZIP_15
TargetD64 $options -c ZIP_15 zip_15.zip

#################################################################
#Testcase ZIP_16

echo ================ Executing testcase ZIP_16 - compare LNX_2
del ZIP_16\*.d64
mkdir ZIP_16
TargetD64 $options -c ZIP_16 zip_16.zip

#################################################################
#Testcase ZIP_17

echo ================ Executing testcase ZIP_17 - compare LNX_3
del ZIP_17\*.d64
mkdir ZIP_17
TargetD64 $options -c ZIP_17 zip_17.zip

#################################################################
#Testcase ZIP_18

echo ================ Executing testcase ZIP_18 - compare LNX_4
del ZIP_18\*.d64
mkdir ZIP_18
TargetD64 $options -c ZIP_18 zip_18.zip

#################################################################
#Testcase ZIP_19

echo ================ Executing testcase ZIP_19 - compare LNX_5
del ZIP_19\*.d64
mkdir ZIP_19
TargetD64 $options -c ZIP_19 zip_19.zip

#################################################################
#Testcase ZIP_20

echo ================ Executing testcase ZIP_20 - compare C64ZIP_1
del ZIP_20\*.d64
mkdir ZIP_20
TargetD64 $options -c ZIP_20 zip_20.zip

#################################################################
#Testcase ZIP_21

echo ================ Executing testcase ZIP_21 - compare C64ZIP_3
del ZIP_21\*.d64
mkdir ZIP_21
TargetD64 $options -c ZIP_21 zip_21.zip

#################################################################
#Testcase ZIP_22

echo ================ Executing testcase ZIP_22 - compare C64ZIP_4
del ZIP_22\*.d64
mkdir ZIP_22
TargetD64 $options -c ZIP_22 zip_22.zip

##################################################################
#Testseries "builtin LHA support"
##################################################################

#################################################################
#Testcase LHA_1
#
#Zip archive contains program with dirpath component:
#soccermania/soccermania.t64
#
#Results in one disk containing
#soccermania         dirpath ignored

echo ================ Executing testcase LHA_1
del LHA_1\*.d64
mkdir LHA_1
TargetD64 $options -c LHA_1 path.lha

#################################################################
#Testcase LHA_2
#
#Zip archive contains all incoming files of testcase D64_1.
#
#Results are exactly the same than for D64_1

echo ================ Executing testcase LHA_2 - compare D64_1
del LHA_2\*.d64
mkdir LHA_2
TargetD64 $options -c LHA_2 lha_2.lha

#################################################################
#Testcase LHA_3

echo ================ Executing testcase LHA_3 - compare D64_2
del LHA_3\*.d64
mkdir LHA_3
TargetD64 $options -c LHA_3 lha_3.lha

#################################################################
#Testcase LHA_4

echo ================ Executing testcase LHA_4 - compare D64_3
del LHA_4\*.d64
mkdir LHA_4
TargetD64 $options -c LHA_4 lha_4.lha

#################################################################
#Testcase LHA_5

echo ================ Executing testcase LHA_5 - compare D64_4
del LHA_5\*.d64
mkdir LHA_5
TargetD64 $options -c LHA_5 lha_5.lha

#################################################################
#Testcase LHA_6

echo ================ Executing testcase LHA_6 - compare D64_5
del LHA_6\*.d64
mkdir LHA_6
TargetD64 $options -c LHA_6 lha_6.lha

#################################################################
#Testcase LHA_7

echo ================ Executing testcase LHA_7 - compare D64_6
del LHA_7\*.d64
mkdir LHA_7
TargetD64 $options -c LHA_7 lha_7.lha

#################################################################
#Testcase LHA_8

echo ================ Executing testcase LHA_8 - compare D64_7
del LHA_8\*.d64
mkdir LHA_8
TargetD64 $options -c LHA_8 lha_8.lha

#################################################################
#Testcase LHA_9

echo ================ Executing testcase LHA_9 - compare D64_8
del LHA_9\*.d64
mkdir LHA_9
TargetD64 $options -c LHA_9 lha_9.lha

#################################################################
#Testcase LHA_10

echo ================ Executing testcase LHA_10 - compare T64_1
del LHA_10\*.d64
mkdir LHA_10
TargetD64 $options -c LHA_10 lha_10.lha

#################################################################
#Testcase LHA_11

echo ================ Executing testcase LHA_11 - compare T64_2
del LHA_11\*.d64
mkdir LHA_11
TargetD64 $options -c LHA_11 lha_11.lha

#################################################################
#Testcase LHA_12

echo ================ Executing testcase LHA_12 - compare T64_3
del LHA_12\*.d64
mkdir LHA_12
TargetD64 $options -c LHA_12 lha_12.lha

#################################################################
#Testcase LHA_13

echo ================ Executing testcase LHA_13 - compare T64_4
del LHA_13\*.d64
mkdir LHA_13
TargetD64 $options -c LHA_13 lha_13.lha

#################################################################
#Testcase LHA_14

echo ================ Executing testcase LHA_14 - compare T64_5
del LHA_14\*.d64
mkdir LHA_14
TargetD64 $options -c LHA_14 lha_14.lha

#################################################################
#Testcase LHA_15

echo ================ Executing testcase LHA_15 - compare LNX_1
del LHA_15\*.d64
mkdir LHA_15
TargetD64 $options -c LHA_15 lha_15.lha

#################################################################
#Testcase LHA_16

echo ================ Executing testcase LHA_16 - compare LNX_2
del LHA_16\*.d64
mkdir LHA_16
TargetD64 $options -c LHA_16 lha_16.lha

#################################################################
#Testcase LHA_17

echo ================ Executing testcase LHA_17 - compare LNX_3
del LHA_17\*.d64
mkdir LHA_17
TargetD64 $options -c LHA_17 lha_17.lha

#################################################################
#Testcase LHA_18

echo ================ Executing testcase LHA_18 - compare LNX_4
del LHA_18\*.d64
mkdir LHA_18
TargetD64 $options -c LHA_18 lha_18.lha

#################################################################
#Testcase LHA_19

echo ================ Executing testcase LHA_19 - compare LNX_5
del LHA_19\*.d64
mkdir LHA_19
TargetD64 $options -c LHA_19 lha_19.lha

#################################################################
#Testcase LHA_20

echo ================ Executing testcase LHA_20 - compare C64ZIP_1
del LHA_20\*.d64
mkdir LHA_20
TargetD64 $options -c LHA_20 lha_20.lha

#################################################################
#Testcase LHA_21

echo ================ Executing testcase LHA_21 - compare C64ZIP_3
del LHA_21\*.d64
mkdir LHA_21
TargetD64 $options -c LHA_21 lha_21.lha

#################################################################
#Testcase LHA_22

echo ================ Executing testcase LHA_22 - compare C64ZIP_4
del LHA_22\*.d64
mkdir LHA_22
TargetD64 $options -c LHA_22 lha_22.lha

##################################################################
#Testseries "builtin GZ support"
##################################################################

#################################################################
#Testcase GZ_1
#
#Gnuzip archive contains incoming file of testcase D64_5.
#
#Results are exactly the same than for D64_5

echo ================ Executing testcase GZ_1 - compare D64_5
del GZ_1\*.d64
mkdir GZ_1
TargetD64 $options -c GZ_1 d64_5.d64.gz

#################################################################
#Testcase GZ_2

echo ================ Executing testcase GZ_2 - compare D64_6
del GZ_2\*.d64
mkdir GZ_2
TargetD64 $options -c GZ_2 d64_6.d64.gz

#################################################################
#Testcase GZ_3

echo ================ Executing testcase GZ_3 - compare D64_7
del GZ_3\*.d64
mkdir GZ_3
TargetD64 $options -c GZ_3 d64_7.d64.gz

#################################################################
#Testcase GZ_4

echo ================ Executing testcase GZ_4 - compare D64_8
del GZ_4\*.d64
mkdir GZ_4
TargetD64 $options -c GZ_4 d64_8.d64.gz

#################################################################
#Testcase GZ_5

echo ================ Executing testcase GZ_5 - compare T64_1
del GZ_5\*.d64
mkdir GZ_5
TargetD64 $options -c GZ_5 soccermania.t64.gz

#################################################################
#Testcase GZ_6

echo ================ Executing testcase GZ_6 - compare T64_2
del GZ_6\*.d64
mkdir GZ_6
TargetD64 $options -c GZ_6 t64_2.t64.gz

#################################################################
#Testcase GZ_7

echo ================ Executing testcase GZ_7 - compare T64_3
del GZ_7\*.d64
mkdir GZ_7
TargetD64 $options -c GZ_7 t64_3.t64.gz

#################################################################
#Testcase GZ_8

echo ================ Executing testcase GZ_8 - compare T64_4
del GZ_8\*.d64
mkdir GZ_8
TargetD64 $options -c GZ_8 t64_4.t64.gz

#################################################################
#Testcase GZ_9

echo ================ Executing testcase GZ_9 - compare T64_5
del GZ_9\*.d64
mkdir GZ_9
TargetD64 $options -c GZ_9 t64_5.t64.gz

#################################################################
#Testcase GZ_10

echo ================ Executing testcase GZ_10 - compare LNX_1
del GZ_10\*.d64
mkdir GZ_10
TargetD64 $options -c GZ_10 soccermania.lnx.gz

#################################################################
#Testcase GZ_11

echo ================ Executing testcase GZ_11 - compare LNX_2
del GZ_11\*.d64
mkdir GZ_11
TargetD64 $options -c GZ_11 lnx_2.lnx.gz

#################################################################
#Testcase GZ_12

echo ================ Executing testcase GZ_12 - compare LNX_3
del GZ_12\*.d64
mkdir GZ_12
TargetD64 $options -c GZ_12 lnx_3.lnx.gz

#################################################################
#Testcase GZ_13

echo ================ Executing testcase GZ_13 - compare LNX_4
del GZ_13\*.d64
mkdir GZ_13
TargetD64 $options -c GZ_13 lnx_4.lnx.gz

#################################################################
#Testcase GZ_14

echo ================ Executing testcase GZ_14 - compare LNX_5
del GZ_14\*.d64
mkdir GZ_14
TargetD64 $options -c GZ_14 soccermania_doublelynx.lnx.gz

#The following sections will be commented out in the windows batchfile
#start no win

##################################################################
#Testseries usage of external helpers instead of builtins
#Use of generic archive interface for builtin replacement
##################################################################

#################################################################
#Testcase EXH_1
#Lynx archive contains:
#soccermania
#1!disk
#2!disk
#3!disk
#4!disk
#
#Results in two disks containing:
#-------------------
#soccermania
#1!disk               disk reflects source archive          
#2!disk               as an unresolvable program is on it
#3!disk               and initial conversion is done
#4!disk               source archive->d64 (keep the d64)
#-------------------
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes            [1-4]!disk extracted
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#-------------------

export TD64_GENERIC_CMD1='cd '%s1' && c1541 -format 'target,64' d64 '%s3.d64' -unlynx '%s2''
export TD64_GENERIC_EXT1='.lnx'
export TD64_GENERIC_CMD2='lha -eifw='%s1' '%s2''
export TD64_GENERIC_EXT2='.lha'
export TD64_GENERIC_CMD3='unzip -j '%s2' -d '%s1''
export TD64_GENERIC_EXT3='.zip'
export TD64_GENERIC_CMD4='cp '%s2' '%s1' && gunzip '%s1'/`basename '%s2'`'
export TD64_GENERIC_EXT4='.gz'

echo ================ Executing testcase EXH_1
del EXH_1\*.d64
mkdir EXH_1
TargetD64 $options -c EXH_1 lnx_4.lnx

unset TD64_GENERIC_EXT1
unset TD64_GENERIC_EXT2
unset TD64_GENERIC_EXT3
unset TD64_GENERIC_EXT4
unset TD64_GENERIC_CMD1
unset TD64_GENERIC_CMD2
unset TD64_GENERIC_CMD3
unset TD64_GENERIC_CMD4

#################################################################
#Testcase EXH_2
#Zip archive contains soccermania.lnx contains:
#soccermania
#
#Results in one disk containing soccermania

export TD64_GENERIC_CMD1='cd '%s1' && c1541 -format 'target,64' d64 '%s3.d64' -unlynx '%s2''
export TD64_GENERIC_EXT1='.lnx'
export TD64_GENERIC_CMD2='lha -eifw='%s1' '%s2''
export TD64_GENERIC_EXT2='.lha'
export TD64_GENERIC_CMD3='unzip -j '%s2' -d '%s1''
export TD64_GENERIC_EXT3='.zip'
export TD64_GENERIC_CMD4='cp '%s2' '%s1' && gunzip '%s1'/`basename '%s2'`'
export TD64_GENERIC_EXT4='.gz'

echo ================ Executing testcase EXH_2
del EXH_2\*.d64
mkdir EXH_2
TargetD64 $options -c EXH_2 zip_15.zip

unset TD64_GENERIC_EXT1
unset TD64_GENERIC_EXT2
unset TD64_GENERIC_EXT3
unset TD64_GENERIC_EXT4
unset TD64_GENERIC_CMD1
unset TD64_GENERIC_CMD2
unset TD64_GENERIC_CMD3
unset TD64_GENERIC_CMD4

#################################################################
#Testcase EXH_3
#Lha archive contains tape image
#which contains:
#1!disk
#2!disk
#3!disk
#4!disk
#soccermania
#
#Results in two disks containing:
#-------------------
#soccermania          unresolvable program
#-------------------
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes            [1-4]!disk extracted
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#-------------------

export TD64_GENERIC_CMD1='cd '%s1' && c1541 -format 'target,64' d64 '%s3.d64' -unlynx '%s2''
export TD64_GENERIC_EXT1='.lnx'
export TD64_GENERIC_CMD2='lha -eifw='%s1' '%s2''
export TD64_GENERIC_EXT2='.lha'
export TD64_GENERIC_CMD3='unzip -j '%s2' -d '%s1''
export TD64_GENERIC_EXT3='.zip'
export TD64_GENERIC_CMD4='cp '%s2' '%s1' && gunzip '%s1'/`basename '%s2'`'
export TD64_GENERIC_EXT4='.gz'

echo ================ Executing testcase EXH_3
del EXH_3\*.d64
mkdir EXH_3
TargetD64 $options -c EXH_3 lha_13.lha

unset TD64_GENERIC_EXT1
unset TD64_GENERIC_EXT2
unset TD64_GENERIC_EXT3
unset TD64_GENERIC_EXT4
unset TD64_GENERIC_CMD1
unset TD64_GENERIC_CMD2
unset TD64_GENERIC_CMD3
unset TD64_GENERIC_CMD4

#################################################################
#Testcase EXH_4
#Gzip archive contains disk image
#which contains:
#1!disk
#2!disk
#3!disk
#4!disk
#soccermania
#
#Results in two disks containing:
#-------------------
#253bytes
#254bytes
#255bytes
#8127bytes
#8128bytes            [1-4]!disk extracted
#8129bytes
#42163bytes
#42164bytes
#42165bytes
#-------------------
#1!disk               source disk is kept as there is soccermania          
#2!disk               as an unresolvable program on it
#3!disk
#4!disk
#soccermania
#-------------------

export TD64_GENERIC_CMD1='cd '%s1' && c1541 -format 'target,64' d64 '%s3.d64' -unlynx '%s2''
export TD64_GENERIC_EXT1='.lnx'
export TD64_GENERIC_CMD2='lha -eifw='%s1' '%s2''
export TD64_GENERIC_EXT2='.lha'
export TD64_GENERIC_CMD3='unzip -j '%s2' -d '%s1''
export TD64_GENERIC_EXT3='.zip'
export TD64_GENERIC_CMD4='cp '%s2' '%s1' && gunzip '%s1'/`basename '%s2'`'
export TD64_GENERIC_EXT4='.gz'

echo ================ Executing testcase EXH_4
del EXH_4\*.d64
mkdir EXH_4
TargetD64 $options -c EXH_4 d64_6.d64.gz

unset TD64_GENERIC_EXT1
unset TD64_GENERIC_EXT2
unset TD64_GENERIC_EXT3
unset TD64_GENERIC_EXT4
unset TD64_GENERIC_CMD1
unset TD64_GENERIC_CMD2
unset TD64_GENERIC_CMD3
unset TD64_GENERIC_CMD4

#################################################################
#Testcase EXH_5
#Use cbmconvert to extract native C64 files from lnx

export TD64_GENERIC_CMD1="cd '%s1' && cbmconvert -N -l '%s2'"
export TD64_GENERIC_EXT1=".lnx"

echo ================ Executing testcase EXH_5
del EXH_5\*.d64
mkdir EXH_5
TargetD64 $options -c EXH_5 soccermania.lnx

unset TD64_GENERIC_EXT1
unset TD64_GENERIC_CMD1

#################################################################
#Testcase EXH_6
#Use cbmconvert to extract D64 image from lnx

export TD64_GENERIC_CMD1="cd '%s1' && cbmconvert -D4 '%s3.d64' -l '%s2'"
export TD64_GENERIC_EXT1=".lnx"

echo ================ Executing testcase EXH_6
del EXH_6\*.d64
mkdir EXH_6
TargetD64 $options -c EXH_6 soccermania.lnx

unset TD64_GENERIC_EXT1
unset TD64_GENERIC_CMD1

##################################################################
#Testseries "generic archives"
##################################################################

#################################################################
#Testcase GEN_1
#Setup a generic archive for .tar and .Z files          
#tar_1.tar contains:
#unresolvable files used in D64_1 and
#soccermania.lnx

echo ================ Executing testcase GEN_1
export TD64_GENERIC_CMD1="tar -C '%s1' -xf '%s2'"
export TD64_GENERIC_EXT1=".tar"
export TD64_GENERIC_CMD2="cp '%s2' '%s1' && uncompress '%s1'/\`basename '%s2'\`"
export TD64_GENERIC_EXT2=".Z"
del GEN_1\*.d64
mkdir GEN_1
TargetD64 $options -c GEN_1 tar_1.tar soccermania.p00.Z 
unset TD64_GENERIC_CMD1
unset TD64_GENERIC_EXT1
unset TD64_GENERIC_CMD2
unset TD64_GENERIC_EXT2

#################################################################
#Testcase GEN_2
#Setup a generic archive for .tar files          
#tar_1.tar.gz is gnuzipped tar_1.tar from GEN_1

echo ================ Executing testcase GEN_2
export TD64_GENERIC_CMD1="tar -C '%s1' -xf '%s2'"
export TD64_GENERIC_EXT1=".tar"
del GEN_2\*.d64
mkdir GEN_2
TargetD64 $options -c GEN_2 tar_1.tar.gz 
unset TD64_GENERIC_CMD1
unset TD64_GENERIC_EXT1

#################################################################
#Testcase GEN_3
#Use -k as default options (TD64_DEFAULT_OPTIONS)          

echo ================ Executing testcase GEN_3
export TD64_DEFAULT_OPTIONS="-k"
del GEN_3\*.d64
mkdir GEN_3
TargetD64 $options -c GEN_3 soccermania.lnx 
unset TD64_DEFAULT_OPTIONS

#end no win

##################################################################
#Testseries "exception handling"
##################################################################

#################################################################
#Testcase EXC_1
#An empty archive is passed to TD64 - no emulator image created

echo ================ Executing testcase EXC_1
del EXC_1\*.d64
mkdir EXC_1
TargetD64 $options -c EXC_1 exc_1.zip

#################################################################
#Testcase EXC_2
#An directory is passed to TD64 - no emulator image created

echo ================ Executing testcase EXC_2
del EXC_2\*.d64
mkdir EXC_2
TargetD64 $options -c EXC_2 EXC_2

#################################################################
#Testcase EXC_3
#An directory and an empty archive are passed to TD64
#- no emulator image created

echo ================ Executing testcase EXC_3
del EXC_3\*.d64
mkdir EXC_3
TargetD64 $options -c EXC_3 EXC_3 exc_1.zip

#################################################################
#Testcase EXC_4
#An non existing file is passed to TD64
#- no emulator image created

echo ================ Executing testcase EXC_4
del EXC_4\*.d64
mkdir EXC_4
TargetD64 $options -c EXC_4 blabla


#################################################################
#Testcase EXC_5
#A directory, a non existing file and soccermania.lnx are passed to TD64
#The emulator image for soccermania.lnx has to be created. Others produce
#exception messages.

echo ================ Executing testcase EXC_5
del EXC_5\*.d64
mkdir EXC_5
TargetD64 $options -c EXC_5 EXC_5 blabla soccermania.lnx


#################################################################
#Testcase EXC_6
#A zero byte length archive is passed to TD64

echo ================ Executing testcase EXC_6
del EXC_6\*.d64
mkdir EXC_6
TargetD64 $options -c EXC_6 0bytes
