//////////////////////////////////////////////////////////////////////
//TargetD64 - C64 archive related conversion tool and emulator frontend
//////////////////////////////////////////////////////////////////////
//Copyright (C) 1998, 1999  Karlheinz Langguth klangguth@netscape.net
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
//COMPILE SWITCHES
// _MSC_VER
// indicates MS compiler
// _DEBUG
// for debug version which activates ASSERT and TRACE

#ifdef _MSC_VER
#pragma warning(disable:4786) //identifier truncation warning
#endif

#include <iostream>
#include <string>
#include <vector>
#include <map>

using namespace std;

#include "Tracing.h"
#include "Options.h"

CFOptions* CFOptions::s_pAppOptions = NULL;

bool CFOptions::RegisterCallback(tCallbackEnum t, tHandler p)
{
	bool ret = true;
	switch (t)
	{
	case CB_UNKNOWN_OPTION:
		m_pUnknownOptionCallback = p;
		break;
	default:
		ret = false;
	}
	return ret;
}


bool CFOptions::RegisterOption(const string& opt, bool bArg, tHandler p /*= NULL*/)
{
	pair<tRegisteredOption::iterator, bool> res =
		m_registeredOptions.insert(make_pair(opt, CFRegisteredOption(bArg, p)));
	//check for insertion success
	if (res.second)
		return true;
	else
		return false;
}


void CFOptions::ParseCommandLine(int argc, char *argv[])
{
	TRBEGIN("CFOptions::ParseCommandLine");

	bool moreOptions = true; //after -- no more options possible

	int i = 1;
	while (i < argc)
	{
		//check if we have an option
		string test = argv[i];
		if ((test[0] == '-') && moreOptions)
		{
			if (test == "--")
			{
				//-- means no more options to follow
				moreOptions = false;
			}
			else
			{
				//take care of options concatenated like -xy for -x -y
				for (string::size_type nChIdx = 1; nChIdx < test.size(); nChIdx++)
				{
					//search for option in registered database
					tRegisteredOption::const_iterator j = m_registeredOptions.find(string("") + test[nChIdx]);
					if (j != m_registeredOptions.end())
					{
						//found - now check for following argument
						if (j->second.m_bArgumentFollows)
						{
							string arg = test.substr(nChIdx + 1, test.size() - nChIdx - 1);
							//if argument is not directly appended
							if (arg.size() == 0)
							{
								//take next parameter from command line as argument
								arg = argv[++i];
							}
							//call handler with option argument
							HandleKnownOption(j, arg);
							break; //no option to follow appended to argument
						}
						else
						{
							//no argument, call handler
							HandleKnownOption(j, string(""));
						}
					}
					else
					{
						HandleUnknownOption(test);
						break; //no further option after error happened
					}
				} //ENDFOR
				if (test == "-")
				{
					//this error will not be handled by the FOR loop
					HandleUnknownOption(test);
				}
			}
		}
		else
		{
			//we have no option so call the std. argument handler
			//search for standard arg in registered database
			tRegisteredOption::const_iterator j = m_registeredOptions.find(OP_STD_ARG);
			if (j != m_registeredOptions.end())
			{
				HandleKnownOption(j, test);
			}
			else
			{
				//if std arguments are not registered give error
				HandleUnknownOption(test);
			}
		}
		//check next parameter from command line
		i++;
	}			
	TRreturn;
}


void CFOptions::HandleUnknownOption(const string& opt) const
{
	TRBEGIN("CFOptions::HandleUnknownOption");
	//if we have a callback function registered call it;
	if (m_pUnknownOptionCallback != NULL)
	{
		(*m_pUnknownOptionCallback)(opt);
	}
	else
	{
		cerr << "Unknown option ignored: " << opt <<endl;
	}
	TRreturn;
}


void CFOptions::HandleKnownOption(const tRegisteredOption::const_iterator& i
								  , const string& arg)
{
	TRBEGIN("CFOptions::HandleKnownOption");
	TRACE(<< "OptionPair: " << i->first << "," << arg);
	ASSERT(i != m_registeredOptions.end());
	//in any case store option found into database
	(void)m_parsedOptions.insert(make_pair(i->first, arg));
	//if we have a callback function registered, call it
	if (i->second.m_pHandlerFct != NULL)
	{
		TRACE(<< "Calling registered option handler");
		(*(i->second.m_pHandlerFct))(arg);
	}
	TRreturn;
}


bool CFOptions::QueryOption(const string& opt, vector<string>& args) const
{
	args.resize(0);
	pair<tParsedOption::const_iterator, tParsedOption::const_iterator> interval;
	//search for section
	interval = m_parsedOptions.equal_range(opt);
	//search for entry
	for (tParsedOption::const_iterator i = interval.first; i != interval.second; ++i)
	{
		args.push_back(i->second);
	}
	if (args.empty())
		return false;
	else
		return true;
}


bool CFOptions::QueryOption(const string& opt, string& arg) const
{
	vector<string> args;
	if (QueryOption(opt, args))
	{
		ASSERT(!args.empty());
		//last occurrence taken
		arg = args.back();
		return true;
	}
	return false;
}
