//////////////////////////////////////////////////////////////////////
//TargetD64 - C64 archive related conversion tool and emulator frontend
//////////////////////////////////////////////////////////////////////
//Copyright (C) 1998, 1999  Karlheinz Langguth klangguth@netscape.net
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//////////////////////////////////////////////////////////////////////

#ifndef _LYNX_IMAGE_HEADER
#define _LYNX_IMAGE_HEADER

class CFLynxImage
{
public:
	//attach a lynx image from filesystem
	//P1 I: filename of the lynx image
	inline void Attach(const string& filename)
		{ m_filename = filename; }
	//extract all files (except unextractable like REL) on image into
	//directory P1
	//map the CBM filenames to host filenames and resolve collisions
	//by building unique filenames
	//keep track of all extracted files in m_extractedFiles
	//P1 I: directory to extract to
	void ExtractAllFiles(const string& extractDir) throw (CFException);
	//R: host filename of lynx image
	const string& GetFilename(void) const { return m_filename; }
	//function is called from foreign source when file from lynx
	//archive is ready to be extracted
	//puts the file into filesystem and appends it to extracted files
	//vector
	//P1 I: cbm filename of the archive
	//P2 I: filetype of the file in 1541 notation (0x82 for closed PRG)
	//P3 I: number of bytes to read from lynx archive
	//P4 I: stream to read from (already positioned)
	void FlushFileIntoFilesystem(const char cname[], const unsigned char ftype
		, const unsigned int cnt, FILE *stream) throw (CFException);
	//R: vector with info about extracted files (needed for transfer into D64)
	inline const vector<CFExtractedFileInfo>& GetVectorOfExtractedFiles(void) const
		{ return m_extractedFiles; }
private:
	//filename of this tape
	string m_filename;
	//Directory to extract files into (without trailing /)
	string m_workdir;
	//fileinfo of all extracted files of this disk
	vector<CFExtractedFileInfo> m_extractedFiles;
};

#endif

