//////////////////////////////////////////////////////////////////////
//TargetD64 - C64 archive related conversion tool and emulator frontend
//////////////////////////////////////////////////////////////////////
//Copyright (C) 1998, 1999  Karlheinz Langguth klangguth@netscape.net
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//////////////////////////////////////////////////////////////////////

//avoid multiple include of header file
#ifndef _APPLICATION_HEADER
#define _APPLICATION_HEADER

//concept of an application
//should be always used like that (example):
//class CFSpecialApplication : public CFApplication<CFSpecialApplication>
//it is necessary to pass CFSpecialApplication to the template to have
//access to the methods of CFSpecialApplication which can be callbacks
//for special options.
//- executes command line parsing
//Any option has a registered callback method which is called if
//option occurs. Callback methods are also called "handlers"
//P1: class of special application
class CFApplication
{

protected:
	//Registers standard option -h
	//P1 I: name of application (is used to determine profile name)
	//Parameters as used for main()
	CFApplication(const string& appName, int argc, char *argv[], char *envp[]);
	virtual ~CFApplication() {}

protected:
	//class is abstract
	//specialisation has to implement main() which should implement
	//application processing
	//command line has been parsed while construction
	virtual int main(void) const = 0;

protected:
	string m_appName; //used to build profile name

	int m_argc; //argc of main() function
	char **m_argv; //argv of main() function
	char **m_envp; //envp of main() function

	CFOptions m_opt;
	CFProfile m_profile;
};


inline CFApplication::CFApplication(const string& appName, int argc, char *argv[], char *envp[])
	: m_appName(appName)
	, m_argc(argc)
	, m_argv(argv)
	, m_envp(envp)
	, m_profile(appName)
{
	//make these objects application wide accessible as we are the application
	m_opt.SetAppOptions();
	m_profile.ParseProfile();
	m_profile.SetAppProfile();
}

#endif

