unit dddelphi;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, KillGDI;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


var
  Form1: TForm1;


implementation

{$R *.DFM}

type
  RGB=record r,g,b:byte;end;
  palette=array[0..255]of RGB;

var
  pal: palette;
  f: file;



procedure TForm1.FormCreate(Sender: TObject);
begin
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin

end;

procedure vgawait;
begin
  asm
    mov dx,3dah
  @l1:
    in al,dx
    test al,8
    jz @l1
  @l2:
    in al,dx
    test al,8
    jnz @l2
  end;
end;

procedure oport(p:word; d: byte);
begin
asm
  mov dx,p
  mov al,d
  out dx,al
end;
end;

function iport(p:word): byte;
begin
asm
  mov dx,p
  in al,dx
  mov result,al
end;
end;

procedure set320x400;
begin
  oport($3c4,4);
  oport($3c5,(iport($3c5) and not 8) or 4);
  oport($3ce,5);
  oport($3cf,iport($3cf) and not 16);
  oport($3ce,6);
  oport($3cf,iport($3cf) and not 2);
  oport($3c4,2);
  oport($3c5,$0f);
  fillchar(ptr($A0000)^,64000,0);
  oport($3d4,9);
  oport($3d5,iport($3d5) and not $1f);
  oport($3d4,$14);
  oport($3d5,iport($3d5) and not $40);
  oport($3d4,$17);
  oport($3d5,iport($3d5) or $40);
end;

procedure putpalette(start,done:byte;var pal:palette);
var c1:byte;
begin
  oport($03C8,start);
  for c1:=start to done do
  with pal[c1] do
  begin
  oport($03C9,R);
  oport($03C9,G);
  oport($03C9,B);
  end;
end;

procedure setplane(p: byte);
begin
  oport($3c4,2);
  oport($3c5,p);
end;

procedure put_box(i: longint); assembler;
asm
  pushad
  cld
  mov esi,i
  mov edx,40
  mov eax,93939393h
@l1:
  mov edi,esi
  mov ecx,10
  rep stosw
  add esi,320
  dec edx
  jnz @l1
  popad
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  i: longint;
  vpage: pointer;
  starttime,endtime: longint;
  framerate: extended;
  w0: hwnd;
  r: trect;
  count:integer;
begin

  EnableDD32;

  initdispdib;

  assignfile(f,'adrop.pal');
  reset(f,1);
  blockread(f,pal,768);
  closefile(f);
  putpalette(0,255,pal);

  getmem(vpage,64000);
  i:=0;
  count:=0;
  repeat
    vgawait;
    fillchar(ptr($A0000)^,64000,0);
    put_box(i+$A0000);
    inc(i);
    if i>=48000 then i:=0;
    inc(count);
  until count=640;


  donedispdib;

  DisableDD32;
end;

end.
