
;ͻ;
; XIDS - Xi Development System.                                             ;
; Copyright (c) 1995-1997 by Maxwell Sayles.  All rights reserved.          ;
;ͼ;

;*****************************************************************************;

; conditional compilation defines

FILEIO          EQU             ; include file functions?
TEXTOUTPUT      EQU             ; include text output function?
EXCEPTIONS      EQU             ; include exception handlers?

;*****************************************************************************;

; segment prototype
Code32  SEGMENT PARA PUBLIC USE32 'FAR_DATA'
        ASSUME CS:Code32, DS:Code32, SS:Code32
Code32  ENDS

;*****************************************************************************;

; A few macros to make type casting easier
q EQU qword ptr
d EQU dword ptr
w EQU word ptr
b EQU byte ptr
o EQU offset
m EQU small
l EQU large
s EQU short

TRUE  EQU (1)
FALSE EQU (0)

;*****************************************************************************;

; fast equivalent of pushad/popad
pushall EQU push eax ecx edx ebx ebp esi edi
popall  EQU pop  edi esi ebp ebx edx ecx eax

;*****************************************************************************;

; Stack size
STACK_SIZE                EQU     (4000h)

; Disk buffer size
DISKBUFFER_SIZE           EQU     (8000h)

; Protected mode entry types
pm_ENTRY_RAWXMS           EQU     (0)
pm_ENTRY_DPMI             EQU     (1)

; Real Mode Interrupt call vector
rm_INTCALL_VECTOR         EQU     (19h)

; PIC Vector Mappings
PIC1_VECTOR               EQU     (08h)
PIC2_VECTOR               EQU     (70h)

;*****************************************************************************;

; Variables for use with mode switching
GLOBAL rm_Int       :BYTE
GLOBAL rm_DS        :WORD
GLOBAL rm_ES        :WORD

; Macro to call Real Mode interrupts
RInt MACRO Interrupt
  mov m rm_Int,Interrupt
  int rm_INTCALL_VECTOR
ENDM

;*****************************************************************************;

; Selector Values
GLOBAL Code32Sel    :WORD       ; Code Selector for Code32 SEGMENT
GLOBAL Data32Sel    :WORD       ; Data Selector for Code32 SEGMENT
GLOBAL Flat32Sel    :WORD       ; Data Selector with base of 00000000h

; Linear addresses
GLOBAL Code32addr   :DWORD      ; linear address of Code32 SEGMENT
GLOBAL PSPaddr      :DWORD      ; linear address of PSP SEGMENT
GLOBAL Envaddr      :DWORD      ; linear address of Environment SEGMENT

; Global Code32 procedures
GLOBAL Start32:NEAR             ; application entry point
GLOBAL Exit32:NEAR              ; routine to terminate application
GLOBAL ErrorExit32:NEAR         ; routine to terminate with error message

;*****************************************************************************;

GLOBAL HexTAB:BYTE              ; db '0123456789ABCDEF'
GLOBAL Ret_Proc:NEAR            ; a procedure that points to a ret instruction
GLOBAL pm_EntryType:BYTE        ; protected mode entry type
                                ;   pm_ENTRY_RAWXMS or pm_ENTRY_DPMI

;*****************************************************************************;

; Macro for a small delay
DELAY MACRO
  dw 0EBh,0EBh
ENDM

; Macro for code begin
CODEBEGIN MACRO
  Code32 SEGMENT
         ASSUME CS:Code32, DS:Code32, SS:Code32
ENDM

; Macro for code end
CODEEND MACRO
  Code32 ENDS
  END
ENDM

;*****************************************************************************;

;Ŀ;
; Converts relative offset in EDX into real mode address in rm_DS:dx        ;
;;
GLOBAL AddrEDXtoRM:NEAR


;*****************************************************************************;

IFDEF FILEIO

GLOBAL fHandle:DWORD              ; generic file handle

;Ŀ;
; Open a file for Read and Write                                            ;
; Entry: EDX - Offset of ASCIIZ filename                                    ;
; Exit : EAX - File handle                                                  ;
;;
GLOBAL FileOpen:NEAR

@FileOpen MACRO fHandle, fName
  mov edx,o fName
  call FileOpen
  mov fHandle,eax
ENDM

;Ŀ;
; Create a file and open for write                                          ;
; Entry: EDX - Offset of ASCIIZ filename                                    ;
; Exit : EAX - File handle                                                  ;
;;
GLOBAL FileCreate:NEAR

@FileCreate MACRO fHandle, fName
  mov edx,o fName
  call FileCreate
  mov fHandle,eax
ENDM

;Ŀ;
; Close a currently opened file                                             ;
; Entry: EBX - File handle                                                  ;
;;
GLOBAL FileClose:NEAR

@FileClose MACRO fHandle
  mov ebx,fHandle
  call FileClose
ENDM

;Ŀ;
; Return the size of a currently open file                                  ;
; Entry: EBX - File handle                                                  ;
; Exit : EAX - Size of file                                                 ;
;;
GLOBAL FileSize:NEAR

@FileSize MACRO fHandle,Size
  mov ebx,fHandle
  call FileSize
  mov Size,eax
ENDM

;Ŀ;
; Read a block from a file                                                  ;
; Entry: EDX - Offset of data buffer                                        ;
;        ECX - Size of buffer                                               ;
;        EBX - File handle                                                  ;
;;
GLOBAL FileRead:NEAR

@FileRead MACRO fHandle, p, bLength
  mov edx,p
  mov ecx,bLength
  mov ebx,fHandle
  call FileRead
ENDM

;Ŀ;
; Write a block to file                                                     ;
; Entry: EDX - Offset of data buffer                                        ;
;        ECX - Size of buffer                                               ;
;        EBX - File handle                                                  ;
;;
GLOBAL FileWrite:NEAR

@FileWrite MACRO fHandle, p, bLength
  mov edx,p
  mov ecx,bLength
  mov ebx,fHandle
  call FileWrite
ENDM

ENDIF

;*****************************************************************************;

;Ŀ;
; Allocate memory block                                                     ;
; Entry: EDX - Size of memory block                                         ;
; Exit : EAX - Pointer to memory block                                      ;
;;
GLOBAL Alloc:DWORD              ; pointer to procedure

@Alloc MACRO p, Size
  mov edx,size
  call Alloc
  mov p,eax
ENDM

;Ŀ;
; Release memory block                                                      ;
; Entry: EAX - Pointer to memory block                                      ;
;;
GLOBAL Release:DWORD            ; pointer to procedure

@Release MACRO p
  mov eax,p
  call Release
ENDM

;Ŀ;
; Amount of free memory available                                           ;
; Exit : EAX - The amount of free memory available                          ;
;;
GLOBAL MemAvail:DWORD           ; pointer to procedure

;*****************************************************************************;

;Ŀ;
; Get protected mode interrupt descriptor                                   ;
; Entry:  BL - Interrupt vector                                             ;
; Exit :  AX:EDX - Selector:offset of interrupt vector                      ;
;;
GLOBAL GetPMInt:DWORD           ; pointer to procedure


;Ŀ;
; Set protected mode interrupt descriptor                                   ;
; Entry:  BL - Interrupt Vector                                             ;
;         AX:EDX - Selector:offset of interrupt vector                      ;
;;
GLOBAL SetPMInt:DWORD           ; pointer to procedure


;*****************************************************************************;

;Ŀ;
; Print '$' Terminating String                                              ;
; Entry: DS:EDX - Offset of String                                          ;
;;
GLOBAL PrintString:NEAR

WriteLn MACRO txt
  LOCAL @@lab1,text1

  jmp @@lab1
  text1 db txt,0Dh,0Ah,24h
  @@lab1:
  push edx
  mov edx,o text1
  call PrintString
  pop edx
ENDM

Write MACRO txt
  LOCAL @@lab1,text1

  jmp @@lab1
  text1 db txt,24h
  @@lab1:
  push edx
  mov edx,o text1
  call PrintString
  pop edx
ENDM


;*****************************************************************************;


;Ŀ;
; Random                                                                    ;
; Entry: RandMod - Range                                                    ;
; Exit : RandMod - Random Number                                            ;
;;
GLOBAL RandSeed:DWORD
GLOBAL RandMod:WORD
GLOBAL Random:NEAR


;*****************************************************************************;

IFDEF TEXTOUTPUT

;Ŀ;
; Print a hex DWORD                                                         ;
; Entry: EAX - DWORD to print                                               ;
;;
GLOBAL PrintDWORDh:NEAR

WriteDWORDh MACRO num
  push eax
  mov eax,num
  call PrintDWORDh
  pop eax
ENDM


;Ŀ;
; Print a hex WORD                                                          ;
; Entry:  AX - WORD to print                                                ;
;;
GLOBAL PrintWORDh:NEAR

WriteWORDh MACRO num
  push eax
  mov ax,num
  call PrintWORDh
  pop eax
ENDM


;Ŀ;
; Print a hex BYTE                                                          ;
; Entry:  AL - BYTE to print                                                ;
;;
GLOBAL PrintBYTEh:NEAR

WriteBYTEh MACRO num
  push eax
  mov al,num
  call PrintBYTEh
  pop eax
ENDM


;Ŀ;
; Print a DWORD                                                             ;
; Entry: EAX - DWORD to print                                               ;
;;
GLOBAL PrintDWORD:NEAR

WriteDWORD MACRO num
  push eax
  mov eax,num
  call PrintDWORD
  pop eax
ENDM


;Ŀ;
; Print a WORD                                                              ;
; Entry:  AX - WORD to print                                                ;
;;
GLOBAL PrintWORD:NEAR

WriteWORD MACRO num
  push eax
  mov ax,num
  call PrintWORD
  pop eax
ENDM


;Ŀ;
; Print a BYTE                                                              ;
; Entry:  AL - BYTE to print                                                ;
;;
GLOBAL PrintBYTE:NEAR

WriteBYTE MACRO num
  push eax
  mov al,num
  call PrintBYTE
  pop eax
ENDM

ENDIF

