;ͻ;
; XIDS - Xi Development System.																						 ;
; Copyright (c) 1995-1997 by Maxwell Sayles.  All rights reserved. 				 ;
;ͼ;

	LOCALS
	.386p

INCLUDE xids.inc

;ͻ;
; Segment prototypes 																											 ;
;ͼ;

Kernel					SEGMENT PARA PUBLIC USE16 'KERNEL'
Kernel					ENDS

Code32					SEGMENT PARA PUBLIC USE32 'FAR_DATA'
								ASSUME CS:Code32, DS:Code32, SS:Code32
Code32					ENDS

IFDEF FILEIO
DiskBuffer			SEGMENT PARA PUBLIC USE16 'BSS'
DiskBuffer			ENDS
ENDIF

IDTSeg					SEGMENT PARA PUBLIC USE16 'BSS'
IDTSeg					ENDS

StackSeg				SEGMENT PARA PUBLIC STACK 'STACK'
StackSeg				ENDS



;ͻ;
; System initialization and functions																			 ;
;ͼ;

; RAW/XMS initialization and system function
INCLUDE rawxms.asm

; DPMI initialization and system functions
INCLUDE dpmi.asm

; heap manager
INCLUDE heap.asm

; file manager
IFDEF FILEIO
INCLUDE file.asm
ENDIF

; text output
IFDEF TEXTOUTPUT
INCLUDE text.asm
ENDIF

; exception handlers
IFDEF EXCEPTIONS
INCLUDE excp.asm
ENDIF


;ͻ;
; All code for initializing and entering Protected Mode										 ;
;ͼ;
Kernel	SEGMENT
				ASSUME CS:Kernel, DS:Code32

;Ŀ;
; ********** Program Entrance ********************************************  ;
;;
Entry16:
	cli 											; Disable interrupts
	cld 											; Clear direction flag

	; Set DS to Code32 segment
	mov ax,Code32
	mov ds,ax

	; Save PSP segment
	mov m PSPSeg,es

	; Resize PSP
	mov bx,StackSeg + ((STACK_SIZE+15)/16) + 1
	sub bx,m PSPSeg
	mov ah,4Ah
	int 21h


;Ŀ;
; Check for 80386 or better processor																			 ;
;;
Check_Processor:
	pushf

	xor ah,ah
	push ax
	popf
	pushf
	pop ax
	and ah,0F0h
	cmp ah,0F0h

	jz Not386

	mov ah,0F0h
	push ax
	popf
	pushf
	pop ax
	and ah,0F0h
	jnz Is386

	; 32-bit Processor Not Found
Not386:
	mov dx,m o No32ProcMSG
	jmp ErrorExit

Is386:
	popf


;Ŀ;
; Fix-up Global Descriptor Table 																					 ;
;;
Fixup_GDT:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; fix up Kernel descriptor
	mov eax,Kernel
	shl eax,4
	or m d GDT_Kernel+2,eax

	; fix up Code32 and Data32 descriptors
	mov eax,Code32
	shl eax,4
	mov m Code32addr,eax					; save linear address of Code32 segment
	or m d GDT_Code32+2,eax
	or m d GDT_Data32+2,eax

	; make the offset of the GDT linear
	add m pm_GDTaddr,eax

	; get linear base address of PSP segment
	movzx eax,m PSPseg
	shl eax,4
	mov m PSPaddr,eax

  ; get linear base address of Environment segment
  movzx eax,w ES:[2Ch]
  shl eax,4
  mov m Envaddr,eax

	; calculate ESP relative to Code32
	xor eax,eax
	mov ax,ss
  mov m rm_SS,ax                ; save Real Mode SS
	shl eax,4
	add eax,esp
	sub eax,m Code32addr
	mov m v_ESP,eax


;Ŀ;
; Determine protected mode entry type																			 ;
;;
GetSystem:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; Test for DPMI
	mov ax,1687h
	int 2Fh
	test ax,ax
	jnz NoDPMI
		jmp DPMI_System 			; DPMI System
	NoDPMI:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; Test for V86 Mode
	smsw ax
	test al,1
	jz NotV86Mode
		mov dx,m o V86MSG 		; Can't continue
		jmp ErrorExit
	NotV86Mode:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; Check for the presence of an XMS Driver
	mov ax,4300h
	int 2Fh
	cmp al,80h
	jnz NoXMS
		jmp XMS_System				; XMS System
	NoXMS:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	jmp RAW_System					; RAW System


;Ŀ;
; Error Exit.																															 ;
; Prints Error Message, and returns to DOS with error code 0FFh						 ;
;;
ErrorExit:
	mov ah,9h
	int 21h
	mov ax,4CFFh
	int 21h


Kernel		ENDS
;ͻ;
; FMPI segment ends. 																											 ;
;ͼ;


;ͻ;
; Contains code and data for 32-bit Protected Mode.												 ;
;ͼ;
Code32		SEGMENT
					ASSUME CS:Code32, DS:Code32, SS:Code32

;Ŀ;
; Initialization Messages																									 ;
;;
No32ProcMSG db '32-bit processor not detected.',0Ah,24h

V86MSG LABEL
db 'The system is in V86 Mode and a DPMI server is not present.',0Dh,0Ah
db 'Disable the protected mode software or install a DPMI host.',0Ah,24h


;Ŀ;
; Hex table																																 ;
;;
HexTAB db '0123456789ABCDEF'


;Ŀ;
; Mode switching variables 																								 ;
;;
rm_Int						db			0,0 				; Real Mode interrupt to execute

rm_SegRegs				LABEL DWORD 				; Real Mode segment registers
rm_ES 						dw			0
rm_DS 						dw			0


;Ŀ;
; General variables																												 ;
;;

pm_EntryType			db			pm_ENTRY_RAWXMS 	; Protected mode entry type
KernelSeg 				dw			Kernel						; Segment of kernel
PSPSeg						dw			0 								; PSP Segment


;Ŀ;
; Linear Addresses 																												 ;
;;
Code32Addr				dd			0
PSPAddr 					dd			0
EnvAddr           dd      0


;Ŀ;
; Selector Values																													 ;
;;
Selectors 				LABEL 	WORD
Code32Sel 				dw			8h
Data32Sel 				dw			10h
Flat32Sel 				dw			18h


;Ŀ;
; Global Descriptor Table																									 ;
;;
GDT 		LABEL 		BYTE
GDT_NULL					db			8 DUP (0)
GDT_Code32				db			0FFh, 0FFh, 	0h, 	0h, 	0h,  9Ah, 0CFh, 	0h
GDT_Data32				db			0FFh, 0FFh, 	0h, 	0h, 	0h,  92h, 0CFh, 	0h
GDT_Flat32				db			0FFh, 0FFh, 	0h, 	0h, 	0h,  92h, 0CFh, 	0h
GDT_Kernel				db			0FFh, 0FFh, 	0h, 	0h, 	0h,  9Ah, 	0h, 	0h
GDT_Stack16 			db			0FFh, 0FFh, 	0h, 	0h, 	0h,  92h, 	0h, 	0h


; Reference to the Global Descriptor Table
pm_GDT						LABEL 	FWORD
									dw			$-GDT
pm_GDTaddr				dd			o GDT


;Ŀ;
; Initialize system registers and variables then jump to Start32 					 ;
;;
Enter32:
	mov ax,m CS:Data32Sel
	mov ds,ax
	mov es,ax
	mov fs,ax
	mov ss,ax
	mov esp,m v_ESP
	mov gs,m Flat32Sel

	sti

	call Init_Heap								; Initialize heap manager

IFDEF EXCEPTIONS
	call Init_Exception_Handling	; Initialize exception handler
ENDIF

	jmp Start32


;Ŀ;
; Return to Real Mode and terminate																				 ;
;;
Exit32:
	mov ah,4Ch
	int 21h


;Ŀ;
; Error Exit 																															 ;
; Prints error message contained in EDX and terminates 										 ;
;;
ErrorExit32:
	mov ax,0003h
	int 10h
	mov ax,1112h
	xor bl,bl
	int 10h
	call PrintString
	mov ah,4Ch
	int 21h



;Ŀ;
; Converts relative offset in EDX into real mode address in rm_DS:dx 			 ;
;;
AddrEDXtoRM:
	push eax
	add edx,m Code32addr
	mov eax,edx
	and dx,000Fh
	shr eax,4
	mov rm_DS,ax
	pop eax
Ret_Proc:
	ret


;Ŀ;
; Get protected mode interrupt descriptor																	 ;
; Entry:  BL - Interrupt vector																						 ;
; Exit :  AX:EDX - Selector:offset of interrupt vector 										 ;
;;
GetPMInt		LABEL 	DWORD 			; pointer to procedure
						dd			o RAWXMS_Get_pm_Int


;Ŀ;
; Set protected mode interrupt descriptor																	 ;
; Entry:  BL - Interrupt Vector																						 ;
;				 AX:EDX - Selector:offset of interrupt vector 										 ;
;;
SetPMInt		LABEL 	DWORD 			; pointer to procedure
						dd			o RAWXMS_Set_pm_Int


;Ŀ;
; Random 																																	 ;
; Entry: RandMod - Range 																									 ;
; Exit : RandMod - Random Number 																					 ;
;;
RandSeed	dd 12345678h
RandMod  dw ?
Random:
	pushad
	mov ax,m w RandSeed
	mov bx,m w RandSeed+2
	mov cx,ax
	mov dx,8405
	mul dx
	shl cx,3
	add ch,cl
	add dx,cx
	add dx,bx
	shl bx,2
	add dx,bx
	add dh,bl
	shl bx,5
	add dh,bl
	add ax,1
	adc dx,0
	mov m w RandSeed,ax
	mov m w RandSeed+2,dx
	mov cx,dx
	mul m w RandMod
	mov ax,cx
	mov cx,dx
	mul m w RandMod
	add ax,cx
	adc dx,0
	mov m RandMod,dx
	popad
	ret


;Ŀ;
; Print '$' terminating string                                              ;
; Entry: DS:EDX - Address of string																				 ;
;;
PrintString:
	pushad
	mov esi,edx
	mov ah,2
	lodsb
	@@10:
		mov dl,al
		int 21h
		lodsb
		cmp al,'$'
		jnz @@10
	popad
	ret


Code32		ENDS
;ͻ;
; 32-bit segment ends. 																										 ;
;ͼ;


;ͻ;
; Stack																																		 ;
;ͼ;
StackSeg	SEGMENT
	db STACK_SIZE dup (?)
StackSeg	ENDS
;ͻ;
; Stack																																		 ;
;ͼ;


	END 		Entry16
