; TASM MEMORY ALLOCATION EXAMPLE FOR WDOSX
; This one tries to expand the memory segment to the maximum possible size
; and prints out this value.

.386p
code segment use32
assume cs:code,ds:code

start:

		; enable virtual interrupts

		mov	eax,0901h
		int	31h

		; set es = ds

		push	ds
		pop	es

		; check how much memory available

		mov	edi,offset FreeSpace
		mov	eax,500h
		int	31h

		; get free memory ( advisory )

		mov	edx,[edi]

		; add memory we already own

		add	edx,esp

		; try to extend the segment as much as possible

TryMalloc:
		mov	eax,-1
		int	21h
		jnc	MemDone

		; try one page less

		sub	edx,1000h
		jmp	TryMalloc

MemDone:

		; print string

		push	edx
		mov	edx,offset Str1
		mov	ah,9
		int	21h
		pop	eax

		; print number

		call	PrintEax

		; terminate

		mov	ah,4ch
		int	21h

; ------------- print a 32 bit number as decimal value ------------

PrintEax	proc	near
		mov	ecx,10
PrintLoop:
		sub	edx,edx
		div	ecx
		test	eax,eax
		jz	Print0
		push	edx
		call	PrintLoop
		pop	edx
Print0:
		add	dl,'0'
		mov	ah,2
		int	21h		
		ret
PrintEax	endp

; ------------- *** ------------------------------------------------

Str1		db	'Maximum segment size in bytes: ','$'
FreeSpace	label	near
code ends
end start
