Include Common.Def
KERNELHEAD

IFDEF __DLL
.ERR dont compile it to dll! (for now)
ENDIF
;DEBUG EQU 0

Include VESA.Inc

GIG1 EQU 40000000H ; it is 1 GIGA BYTE :)
Align 4
VESA_OldPgFault    DF    ?
Align 4
VESA_ScreenPage    DD    ?
VESA_FaultError    DD    ?
VESA_LastPage      DD    0
VESA_Granul        DD    4*16 DUP(0)
VESA_Mode          DD    ?
VESA_InfoBlock     DD    ?
VESA_Flags         DD    0
; D0 = 1 - using linear frame buffer
VESA_BytesPerLine  DD    ?
VESA_FrameBuffer   DD    ?
VESA_Lines         LABEL DWORD
                   DD    1024D DUP(0) ; line start adresses
DPMIMemHandle      DD    ?

GLOBAL VESA_PageHandler : NEAR
VESA_PageHandler   PROC  NEAR
                   POP   VESA_FaultError
                   PUSH  VESA_FaultError
                   PUSHAD
                   TEST  VESA_FaultError,1
                   JNZ   @@Passed
                   MOV   EAX,CR2
IFDEF DEBUG
                   Say   'page fault at:'
                   SayValue EAX
                   NewLine
ENDIF
                   SUB   EAX,GIG1
                   JB    @@Passed
                   CMP   EAX,400000H ; 4 MEGS
                   JAE   @@Passed

                   MOV   EDI,VESA_LastPage
                   MOV   ECX,16
@@Zero:            AND   D [EDI],0FFFFFFFEH
                   ADD   EDI,4
                   LOOP  @@Zero
                   SHR   EAX,16
IFDEF DEBUG
                   Say   'the page is:'
                   SayValue EAX
                   NewLine
ENDIF
                   MOV   EDI,EAX
                   SHL   EDI,4+2
                   ADD   EDI,VESA_ScreenPage
                   MOV   VESA_LastPage,EDI
                   MOV   ECX,16
@@One:             OR    D [EDI],1
                   ADD   EDI,4
                   LOOP  @@One

                   MOV   EDX,VESA_Granul[EAX*4]
                   PUSH  EDX
                   MOV   EAX,4F05H
                   CLR   EBX
                   REALINT 10H
                   POP   EDX
                   MOV   EAX,4F05H
                   MOV   EBX,1
                   REALINT 10H

@@Serviced:        POPAD
                   ADD   ESP,4
                   IRETD
@@Passed:          POPAD
                   JMP   VESA_OldPgFault
VESA_PageHandler   ENDP

GLOBAL DPMI_PageHandler : NEAR
DPMI_PageHandler   PROC  NEAR
                   PushSegs
                   ReLoadSegs
                   PUSHAD

                   MOV   EAX,CR2
IFDEF DEBUG
                   Say   'PAGE FAULT AT '
                   SayValue EAX
                   NewLine
ENDIF
                   MOV   EBX,VESA_FrameBuffer
                   ADD   EBX,Code32Base
                   SUB   EAX,EBX
                   JB    @@Passed
                   SHR   EAX,16 ; div by 64k
                   CMP   EAX,16*4
                   JAE   @@Passed  ; out of 4 meg!

                   PUSH  EAX
                   MOV   EAX,VESA_LastPage
                   CALL  DPMI_Uncommit
                   POP   EAX
                   CALL  DPMI_Map

                   POPAD
                   PopSegs
                   RETF

@@Passed:          POPAD
                   PopSegs
                   JMP   CS:VESA_OldPgFault
DPMI_PageHandler   ENDP

comment #
 VESASignature DB 'VESA' +0
 VESAVersion   DW  ?     +4
 OEMStringPtr  DD  ?     +6
 Capabilities  DD  ?     +10
 VideoModePtr  DD  ?     +14
 TotalMemory   DW  ?     +18
 Reserved      DB 236D   +20
#

comment #
typedef struct vesanfo {
 U16 ModeAttributes; + 0
 U8 WinAAttributes; + 2
 U8 WinBAttributes; + 3
 U16 WinGranularity; + 4
 U16 WinSize; + 6
 U16 WinASegment; + 8
 U16 WinBSegment; + 10
 U32 WinFuncPtr; + 12
 U16 BytesPerScanLine; + 16
/* vesa 1.2 info */
 U16 XResolution; + 18
 U16 YResolution; + 20
 U8 XCharSize; + 22
 U8 YCharSize; + 23
 U8 NumberOfPlanes; + 24
 U8 BitsPerPixel + 25
 U8 NumberOfBanks + 26
 U8 MemoryModel; + 27
 U8 BankSize; + 28
 U8 NumberOfImagePages; + 29
 U8 Reserved; + 30
 U8 RedMaskSize; + 31
 U8 RedFieldPosition + 32
 U8 GreenMaskSize + 33
 U8 GreenFieldPosition + 34
 U8 BlueMaskSize + 35
 U8 BlueFieldPosition + 36
 U8 RsvdMaskSize + 37
 U8 RsvdFieldPosition + 38
 U8 DirectColorModeInfo + 39
 /* vesa 2.0 information */
 U32 PhysBasePtr + 40
 U32 OffScreenMemOffset + 44
 U16 OffScreenMemSize + 48
} vesanfo;
#

GLOBAL VESA_Init : NEAR
VESA_Init          PROC  NEAR
                   ; input - EAX VESA mode
                   MOV   VESA_Mode,EAX
                   MOV   EAX,256
                   CALL  Lo_Alloc
                   OR    EAX,EAX
                   JZ    @@Failed ; error code 0

                   MOV   VESA_InfoBlock,EAX
                   ADD   EAX,Code32Base
                   MOV   EDI,EAX
                   AND   EDI,0FH
                   SHR   EAX,4
                   MOV   RI_DS,AX
                   MOV   RI_ES,AX
                   MOV   EAX,4F01H
                   MOV   ECX,VESA_Mode
                   REALINT 10H ; get mode information
                   CMP   AX,004FH
                   MOV   EAX,1  ; error code 1
                   JNZ   @@FailFree

                   MOV   EAX,GIG1           ; set frame buffer pos
                   SUB   EAX,Code32Base
                   MOV   VESA_FrameBuffer,EAX

                   MOV   VESA_Flags,0
                   MOV   EBX,VESA_InfoBlock
IFDEF DEBUG
                   PUSHAD
                   MOVZX EAX,W [EBX]
                   Say   'mode bits:'
                   SayValue EAX
                   NewLine
                   POPAD
ENDIF
                   TEST  W [EBX],1
                   MOV   EAX,1 ; error code 1
                   JZ    @@FailFree ; mode not supported
                   CMP   SystemFlag,SystemDPMI
                   JZ    @@DPMI     ; dpmi system, a bit more complicated

                   TEST  W [EBX],10000000B
                   JNZ   @@LinearFB
IFDEF DEBUG
                   SayLn 'Using windowed mode.'
ENDIF
                   CALL  @@SetGranTable
                   CALL  @@SetLineTable

                   ; initialize extra page
                   MOV   EDI,PageExtraBase
                   SUB   EDI,Code32Base
                   MOV   VESA_ScreenPage,EDI
                   MOV   VESA_LastPage,EDI
                   CLD
                   MOV   EDX,4*16
@@OuterLp:         MOV   ECX,16
                   MOV   EAX,0A0006H ; USER, RW, NOT PRESENT
@@Here:            STOSD
                   ADD   EAX,4096
                   LOOP  @@Here
                   DEC   EDX
                   JNZ   @@OuterLp
                   MOV   EBX,PageDirBase
                   SUB   EBX,Code32Base
                   MOV   EAX,PageExtraBase
                   AND   EAX,0FFFFF000H
                   OR    EAX,111B
                   MOV   [EBX+1024],EAX ; set extra 4 meg at 1 GIG

                   IFNDEF DEBUG
                   MOV   EAX,4F02H
                   MOV   EBX,VESA_Mode
                   REALINT 10H  ; set video mode
                   CMP   AX,004FH
                   MOV   EAX,2 ; error code 2
                   JNZ   @@FailFree
                   ENDIF

                   MOV   AL,14 ; page fault handler
                   CALL  GetIntVec
                   MOV   D VESA_OldPgFault,EAX
                   MOV   W VESA_OldPgFault+4,BX

                   MOV   BL,14 ; page fault handler
                   MOV   EAX,O VESA_PageHandler
                   MOV   CX,CS
                   CALL  SetIntVec
@@OK:
                   CALL  SetPagingOn
@@OKFree:
                   MOV   EAX,VESA_InfoBlock
                   MOV   ECX,256
                   CALL  Lo_Free
@@druut:
                   CLC
                   RET

@@FailFree:        PUSH  EAX ; save error code
                   MOV   EAX,VESA_InfoBlock
                   MOV   ECX,256
                   CALL  Lo_Free
                   POP   EAX
@@Failed:          STC
                   RET

;-------------------------------------------------------------------------
@@LinearFB:
IFDEF DEBUG
                   SayLn 'Using linear frame buffer.'
ENDIF
                   OR    VESA_Flags,1
                   CALL  @@SetLineTable

                   ; initialize extra page
                   MOV   EDI,PageExtraBase
                   SUB   EDI,Code32Base
                   CLD
                   MOV   ECX,256 ; 1 meg
                   MOV   EAX,[EBX+40] ; beginning of linear mem
IFDEF DEBUG
                   PUSHAD
                   Say   'linear mem at: '
                   SayValue EAX
                   NewLine
                   POPAD
ENDIF
                   OR    EAX,7 ; rw, present
@@Here2:           STOSD
                   ADD   EAX,4096
                   LOOP  @@Here2
                   MOV   EBX,PageDirBase
                   SUB   EBX,Code32Base
                   MOV   EAX,PageExtraBase
                   AND   EAX,0FFFFF000H
                   OR    EAX,111B
                   MOV   [EBX+1024],EAX ; set extra 4 meg at 1 GIG

IFNDEF DEBUG
                   MOV   EAX,4F02H
                   MOV   EBX,VESA_Mode
                   OR    EBX,4000H ; set linear bit
                   REALINT 10H
                   CMP   AX,004FH
                   MOV   EAX,2     ; error code 2
                   JNZ   @@FailFree
ENDIF
                   JMP   @@OK

;----------------------------------------------------------------------------
@@DPMI:            TEST  W [EBX],10000000B
                   JNZ   @@DPMILinear
IFDEF DEBUG
                   SayLn 'DPMI mode: Using windowed mode.'
ENDIF
                   CALL  @@SetGranTable
                   CALL  @@SetLineTable

                   MOV   EAX,400H ; get dpmi version
                   INT   31H
IFDEF DEBUG
                   MOV   EBX,EAX
ENDIF
                   CMP   EAX,100H
                   MOV   EAX,3 ; error code 3
                   JL    @@FailFree
IFDEF DEBUG
                   MOV   EAX,EBX
                   Say   'DPMI Version '
                   PUSH   EAX
                   MOVZX  EAX,AH
                   SayDec EAX
                   MOV    AL,'.'
                   CALL   DisplayChar
                   MOV    EAX,[ESP]
                   MOVZX  EAX,AL
                   SayDec EAX
                   NewLine
                   POP    EAX
ENDIF
; allocate 1 meg uncommited pages
                   MOV   EAX,0504H
                   CLR   EBX  ; fuck, anywhere it can be
                   MOV   ECX,400000H ; 4 meg
                   CLR   EDX  ; bit 0 = 0 - uncommited pages
                   INT   31H
                   MOV   EAX,4 ; error code 4
                   JC    @@FailFree

                   SUB   EBX,Code32Base
                   MOV   VESA_FrameBuffer,EBX
                   MOV   DPMIMemHandle,ESI
IFDEF DEBUG
                   Say   'linear memory at: '
                   SayValue EBX
                   NewLine
ENDIF
                   CLR   EAX
                   CALL  DPMI_Map

                   MOV   EAX,0202H ; get exception handler
                   MOV   BL,14 ; page fault
                   INT   31H
                   MOV   D VESA_OldPgFault,EDX
                   MOV   W VESA_OldPgFault+4,CX

                   MOV   EAX,0203H ; set exception handler
                   MOV   BL,14
                   MOV   CX,CS
                   MOV   EDX,O DPMI_PageHandler
                   INT   31H
IFNDEF DEBUG
                   MOV   EAX,4F02H
                   MOV   EBX,VESA_Mode
                   REALINT 10H  ; set video mode
                   CMP   AX,004FH
                   MOV   EAX,2 ; error code 2
                   JNZ   @@FailFree
ENDIF

                   JMP   @@OKFree
@@DPMILinear:
IFDEF DEBUG
                   SayLn 'DPMI mode: Using linear frame buffer.'
ENDIF
                   OR    VESA_Flags,1
                   CALL  @@SetLineTable
IFDEF DEBUG
                   Say   'Physical memory at:'
                   SayValue <[EBX+40]>
                   NewLine
ENDIF
                   MOV   BX,[EBX+42] ; beginning of linear mem
                   MOV   CX,[EBX+40] ; beginning of linear mem
                   CLR   EDI
                   MOV   ESI,40H ; 40 0000H = 4 meg
                   MOV   EAX,800H
                   INT   31H
                   MOV   EAX,5 ; error code 5
                   JC    @@FailFree

                   SHL   EBX,16
                   MOV   BX,CX
IFDEF DEBUG
                   Say   'Mapped at:'
                   SayValue EBX
                   NewLine
ENDIF
                   SUB   EBX,Code32Base
                   MOV   VESA_FrameBuffer,EBX
IFDEF DEBUG
                   Say   'Frame buffer at:'
                   SayValue EBX
                   NewLine
ENDIF
IFNDEF DEBUG
                   MOV   EAX,4F02H
                   MOV   EBX,VESA_Mode
                   OR    EBX,4000H ; set linear bit
                   REALINT 10H
                   CMP   AX,004FH
                   MOV   EAX,2 ; error code 2
                   JNZ   @@FailFree
ENDIF
                   JMP   @@OKFree
;---------------------------------------------------------------------------
; utility subfunctions

; setup VESA_BytesPerLine, VESA_FrameBuffer and VESA_Lines
@@SetLineTable:    MOV   EBX,VESA_InfoBlock
                   MOVZX EDX,W [EBX+16] ; bytes per scanline
                   MOV   VESA_BytesPerLine,EDX
                   XOR   EAX,EAX ;!!! ahem, for use with other buffers
                   MOV   ECX,1024
                   MOV   EDI,O VESA_Lines
@@LinesLoop:       STOSD
                   ADD   EAX,EDX
                   LOOP  @@LinesLoop
                   RETN
;****************************
; now lets take care about window granularity
; EBX - vesa data
@@SetGranTable:    MOV   ECX,16*4
                   CLD
                   MOV   EDI,O VESA_Granul
                   XOR   ESI,ESI ; address
                   MOVZX EBP,W [EBX+4] ; win granularity
@@GranLoop:        MOV   EAX,ESI
                   XOR   EDX,EDX
                   DIV   EBP
                   STOSD
                   ADD   ESI,64
                   LOOP  @@GranLoop
                   RETN
VESA_Init          ENDP

DPMI_Uncommit      PROC  NEAR
; eax - 64kblock
                   MOV   EBX,EAX
                   SHL   EBX,16 ; block * 64k
                   MOV   ESI,DPMIMemHandle
                   MOV   ECX,16 ; 16 pages = 64k
                   MOV   EDX,O @@SetupTab
                   MOV   EAX,507H
                   INT   31H
IFDEF DEBUG
                   JNC   @@SkipErr
                   SayLn 'DPMI uncommit pages failed!'
                   Say   'Error code: '
                   SayValue EAX
                   NewLine
                   CALL   Kbd_Get
@@SkipErr:
ENDIF

                   RET
@@SetupTab         DW    16 DUP(0000B)
                   ;             uncommited page
                   ;             page is 0 - r, 1 - r/w
DPMI_Uncommit      ENDP

DPMI_Map           PROC  NEAR
; EAX - 64k block
                   MOV   VESA_LastPage,EAX
                   PUSH  EAX
                   MOV   EDX,VESA_Granul[EAX*4]
                   PUSH  EDX
                   MOV   EAX,4F05H
                   CLR   EBX
                   REALINT 10H
                   POP   EDX
                   MOV   EAX,4F05H
                   MOV   EBX,1
                   REALINT 10H
                   POP   EAX

                   MOV   EBX,EAX
                   SHL   EBX,16 ; block * 64k
                   MOV   ESI,DPMIMemHandle
                   MOV   ECX,16 ; 16 pages = 64k
                   MOV   EDX,0A0000H
                   MOV   EAX,0508H
                   INT   31H
IFDEF DEBUG
                   JNC   @@SkipErr
                   SayLn 'DPMI map physical memory failed!'
                   Say   'Error code: '
                   SayValue EAX
                   NewLine
                   CALL   Kbd_Get
@@SkipErr:
ENDIF
                   RET
DPMI_Map           ENDP

GLOBAL VESA_Done : NEAR
VESA_Done          PROC  NEAR
                   CMP   SystemFlag,SystemDPMI
                   JZ    @@DPMICleanup

                   TEST  VESA_Flags,1
                   JNZ   @@druut
                   MOV   BL,14
                   MOV   EAX,D VESA_OldPgFault
                   MOV   CX,W VESA_OldPgFault+4
                   CALL  SetIntVec
                   JMP   @@druut

@@DPMICleanup:     TEST  VESA_Flags,1
                   JNZ   @@druut ; nothing to do
; restore exception handler
                   MOV   EDX,D VESA_OldPgFault
                   MOV   CX,W VESA_OldPgFault+4
                   MOV   EAX,0203H ; set exception handler
                   MOV   BL,14
                   INT   31H
; free linear memory
                   MOV   EAX,502H
                   MOV   DI,W DPMIMemHandle
                   MOV   SI,W DPMIMemHandle+2
                   INT   31H
@@druut:
                   RET
VESA_Done          ENDP
; PageDirBase - base of main page directory
; PageExtraBase - base address of extra page

verr000            DB    'VID000: Not enough low memory!',0
verr001            DB    'VID001: Mode not supported!',0
verr002            DB    'VID002: Video mode initialization failed!',0
verr003            DB    'VID003: DPMI 1.0 required when no linear frame buffer found!',0
verr004            DB    'VID004: DPMI Fn 504H - linear memory allocation failed!',0
verr005            DB    'VID005: DPMI Fn 800H - physical memory mapping failed!',0
VESA_ErrorTab      DD    O verr000
                   DD    O verr001
                   DD    O verr002
                   DD    O verr003
                   DD    O verr004
                   DD    O verr005

comment #
Main               PROC  NEAR
                   MOV   EAX,101H
                   CALL  VESA_Init
                   JNC   @@Doit
                   MOV   ESI,VESA_ErrorTab[EAX*4]
                   CALL  DisplayNullString
                   NewLine
                   JMP   @@druut
@@Doit:
                   MOV   EAX,12345678H
                   MOV   ECX,76800
                   MOV   EDI,VESA_FrameBuffer
                   CLD
                   REP   STOSD
                   CALL  VESA_Done
@@druut:
                   RET
Main               ENDP
#

KERNELTAIL
