Include Common.Def
KERNELHEAD
IFDEF __DLL
.ERR dont compile it to dll! (for now)
ENDIF

comment #
 welcome to some stupid driver for mouse hardware
 it seems to work with ms mouse on com port (2 buttons)
                       3 buttons mouse on com port
                       and inport mouse
 if you make your own user routine then on entry expect
 AL - mouse buttons
 AH - buttons that changed state
 EBX - event flags that caused calling this routine
 ECX - current mouse X
 EDX - current mouse Y

well i may consider adding dynamic scaling for future versions
#
;DBUG EQU 0
INCLUDE Mouse.Inc

THR                EQU 0
IER                EQU 1
IIR                EQU 2
LCR                EQU 3
MCR                EQU 4
LSR                EQU 5
MSR                EQU 6

MouseIn            MACRO Port
                   MOV   DX,Mouse_Port
                   IFNB  <Port>
                   ADD   DX,Port
                   ENDIF
                   IN    AL,DX
                   JmpWait
                   ENDM

MouseOut           MACRO Port
                   MOV   DX,Mouse_Port
                   IFNB  <Port>
                   ADD   DX,Port
                   ENDIF
                   OUT   DX,AL
                   JmpWait
                   ENDM

Mouse_OldHandler   DF  ?
Mouse_X            DD  0
Mouse_Y            DD  0
Mouse_MaxX         DD  319
Mouse_MaxY         DD  199
Mouse_MinX         DD  0
Mouse_MinY         DD  0
Mouse_Buttons      DB  0
; 1 - right
; 2 - left
; 4 - middle
Mouse_Type         DB  0
Mouse_IRQ          DB  4
Mouse_Port         DW  3F8H
Mouse_ByteCnt      DD  0
Mouse_Data         DB  0,0,0,0,0

Mouse_UserProc     DD   O Mouse_Stub
Mouse_EventMask    DD   0
Mouse_CurrentEvent DD   0

Mouse_Stub         PROC  NEAR
                   IFDEF DBUG
                   MOVZX EAX,AL
                   Say   'buttons '
                   SayValue EAX
                   Say   ' x: '
                   SayValue ECX
                   Say   ' y: '
                   SayValue EDX
                   NewLine
                   ENDIF
                   RET
Mouse_Stub         ENDP

Mouse_MS           PROC  NEAR
                   CLI
                   PUSHAD
                   MouseIn LSR
                   MouseIn THR
                   MOV   EBX,Mouse_ByteCnt
                   OR    EBX,EBX
                   JNZ   @@SkipTest
                   MOV   AH,AL
                   AND   AH,01000000B
                   JZ    @@druut ; mouse has fucked up
@@SkipTest:
                   MOV   Mouse_Data[EBX],AL
                   INC   Mouse_ByteCnt
                   CMP   Mouse_ByteCnt,3
                   JNZ   @@druut
                   MOV   Mouse_ByteCnt,0
                   ; output is AL - button state
                   ;           AH - buttons change
                   ;           ECX - horizontal movement
                   ;           EDX - vertical movement
                   ; now lets decode mouse fields
                   ; byte 0
;
                   IFDEF DBUG
                   ; print out data packet here
                   MOVZX EAX,B Mouse_Data[0]
                   SayValue EAX
                   Say ' '
                   MOVZX EAX,B Mouse_Data[1]
                   SayValue EAX
                   Say ' '
                   MOVZX EAX,B Mouse_Data[2]
                   SayValue EAX
                   SayLn ' '
                   ENDIF
                   MOV   AH,Mouse_Data[0]
                   SHR   AH,4 ; skip stupid bytes
                   XOR   AL,AL
                   SHR   AH,1 ; right button
                   ;CMC
                   RCL   AL,1
                   CLC        ; no middle button huh ?
                   RCL   AL,1
                   SHR   AH,1 ; left button
                   ;CMC
                   RCL   AL,1
                   MOV   AH,Mouse_Buttons
                   XOR   AH,AL
                   MOV   CH,Mouse_Data[0]
                   MOV   CL,Mouse_Data[1]
                   SHL   CH,6
                   AND   CL,00111111B
                   OR    CL,CH
                   MOVSX ECX,CL
                   MOV   DH,Mouse_Data[0]
                   MOV   DL,Mouse_Data[2]
                   AND   DH,00001100B
                   SHL   DH,4
                   AND   DL,00111111B
                   OR    DL,DH
                   MOVSX EDX,DL
MouseCommon:
; now lets set event bits
                   MOV   Mouse_CurrentEvent,0
                   OR    ECX,ECX
                   JZ    @@NotMoveX
                   OR    Mouse_CurrentEvent,ME_Moved
@@NotMoveX:        OR    EDX,EDX
                   JZ    @@NotMoveY
                   OR    Mouse_CurrentEvent,ME_Moved
@@NotMoveY:
                   ; AH  1 if button changed state
                   ; AL  1 if button pressed
@@testbutton       MACRO buttonmask,eventmask
                   LOCAL Skip,Done
                   TEST  AH,buttonmask
                   JZ    Done
                   MOV   EBX,eventmask
                   TEST  AL,buttonmask
                   JNZ   Skip
                   ADD   EBX,EBX
Skip:              OR    Mouse_CurrentEvent,EBX
Done:
                   ENDM

                   @@testbutton MB_L,ME_LBPressed
                   @@testbutton MB_R,ME_RBPressed
                   @@testbutton MB_M,ME_MBPressed

                   ADD   ECX,Mouse_X
                   CMP   ECX,Mouse_MaxX
                   JLE   @@XOK1
                   MOV   ECX,Mouse_MaxX
@@XOK1:            CMP   ECX,Mouse_MinX
                   JGE   @@XOK2
                   MOV   ECX,Mouse_MinX
@@XOK2:
                   ADD   EDX,Mouse_Y
                   CMP   EDX,Mouse_MaxY
                   JLE   @@YOK1
                   MOV   EDX,Mouse_MaxY
@@YOK1:            CMP   EDX,Mouse_MinY
                   JGE   @@YOK2
                   MOV   EDX,Mouse_MinY
@@YOK2:
                   MOV   Mouse_Buttons,AL
                   MOV   Mouse_X,ECX
                   MOV   Mouse_Y,EDX
                   MOV   EBX,Mouse_CurrentEvent
                   AND   EBX,Mouse_EventMask
                   JZ    @@nouser
                   CALL  D Mouse_UserProc
@@nouser:

@@druut:           POPAD
                   PUSH  AX
                   MOV   AL,20H
                   OUT   20H,AL
                   POP   AX
                   IRETD

Mouse_MS           ENDP

Mouse_MSM          PROC  NEAR
                   CLI
                   PUSHAD
                   MouseIn LSR
                   MouseIn THR
                   MOV   EBX,Mouse_ByteCnt
                   OR    EBX,EBX
                   JNZ   @@SkipTest
                   MOV   AH,AL
                   AND   AH,0F8H
                   CMP   AH,80H
                   JNZ   @@druut ; well mouse has fucked up
@@SkipTest:
                   MOV   Mouse_Data[EBX],AL
                   INC   Mouse_ByteCnt
                   CMP   Mouse_ByteCnt,5
                   JNZ   @@druut
                   MOV   Mouse_ByteCnt,0
                   ; output is AL - button state
                   ;           AH - buttons change
                   ;           ECX - horizontal movement
                   ;           EDX - vertical movement
                   ; now lets decode mouse fields
                   ; byte 0
;
                   IFDEF DBUG
                   ; print out data packet here
                   MOVZX EAX,B Mouse_Data[0]
                   SayValue EAX
                   Say ' '
                   MOVZX EAX,B Mouse_Data[1]
                   SayValue EAX
                   Say ' '
                   MOVZX EAX,B Mouse_Data[2]
                   SayValue EAX
                   Say ' '
                   MOVZX EAX,B Mouse_Data[3]
                   SayValue EAX
                   Say ' '
                   MOVZX EAX,B Mouse_Data[4]
                   SayValue EAX
                   SayLn ' '
                   ENDIF
                   MOV   AH,Mouse_Data[0]
                   XOR   AL,AL
                   SHR   AH,1 ; right button
                   CMC
                   RCL   AL,1
                   SHR   AH,1 ; middle button
                   CMC
                   RCL   AL,1
                   SHR   AH,1 ; left button
                   CMC
                   RCL   AL,1
                   MOV   AH,Mouse_Buttons
                   XOR   AH,AL
                   MOVSX ECX,B Mouse_Data[1]
                   MOVSX EDX,B Mouse_Data[2]
                   NEG   EDX
                   JMP   MouseCommon
@@druut:           POPAD
                   PUSH  AX
                   MOV   AL,20H
                   OUT   20H,AL
                   POP   AX
                   IRETD
Mouse_MSM          ENDP

Mouse_INP          PROC  NEAR
                   CLI
                   PUSHAD
                   MOV   AL,7H
                   MouseOut 0
                   MouseIn 1
                   OR    AL,20H
                   MouseOut 1
                   MOV   AL,0
                   MouseOut 0
                   MouseIn 1
                   MOV   Mouse_Data[0],AL
                   MOV   AL,1
                   MouseOut 0
                   MouseIn 1
                   MOV   Mouse_Data[1],AL
                   MOV   AL,2
                   MouseOut 0
                   MouseIn 1
                   MOV   Mouse_Data[2],AL
                   MOV   AL,7H
                   MouseOut 0
                   MouseIn 1
                   AND    AL,0DFH
                   MouseOut 1

                   ; output is AL - button state
                   ;           AH - buttons change
                   ;           ECX - horizontal movement
                   ;           EDX - vertical movement
                   ; now lets decode mouse fields
                   ; byte 0
;
                   IFDEF DBUG
                   ; print out data packet here
                   MOVZX EAX,B Mouse_Data[0]
                   SayValue EAX
                   Say ' '
                   MOVZX EAX,B Mouse_Data[1]
                   SayValue EAX
                   Say ' '
                   MOVZX EAX,B Mouse_Data[2]
                   SayValue EAX
                   SayLn ' '
                   ENDIF
                   MOV   AH,Mouse_Data[0]
                   XOR   AL,AL
                   SHR   AH,1 ; right button
                   CMC
                   RCL   AL,1
                   SHR   AH,1 ; middle button
                   CMC
                   RCL   AL,1
                   SHR   AH,1 ; left button
                   CMC
                   RCL   AL,1
                   MOV   AH,Mouse_Buttons
                   XOR   AH,AL
                   MOVSX ECX,B Mouse_Data[1]
                   MOVSX EDX,B Mouse_Data[2]
                   JMP   MouseCommon
@@druut:           POPAD
                   PUSH  AX
                   MOV   AL,20H
                   OUT   20H,AL
                   POP   AX
                   IRETD
Mouse_INP          ENDP

Mouse_Init         PROC  NEAR
                   MOVZX EAX,Mouse_IRQ
                   MOV   AL,IRQMap[EAX]
                   CALL  GetIntVec
                   MOV   D Mouse_OldHandler,EAX
                   MOV   W Mouse_OldHandler+4,BX

                   CMP   Mouse_Type,2 ; inport mouse
                   JZ    @@InPort
                   CLI
                   MOV   EAX,O Mouse_MS ; 2 button
                   MOV   CX,CS
                   CMP   Mouse_Type,0
                   JZ    @@SkipType1
                   MOV   EAX,O Mouse_MSM ; 3 button
                   MOV   CX,CS
@@SkipType1:       MOVZX EBX,Mouse_IRQ
                   MOV   BL,IRQMap[EBX]
                   CALL  SetIntVec

                   MOV   AL,80H
                   MouseOut LCR
                   MOV   AL,0
                   MouseOut IER
                   MOV   AL,60H
                   MouseOut THR
                   MOV   AL,2
                   CMP  Mouse_Type,0
                   JZ   @@SkipType2
                   MOV   AL,3
@@SkipType2:       MouseOut LCR
                   MOV   AL,0BH
                   MouseOut MCR
                   MOV   AL,1
                   MouseOut IER
                   MouseIn LSR
                   MouseIn THR
@@common:
                   MOV   BL,Mouse_IRQ
                   CALL  EnableCallBack
                   CALL  GetIRQMasks
                   MOV   DX,0FFFEH
                   MOV   CL,Mouse_IRQ
                   ROL   DX,CL
                   AND   AX,DX
                   CALL  SetIRQMasks
                   STI
@@druut:
                   RET

@@InPort:          CLI
                   MOV   EAX,O Mouse_INP
                   MOVZX EBX,Mouse_IRQ
                   MOV   BL,IRQMap[EBX]
                   CALL  SetIntVec

                   MOV   AL,80H
                   MouseOut 0
                   MOV   AL,7
                   MouseOut 0
                   MOV   AL,9H
                   MouseOut 1

                   JMP   @@common

Mouse_Init         ENDP

Mouse_Done         PROC  NEAR
                   CLI
                   ;CALL  GetIRQMasks
                   ;MOV   DX,1H
                   ;MOV   CL,Mouse_IRQ
                   ;ROL   DX,CL
                   ;OR    AX,DX
                   ;CALL  SetIRQMasks
                   MOVZX EBX,Mouse_IRQ
                   CALL  DisableCallBack
                   MOVZX EBX,Mouse_IRQ
                   MOV   BL,IRQMap[EBX]
                   MOV   EAX,D Mouse_OldHandler
                   MOV   CX,W Mouse_OldHandler+4
                   CALL  SetIntVec
                   STI
                   RET
Mouse_Done         ENDP

GetCfg             MACRO txt,max
                   LOCAL Lp
                   MOV   ESI,O txt
                   CALL  DisplayNullString
Lp:                CALL  Kbd_Get
                   CMP   AL,'0'
                   JB    Lp
                   CMP   AL,max
                   JA    Lp
                   CALL  DisplayChar
                   NewLine
                   SUB   AL,'0'
                   MOVZX EAX,AL
                   ENDM

Mouse_Cfg          PROC  NEAR
                   GetCfg @@Text1,'2'
                   MOV   Mouse_Type,AL
                   CMP   AL,2
                   JZ    @@InPort
                   GetCfg @@Text2,'1'
                   MOV   Mouse_Port,3F8H
                   MOV   Mouse_IRQ,4
                   CMP   AL,0
                   JZ    @@druut
                   MOV   Mouse_Port,2F8H
                   MOV   Mouse_IRQ,3
                   JMP   @@druut
@@InPort:          GetCfg @@Text3,'1'
                   MOV   Mouse_Port,23CH
                   MOV   Mouse_IRQ,3
                   CMP   AL,0
                   JZ    @@druut
@@druut:
                   RET
@@Text1            DB    'Please choose type of your mouse:',CRLF
                   DB    ' 0 - serial port mouse, 2 buttons mode',CRLF
                   DB    ' 1 - serial port mouse, 3 buttons mode',CRLF
                   DB    ' 2 - InPort mouse',CRLF
                   DB    'What do you say: ',0
@@Text2            DB    'Please tell me how your mouse is connected:',CRLF
                   DB    ' 0 - COM1 port (3F8H, IRQ 4)',CRLF
                   DB    ' 1 - COM2 port (2F8H, IRQ 3)',CRLF
                   DB    'What is your answer: ',0
@@Text3            DB    'Please tell me how your mouse is connected:',CRLF
                   DB    ' 0 - primary port (23CH,IRQ 3)',CRLF
                   DB    ' 1 - secondary port (H,IRQ )',CRLF
                   DB    'What is your answer: ',0
Mouse_Cfg          ENDP

; EAX - proc
; EBX - event mask
Mouse_SetUserProc  PROC  NEAR
                   PUSHFD
                   CLI
                   MOV   Mouse_UserProc,EAX
                   MOV   Mouse_EventMask,EBX
                   POPFD
                   RET
Mouse_SetUserProc  ENDP

Mouse_GetAll       PROC  NEAR
                   PUSHFD
                   CLI
                   MOVZX EAX,Mouse_Buttons
                   MOV   ECX,Mouse_X
                   MOV   EDX,Mouse_Y
                   POPFD
                   RET
Mouse_GetAll       ENDP

; ECX - range lo
; EDX - range hi
Mouse_SetXRange    PROC  NEAR
                   PUSHFD
                   CLI
                   PUSH  EAX
                   MOV   Mouse_MinX,ECX
                   MOV   Mouse_MaxX,EDX
                   MOV   EAX,Mouse_X
                   CMP   EAX,ECX
                   JGE   @@OK1
                   MOV   EAX,ECX
@@OK1:             CMP   EAX,EDX
                   JLE   @@OK2
                   MOV   EAX,EDX
@@OK2:             MOV   Mouse_X,EAX
                   POP   EAX
                   POPFD
                   RET
Mouse_SetXRange    ENDP

; ECX - range lo
; EDX - range hi
Mouse_SetYRange    PROC  NEAR
                   PUSHFD
                   CLI
                   PUSH  EAX
                   MOV   Mouse_MinY,ECX
                   MOV   Mouse_MaxY,EDX
                   MOV   EAX,Mouse_Y
                   CMP   EAX,ECX
                   JGE   @@OK1
                   MOV   EAX,ECX
@@OK1:             CMP   EAX,EDX
                   JLE   @@OK2
                   MOV   EAX,EDX
@@OK2:             MOV   Mouse_Y,EAX
                   POP   EAX
                   POPFD
                   RET
Mouse_SetYRange    ENDP

IFDEF DBUG
Main:              CALL  Mouse_Cfg
                   CALL  Mouse_Init
                   MOV   Mouse_EventMask,0FFFFFH
                   CALL  Kbd_Get
                   CALL  Mouse_Done
                   JMP   BackToReality
ENDIF

KERNELTAIL
