;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; constants, hardware specific

HERTZ50            EQU  441

; some useful constants
SB_SampleMem       EQU 512 ; 1 meg for samples
SB_DMAMax          EQU 4096 ; max length of one dma chunk
SB_DMAMaxS         EQU 12

DivBase            EQU 41178 ; for computing adder
;DivBase EQU 20688
comment #
DivBase / 428 (1ACH) (C-2) = 8287 (C-2 samplerate) * 256 / 22050 :)
#

; sound blaster constants
Cmd_DMAStop        EQU  0D0H
Cmd_SpkOn          EQU  0D1H
Cmd_SpkOff         EQU  0D3H
Cmd_DMACont        EQU  0D4H
Cmd_PlaybackFreq   EQU  040H

Freq_22KHz         EQU  256-45
Freq_11KHz         EQU  256-91

DMA_8bit           EQU  14H


;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; hardware specific variables

; sound blaster ports
SBP_Mixer          DW    04H
SBP_Reset          DW    06H
SBP_ReadData       DW    0AH
SBP_BufferStatus   DW    0CH
SBP_WriteCmdDat    DW    0CH
SBP_DataAvail      DW    0EH
SBP_DataAvail16    DW    0FH
SBP_Base           DW    0

DMABuffer          DD    ?
DMALen             DW    ?
SB_PIC1            DB   FALSE
SB_DMABuffer       DD   ?      ; dma buffer addres, so we know what to free
Buffer0Offset      DD   ?
Buffer1Offset      DD   ?
Buffer0Abs         DD   ?
Buffer1Abs         DD   ?
Buffer0Len         DD   ?
Buffer1Len         DD   ?

BufferToMix        DD    0
Buffer0Played      DB    ?

TickLen            DD    HERTZ50

SB_SampleBank      DD    ? ; address of sb samples bank
SB_Mem             DD    ? ; address of current position in samples bank
SB_ShutDown        DB    FALSE

;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; hardware specific functions and macros

WriteDSP           MACRO What
                   LOCAL Here
                   MOV   DX,SBP_BufferStatus
Here:              IN    AL,DX
                   TEST  AL,80H
                   JNZ   Here
                   MOV   DX,SBP_WriteCmdDat
                   MOV   AL,What
                   OUT   DX,AL
                   ENDM

SB_Reset           PROC  NEAR
                   MOV   DX,SBP_Reset
                   MOV   AL,01H
                   OUT   DX,AL

                   MOV   ECX,1000
@@delay1:          IN    AL,80H
                   LOOP  @@delay1

                   MOV   DX,SBP_Reset
                   MOV   AL,00H
                   OUT   DX,AL

                   MOV   ECX,1000
@@delay2:          IN    AL,80H
                   LOOP  @@delay2

                   MOV   DX,SBP_DataAvail
                   MOV   ECX,1000
@@WAIT2:           IN    AL,DX
                   TEST  AL,80H
                   JNZ   @@DoRead
                   LOOP  @@WAIT2
@@DoRead:          MOV   DX,SBP_ReadData
                   IN    AL,DX
                   RET
SB_Reset           ENDP

SB_SpkOn           PROC  NEAR
                   WriteDSP Cmd_SpkOn
                   RET
SB_SpkOn           ENDP

SB_SpkOff          PROC  NEAR
                   WriteDSP Cmd_SpkOff
                   RET
SB_SpkOff          ENDP

SB_DMACont         PROC NEAR
                   WriteDSP Cmd_DMACont
                   RET
SB_DMACont         ENDP

SB_DMAStop         PROC NEAR
                   WriteDSP Cmd_DMAStop
                   RET
SB_DMAStop         ENDP

SB_Playback        PROC  NEAR
                   DEC   DMALen
                   MOV   AL,B CFG_PrimaryDMA
                   MOV   EBX,DMABuffer
                   MOVZX ECX,DMALen
                   CALL  COMM_DMARead
                   WriteDSP Cmd_PlaybackFreq
                   WriteDSP Freq_22KHz
                   WriteDSP DMA_8bit
                   WriteDSP <BYTE PTR DMALen>
                   WriteDSP <BYTE PTR DMALen+1>
                   RET
SB_Playback        ENDP

SB_Playback2       PROC NEAR
                   DEC   DMALen
                   MOV   AL,B CFG_PrimaryDMA
                   MOV   EBX,DMABuffer
                   MOVZX ECX,DMALen
                   CALL  COMM_DMARead
                   ;WriteDSP Cmd_PlaybackFreq
                   ;WriteDSP Freq_22KHz
                   WriteDSP DMA_8bit
                   WriteDSP <BYTE PTR DMALen>
                   WriteDSP <BYTE PTR DMALen+1>
                   RET
SB_Playback2       ENDP

SB_IRQ             PROC
                   ;CLI
                   PushSegs
                   ReLoadSegs
                   PUSHAD
                   MOV   DX,SBP_DataAvail
                   IN    AL,DX          ; ack irq to blaster

                   CMP   Buffer0Played,FALSE
                   JNZ   @@Here

                   MOV   EAX,Buffer0Abs
                   MOV   DMABuffer,EAX
                   MOV   EAX,Buffer0Len
                   MOV   DMALen,AX
                   MOV   EAX,Buffer1Offset
                   MOV   BufferToMix,EAX
                   MOV   EAX,TickLen
                   MOV   Buffer1Len,EAX
                   JMP   @@Done

@@Here:            MOV   EAX,Buffer1Abs
                   MOV   DMABuffer,EAX
                   MOV   EAX,Buffer1Len
                   MOV   DMALen,AX
                   MOV   EAX,Buffer0Offset
                   MOV   BufferToMix,EAX
                   MOV   EAX,TickLen
                   MOV   Buffer0Len,EAX

@@Done:            CMP   SB_ShutDown,TRUE
                   JZ    @@ShutDown
                   CALL  SB_Playback2
                   CALL  SB_TickHandler
                   NOT   Buffer0Played
@@ShutDown:        MOV   SB_ShutDown,FALSE

                   POPAD
                   PUSH  AX
                   MOV   AL,20H
                   CMP   SB_PIC1,TRUE
                   JNZ   @@pic0
                   OUT   0A0H,AL
@@pic0:            OUT   20H,AL
                   POP   AX
                   PopSegs
                   ;STI
                   IRETD
SB_IRQ             ENDP

SB_IRQInit         PROC  NEAR
                   CLI
                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOVZX EAX,CFG_IRQNumTable[ESI*2]

                   MOV   EBX,O SB_IRQ
                   MOV   CX,CS
                   CALL  COMM_HookIRQ
                   MOV   D OldIRQ,EBX
                   MOV   W OldIRQ+4,CX

                   MOV   SB_PIC1,FALSE
                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOV   BX,CFG_IRQNumTable[ESI*2]
                   CMP   BL,8
                   JB    @@PIC0
                   MOV   SB_PIC1,TRUE
@@PIC0:            MOVZX EBX,BL

                   CALL  GetIRQMasks
                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOV   BX,CFG_IRQMaskTable[ESI*2]
                   NOT   BX
                   AND   AX,BX
                   CALL  SetIRQMasks

                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOVZX EBX,W CFG_IRQNumTable[ESI*2]
                   CALL  EnableCallBack
                   STI

                   MOV   Buffer0Played,TRUE

                   MOV   EAX,Buffer0Offset
                   MOV   BufferToMix,EAX
                   MOV   EAX,TickLen
                   MOV   Buffer0Len,EAX
                   CALL  SB_TickHandler
                   MOV   EAX,Buffer1Offset
                   MOV   BufferToMix,EAX
                   MOV   EAX,TickLen
                   MOV   Buffer1Len,EAX
                   CALL  SB_TickHandler

                   MOV   EAX,Buffer0Abs
                   MOV   DMABuffer,EAX
                   MOV   EAX,Buffer0Len
                   MOV   DMALen,AX
                   CALL  SB_Playback
                   RET
SB_IRQInit         ENDP

SB_IRQDone         PROC  NEAR
                   CALL  SB_SpkOff
                   MOV   SB_ShutDown,TRUE
@@WaitShutDown:    CMP   SB_ShutDown,FALSE
                   JNZ   @@WaitShutDown
                   CLI
                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOVZX EBX,W CFG_IRQNumTable[ESI*2]
                   CALL  DisableCallBack

                   CALL  GetIRQMasks
                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOV   BX,CFG_IRQMaskTable[ESI*2]
                   OR    AX,BX
                   CALL  SetIRQMasks

                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOVZX EAX,CFG_IRQNumTable[ESI*2]
                   MOV   EBX,D OldIRQ
                   MOV   CX,W OldIRQ+4
                   CALL  COMM_HookIRQ
                   STI

                   RET
SB_IRQDone         ENDP

SB_Init            PROC  NEAR
                   PUSHAD
                   CALL  InitBuffers
                   CALL  CreateMulTable
                   IFDEF SND_DOAMP
                   CALL  CreateAmpTable
                   ENDIF
                   CALL  MakeNoteDivs
                   MOV   EAX,SB_SampleMem*1024
                   CALL  malloc
                   MOV   SB_SampleBank,EAX
                   MOV   SB_Mem,EAX

                   MOV   AX,CFG_BasePort
                   CMP   SBP_Base,AX
                   JZ    @@SkipPort
                   ADD   SBP_Base,AX
                   ADD   SBP_Mixer,AX
                   ADD   SBP_Reset,AX
                   ADD   SBP_ReadData,AX
                   ADD   SBP_BufferStatus,AX
                   ADD   SBP_WriteCmdDat,AX
                   ADD   SBP_DataAvail,AX
                   ADD   SBP_DataAvail16,AX
@@SkipPort:
comment #
                   SayLn 'Initializing Blaster'
                   Say   'Port: '
                   MOVZX EAX,CFG_BasePort
                   SayValue EAX
                   Say   ' IRQ: '
                   MOVZX EAX,CFG_PrimaryIRQ
                   MOVZX EAX,W CFG_IRQNumTable[EAX*2]
                   SayDec EAX
                   Say   ' DMA: '
                   MOVZX EAX,CFG_PrimaryDMA
                   SayDec EAX
                   NewLine
#
                   CALL  SB_Reset
                   CALL  SB_SpkOn
                   CALL  IRQ0_Init
                   POPAD
                   RET
SB_Init            ENDP

SB_Done            PROC  NEAR
                   PUSHAD
                   CALL  IRQ0_Done
                   ;CALL  SB_SpkOff

                   MOV   EAX,MulTable
                   CALL  free
                   IFDEF SND_DOAMP
                   MOV   EAX,AmpTable
                   CALL  free
                   ENDIF
                   MOV   EAX,SB_DMABuffer
                   MOV   ECX,3*SB_DMAMax
                   CALL  Lo_Free
                   CALL  COMM_FreeVDS

                   MOV   EAX,SB_SampleBank
                   CALL  free

                   POPAD
                   RET
SB_Done            ENDP

