;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; constants, hardware specific
GUS_TIMERSPEED     EQU 1195
KLOKRATE           EQU 2981250

; gus commands, out them to command port
cm_VoiceMode       EQU 00H
cm_VoiceFreq       EQU 01H
cm_LoopStartHi     EQU 02H
cm_LoopStartLo     EQU 03H
cm_SampleEndHi     EQU 04H
cm_SampleEndLo     EQU 05H
cm_VolRampRate     EQU 06H
cm_VolRampStart    EQU 07H
cm_VolRampEnd      EQU 08H
cm_Volume          EQU 09H
cm_SampleStartHi   EQU 0AH
cm_SampleStartLo   EQU 0BH
cm_Panning         EQU 0CH
cm_VolumeCtrl      EQU 0DH
cm_Voices          EQU 0EH
cm_IRQSource       EQU 0FH
cm_DMACtrl         EQU 41H
cm_DMAAddress      EQU 42H
cm_DRAMAddrLo      EQU 43H
cm_DRAMAddrHi      EQU 44H
cm_TimerCtrl       EQU 45H ; bit 2 - timer enabled ? like adlib or so ?
cm_TIMER1          EQU 46H ; clock rate divisor
cm_TIMER2          EQU 47H
cm_SampleRate      EQU 48H
cm_SampleCtrl      EQU 49H
cm_JoyStick        EQU 4BH
cm_Init            EQU 4CH
; to read some value add 80H to command

; irq status bits  3x6
gi_MIDI_TX_IRQ     EQU 01H
gi_MIDI_RX_IRQ     EQU 02H
gi_TIMER1          EQU 04H
gi_TIMER2          EQU 08H
gi_WAVETABLE       EQU 20H
gi_ENVELOPE        EQU 40H
gi_DMA_TC          EQU 80H

; mixer port bits 2x0
gm_ENABLE_LINE_IN  EQU 1 ; 0 = en
gm_ENABLE_OUTPUT   EQU 2 ; 0 = en
gm_ENABLE_MIC_IN   EQU 4 ; 1 = en
gm_ENABLE_GF1_IRQ  EQU 8 ; 1 = en
gm_ENABLE_MIDI_LOOP EQU 20H ; 1 = en
gm_SELECT_GF1_REG EQU 40H ; 0 = irq latches

; reset control register (4C)
gr_MASTER_RESET    EQU 01H
gr_OUTPUT_ENABLE   EQU 02H
gr_MASTER_IRQ      EQU 04H

; voice control register (0)
gv_VOICE_STOPPED   EQU 01H
gv_STOP_VOICE      EQU 02H
gv_DATA16BIT       EQU 04H
gv_LOOP_ENABLE     EQU 08H
gv_BI_LOOP         EQU 10H
gv_WAVETBL_IRQ     EQU 20H
gv_DIRECTION       EQU 40H
gv_IRQ_PENDING     EQU 80H

;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; hardware specific variables

GLOBAL GUSP_MixCtrl       : WORD
GLOBAL GUSP_TimerCtrl     : WORD
GLOBAL GUSP_TimerData     : WORD
GLOBAL GUSP_IRQCtrl       : WORD
GLOBAL GUSP_MidiCtrl      : WORD
GLOBAL GUSP_MidiData      : WORD
GLOBAL GUSP_ActiveVoice   : WORD
GLOBAL GUSP_Command       : WORD
GLOBAL GUSP_DataLow       : WORD
GLOBAL GUSP_DataHigh      : WORD
GLOBAL GUSP_IRQStatus     : WORD
GLOBAL GUSP_DRAMIO        : WORD

; definitions of gus ports
GUSP_First LABEL WORD
GUSP_MixCtrl       DW   00H
GUSP_TimerCtrl     DW   08H ; ? bit 2
GUSP_TimerData     DW   09H ; ? bit 0
GUSP_IRQCtrl       DW   0BH
GUSP_MidiCtrl      DW   100H
GUSP_MidiData      DW   101H
GUSP_ActiveVoice   DW   102H
GUSP_Command       DW   103H
GUSP_DataLow       DW   104H
GUSP_DataHigh      DW   105H
GUSP_IRQStatus     DW   106H
GUSP_DRAMIO        DW   107H
GUSP_Last LABEL WORD

GLOBAL GUS_NumVoices    : BYTE
GLOBAL GUS_MixImage     : BYTE
GLOBAL GUS_TimerControl : BYTE
GLOBAL GUS_TimerMask    : BYTE

GUS_NumVoices      DB    14 ; well, for now we use only 4 voices
GUS_MixImage       DB    0 ; image of mixer register
GUS_TimerControl   DB    0 ; timer control reg image
GUS_TimerMask      DB    0 ; timer mask reg image
GUS_PIC1           DB    FALSE ; whether irq belongs to pic1 or pic0
Align 4
GUS_Mem            DD    0 ; current address in gus mem
GUS_BPMOVL         DD    0 ; BPM overflow counter
GUS_BPMOVLCMP      DD    0 ; BPM overflow counter compare
GUS_SynOVL         DD    0 ; synchro overflow ctr (50hz)

Include GUSFreq.Inc
Include GUSVol.Inc
Include GUSBPM.Inc

;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; hardware specific functions and macros

GUS_Command        MACRO cmd
                   MOV   DX,GUSP_Command
                   MOV   AL,cmd
                   OUT   DX,AL
                   ENDM

GUS_OutB           MACRO val
                   IFNB <val>
                   MOV  AL,val
                   ENDIF
                   MOV  DX,GUSP_DataHigh
                   OUT  DX,AL
                   ENDM

GUS_OutW           MACRO val
                   IFNB <val>
                   MOV  AX,val
                   ENDIF
                   MOV  DX,GUSP_DataLow
                   OUT  DX,AX
                   ENDM

GUS_InB            MACRO
                   MOV  DX,GUSP_DataHigh
                   IN   AL,DX
                   ENDM

GUS_InW            MACRO val
                   MOV  DX,GUSP_DataLow
                   IN   AX,DX
                   ENDM

GLOBAL GUS_Delay : NEAR
GUS_Delay          PROC  NEAR
                   PUSH  EAX
                   MOV   DX,GUSP_DRAMIO
                   REPT  7
                   IN    AL,DX
                   ENDM
                   POP   EAX
                   RET
GUS_Delay          ENDP

; input AX - gus base port
GLOBAL GUS_Init : NEAR
GUS_Init           PROC  NEAR
; set ports
                   MOV   AX,CFG_BasePort
                   CMP   GUSP_MixCtrl,AX
                   JZ    @@GUSPortsSet
                   MOV   EBX,O GUSP_First
                   MOV   ECX,O GUSP_Last
                   SUB   ECX,EBX
                   SHR   ECX,1
@@AddLp:           ADD   W [EBX],AX
                   ADD   EBX,2
                   LOOP  @@AddLp
@@GUSPortsSet:
                   MOV   GUS_Mem,0
GLOBAL GUS_Reset : NEAR
GUS_Reset:
                   GUS_Command cm_Init
                   GUS_OutB 0
                   MOV   ECX,10

@@Lp1:             CALL  GUS_Delay
                   LOOP  @@Lp1

; release reset
                   GUS_Command cm_Init
                   GUS_OutB gr_MASTER_RESET
                   CALL  GUS_Delay

; clear interrupts
                   GUS_Command cm_DMACtrl
                   GUS_OutB 0
                   GUS_Command cm_TimerCtrl
                   GUS_OutB 0
                   GUS_Command cm_SampleCtrl
                   GUS_OutB 0

;set number of active voices
                   GUS_Command cm_Voices
                   MOV   AL,GUS_NumVoices
                   DEC   AL
                   OR    AL,0C0H
                   GUS_OutB

; clear interrupt on voices
; reading the status ports will clear irqs
                   MOV   DX,GUSP_IRQStatus
                   IN    AL,DX

                   GUS_Command cm_DMACtrl
                   GUS_InB
                   GUS_Command cm_SampleCtrl
                   GUS_InB
                   GUS_Command cm_IRQSource+80H
                   GUS_InB

; now clear all the voices
                   MOVZX ECX,GUS_NumVoices
@@ClearLp:         PUSH  ECX
                   MOV   AL,GUS_NumVoices
                   SUB   AL,CL
                   CALL  GUS_SelectVoice

                   GUS_Command cm_VoiceMode
                   GUS_OutB gv_VOICE_STOPPED OR gv_STOP_VOICE
                   GUS_Command cm_VolumeCtrl
                   GUS_OutB 3 ; the same :)
                   CALL  GUS_Delay

                   GUS_Command cm_VolRampRate
                   GUS_OutB 00111111B

                   MOVZX EAX,GUS_NumVoices
                   SUB   EAX,D [ESP]
                   MOV   AL,DefaultPanning[EAX]
                   CALL  GUS_SetVoicePan

                   POP   ECX
                   LOOP  @@ClearLp

                   GUS_Command cm_Init
                   GUS_OutB 7 ;gr_MASTER_RESET OR gr_OUTPUT_ENABLE OR gr_MASTER_IRQ

                   MOV   GUS_MixImage,0

                   MOV   DX,GUSP_MixCtrl
                   AND   GUS_MixImage,NOT gm_ENABLE_OUTPUT
                   MOV   AL,GUS_MixImage
                   OUT   DX,AL ; speaker on
comment #
                   SayLn 'Initializing UltraSound'
                   Say   'Port: '
                   MOVZX EAX,CFG_BasePort
                   SayValue EAX
                   Say   ' IRQ: '
                   MOVZX EAX,CFG_PrimaryIRQ
                   MOVZX EAX,W CFG_IRQNumTable[EAX*2]
                   SayDec EAX
                   NewLine
#
                   RET
GUS_Init           ENDP

GUS_Done           PROC  NEAR
                   JMP   GUS_Reset
GUS_Done           ENDP

; in al - value
; EBX - gus mem address
GUS_Poke           PROC  NEAR
                   PUSH  EDX
                   PUSH  EAX
                   GUS_Command cm_DRAMAddrLo
                   MOV   EAX,EBX
                   GUS_OutW
                   GUS_Command cm_DRAMAddrHi
                   MOV   EAX,EBX
                   SHR   EAX,16
                   GUS_OutB
                   POP   EAX
                   MOV   DX,GUSP_DRAMIO
                   OUT   DX,AL
                   POP   EDX
                   RET
GUS_Poke           ENDP

; in - ebx gus mem address
; out - al - value
GUS_Peek           PROC  NEAR
                   PUSH  EDX
                   GUS_Command cm_DRAMAddrLo
                   MOV   EAX,EBX
                   GUS_OutW
                   GUS_Command cm_DRAMAddrHi
                   MOV   EAX,EBX
                   SHR   EAX,16
                   GUS_OutB
                   MOV   DX,GUSP_DRAMIO
                   IN    AL,DX
                   POP   EDX
                   RET
GUS_Peek           ENDP

; in ESI - address of sample
;    ECX - length of sample
GUS_StuffSample    PROC  NEAR
                   OR    ECX,ECX
                   JZ    @@druut
                   MOV   EBX,GUS_Mem

@@Lp:              MOV   AL,[ESI]
                   CALL  GUS_Poke
                   INC   ESI
                   INC   EBX
                   LOOP  @@Lp

                   MOV   GUS_Mem,EBX
@@druut:           RET
GUS_StuffSample    ENDP

; in ebx - position
; out ebx - shifted anded and so on position
GUS_Shifter        PROC  NEAR
                   PUSH  EAX
                   MOV   EAX,EBX
                   AND   EAX,7FH ; low
                   SHL   EAX,9
                   SHR   EBX,7
                   AND   EBX,1FFFH ; 13 bits
                   SHL   EBX,16
                   MOV   BX,AX
                   POP   EAX
                   RET
GUS_Shifter        ENDP

; input AL - voice
;       EBX - sample start adr
GUS_SetSampleStart PROC  NEAR
                   PUSH  EAX
                   PUSH  EDX
                   CALL  GUS_Shifter
                   GUS_Command cm_SampleStartLo
                   MOV   AX,BX
                   GUS_OutW
                   GUS_Command cm_SampleStartHi
                   ROL   EBX,16
                   MOV   AX,BX
                   GUS_OutW
                   POP   EDX
                   POP   EAX
                   RET
GUS_SetSampleStart ENDP

; in AL - voice
GUS_GetPos         PROC  NEAR
                   PUSH  EBX
                   PUSH  EDX
                   CALL  GUS_SelectVoice
                   GUS_Command <cm_SampleStartHi + 80H>
                   GUS_InW
                   MOVZX EBX,AX
                   AND   EBX,1FFFH
                   GUS_Command <cm_SampleStartLo + 80H>
                   GUS_InW
                   MOVZX EAX,AX
                   SHR   EAX,9 ; kill fraction
                   SHL   EBX,7
                   OR    EAX,EBX
                   POP   EDX
                   POP   EBX
                   RET
GUS_GetPos         ENDP

; EBX - sample end adr
GUS_SetSampleEnd   PROC  NEAR
                   PUSH  EAX
                   PUSH  EDX
                   CALL  GUS_Shifter
                   GUS_Command cm_SampleEndLo
                   MOV   AX,BX
                   GUS_OutW
                   GUS_Command cm_SampleEndHi
                   ROL   EBX,16
                   MOV   AX,BX
                   GUS_OutW
                   POP   EDX
                   POP   EAX
                   RET
GUS_SetSampleEnd   ENDP

; EBX - sample loop
GUS_SetSampleLoop  PROC  NEAR
                   PUSH  EAX
                   PUSH  EDX
                   CALL  GUS_Shifter
                   GUS_Command cm_LoopStartLo
                   MOV   AX,BX
                   GUS_OutW
                   GUS_Command cm_LoopStartHi
                   ROL   EBX,16
                   MOV   AX,BX
                   GUS_OutW
                   POP   EDX
                   POP   EAX
                   RET
GUS_SetSampleLoop  ENDP

; BL - volume (0 - 64)
GUS_SetVoiceVol    PROC  NEAR
                   PUSH  EAX
                   PUSH  EDX
                   GUS_Command cm_Volume
                   CMP   BL,64
                   JBE   @@VolOK
                   MOV   BL,64
@@VolOK:
                   MOVZX EAX,BL
                   MOV   AX,GUSVolTbl[EAX*2]
                   IFDEF GVOLSHIFT
                   SHL   EAX,4
                   ENDIF
                   GUS_OutW
                   POP   EDX
                   POP   EAX
                   RET
GUS_SetVoiceVol    ENDP

; BX - amiga period
GUS_SetVoicePeriod PROC  NEAR
                   PUSH  EAX
                   PUSH  EDX
                   GUS_Command cm_VoiceFreq
                   MOV   EDX,EBX
                   AND   EBX,0FFFH
                   MOVZX EAX,BX
                   MOV   AX,GusFreqTbl[EAX*2]
                   SHR   EDX,12
                   AND   EDX,0FH
                   MOV   EDX,FineTuneTable[EDX*4]
                   MUL   EDX
                   SHRD  EAX,EDX,24
                   AND   EAX,0FFFEH
                   GUS_OutW
                   POP   EDX
                   POP   EAX
                   RET
GUS_SetVoicePeriod ENDP

; AL - panning value
GUS_SetVoicePan    PROC  NEAR
                   PUSH  EDX
                   PUSH  EAX
                   GUS_Command cm_Panning
                   POP   EAX
                   GUS_OutB
                   POP   EDX
                   RET
GUS_SetVoicePan    ENDP

; AL volume ramp rate control
GUS_SetVolRampRate PROC  NEAR
                   PUSH  EDX
                   PUSH  EAX
                   GUS_Command cm_VolRampRate
                   POP   EAX
                   GUS_OutB
                   POP   EDX
                   RET
GUS_SetVolRampRate ENDP

; AL - voice number
GLOBAL GUS_SelectVoice : NEAR
GUS_SelectVoice    PROC  NEAR
                   PUSH  EAX
                   PUSH  EDX
                   MOV   DX,GUSP_ActiveVoice
                   OUT   DX,AL
                   CALL  GUS_Delay
                   POP   EDX
                   POP   EAX
                   RET
GUS_SelectVoice    ENDP

GUS_PlayVoice      PROC  NEAR
                   GUS_Command cm_VoiceMode+80H
                   GUS_InB
                   AND   AL,NOT (gv_STOP_VOICE OR gv_VOICE_STOPPED OR gv_LOOP_ENABLE)
GUS_PlayVoiceComm: PUSH  EAX
                   GUS_Command cm_VoiceMode
                   POP   EAX
                   GUS_OutB
                   CALL  GUS_Delay
comment #
                   PUSH  EAX
                   GUS_Command cm_VoiceMode
                   POP   EAX
                   GUS_OutB
#
                   RET
GUS_PlayVoice      ENDP

; play looped voice
GUS_PlayVoiceL     PROC  NEAR
                   GUS_Command cm_VoiceMode+80H
                   GUS_InB
                   AND   AL,NOT (gv_STOP_VOICE OR gv_VOICE_STOPPED)
                   OR    AL,gv_LOOP_ENABLE
                   JMP   GUS_PlayVoiceComm
GUS_PlayVoiceL     ENDP

GLOBAL GUS_StopVoice : NEAR
GUS_StopVoice      PROC  NEAR
                   CALL  GUS_IsPlaying
                   JNC   @@druut
                   GUS_Command cm_VoiceMode + 80H
                   GUS_InB
                   AND   AL,NOT (gv_IRQ_PENDING OR gv_LOOP_ENABLE)
                   ;OR    AL,gv_STOP_VOICE OR gv_VOICE_STOPPED
                   OR    AL,gv_STOP_VOICE ;OR gv_VOICE_STOPPED
                   PUSH  EAX
                   GUS_Command cm_VoiceMode
                   POP   EAX
                   PUSH  EAX
                   GUS_OutB
                   CALL  GUS_Delay
                   GUS_Command cm_VoiceMode
                   POP   EAX
                   OR    AL,gv_VOICE_STOPPED
                   GUS_OutB
;@@still:           CALL GUS_IsPlaying
;                   JC   @@still
@@druut:
                   RET
GUS_StopVoice      ENDP

; c = 1 - is playing
GUS_IsPlaying      PROC  NEAR
                   GUS_Command cm_VoiceMode+80H
                   GUS_InB
                   SHR   AL,1
                   CMC
                   RET
GUS_IsPlaying      ENDP

GLOBAL GUS_SetBPM : NEAR
; in BL - BPM (32 - 255)
GUS_SetBPM         PROC  NEAR
                   PUSH  EAX
                   PUSH  EDX
                   CLR   EDX
                   MOV   EAX,KLOKRATE
                   MOVZX EBX,BL
                   DIV   EBX
                   MOV   GUS_BPMOVLCMP,EAX
                   POP   EDX
                   POP   EAX
                   RET
GUS_SetBPM         ENDP

;
;BITS 0 - 2 - gf1 irq  / dram dma
;BITS 3 - 5 - midi irq / adc dma
;BIT 6 = 1 if midi and gf1 the same ?
;BIT 7 = 1 DMA settings
;      = 0 IRQ settings
;
; i dont even try to understand why this is done this way :)
GLOBAL GUS_SetInterface : NEAR
GUS_SetInterface   PROC  NEAR
                   MOVZX EBX,CFG_PrimaryIRQ ; GF1 IRQ
                   MOV   CL,@@IRQTBL[EBX]
                   MOVZX EBX,CFG_SecondaryIRQ ; MIDI IRQ
                   MOV   CH,@@IRQTBL[EBX]
                   CMP   CL,CH
                   JNZ   @@SkipOR
                   OR    CL,40H
@@SkipOR:
                   SHL   CH,3
                   OR    CL,CH

                   MOVZX EBX,CFG_PrimaryDMA  ; DRAM DMA
                   MOV   AL,@@DMATBL[EBX]
                   MOVZX EBX,CFG_SecondaryDMA ; ADC DMA
                   MOV   AH,@@DMATBL[EBX]
                   CMP   AL,AH
                   JNZ   @@SkipOR2
                   OR    AL,40H
@@SkipOR2:
                   SHL   AH,3
                   OR    AH,AL
                   MOV   CH,AH
                   OR    CH,80H ; DMA flag ???
                   ; CH - dma
                   ; CL - irq
; i wonder why everybode does it twice, huh ?
REPT 2
                   MOV   DX,GUSP_MixCtrl
                   MOV   AL,GUS_MixImage
                   OUT   DX,AL
                   MOV   DX,GUSP_IRQCtrl
                   MOV   AL,CH
                   OUT   DX,AL ; set up dma channels

                   MOV   DX,GUSP_MixCtrl
                   MOV   AL,GUS_MixImage
                   OR    AL,40H
                   OUT   DX,AL
                   MOV   DX,GUSP_IRQCtrl
                   MOV   AL,CL
                   OUT   DX,AL ; set up irq levels
ENDM
GLOBAL GUS_EnableIRQs : NEAR
GUS_EnableIRQs:
                   MOV   DX,GUSP_ActiveVoice
                   XOR   AL,AL
                   OUT   DX,AL
; now enable IRQs
                   MOV   DX,GUSP_MixCtrl
                   OR    GUS_MixImage,gm_ENABLE_GF1_IRQ
                   MOV   AL,GUS_MixImage
                   OUT   DX,AL

                   MOV   DX,GUSP_ActiveVoice
                   XOR   AL,AL
                   OUT   DX,AL
                   RET
@@IRQTBL           DB    0,0,1,3,0,2,0,4,0,0,0,5,6,0,0,7
                        ;0 1 2 3 4 5 6 7
@@DMATBL           DB    0,1,0,2,0,3,4,5
GUS_SetInterface   ENDP

GUS_DisableIRQs    PROC  NEAR
                   MOV   DX,GUSP_ActiveVoice
                   XOR   AL,AL
                   OUT   DX,AL
; now disable IRQs
                   MOV   DX,GUSP_MixCtrl
                   AND   GUS_MixImage,NOT gm_ENABLE_GF1_IRQ
                   MOV   AL,GUS_MixImage
                   OUT   DX,AL

                   MOV   DX,GUSP_ActiveVoice
                   XOR   AL,AL
                   OUT   DX,AL
                   RET
GUS_DisableIRQs    ENDP

GUS_IRQ            PROC  NEAR
                   CLI
                   PushSegs
                   ReLoadSegs
                   PUSHAD

                   ADD   GUS_BPMOVL,GUS_TIMERSPEED
                   MOV   EAX,GUS_BPMOVLCMP
                   CMP   EAX,GUS_BPMOVL
                   JG    @@NoTimer1
                   SUB   GUS_BPMOVL,EAX
                   CMP   ModPlaying,TRUE
                   JNZ   @@NoTimer1
                   CALL  GUS_TickHandler
@@NoTimer1:
                   POPAD
                   PUSH  EAX
; now synchronization stuff
                   CMP   DBG_InDebug,0
                   JNZ   @@Idruut

                   ADD   GUS_SynOVL,GUS_TIMERSPEED
                   CMP   GUS_SynOVL,COMM_TIMERSPEED
                   JL    @@Idruut
                   SUB   GUS_SynOVL,COMM_TIMERSPEED

                   INC   TotalTickCnt
                   INC   TickCnt
                   CMP   CountDown,0
                   JZ    @@PBTest
                   DEC   CountDown
@@PBTest:
; 1/50 sec, gus playback routine
                   CMP   PlaybackON,TRUE
                   JNZ   @@Idruut
                   PUSHAD
                   CALL  GUS_Playback
                   POPAD
@@Idruut:
                   ADD   OverFlowCtr,GUS_TIMERSPEED
                   JC    @@daJump
                   MOV   AL,20H
                   OUT   20H,AL
                   POP   EAX
                   PopSegs
                   STI
                   IRETD
@@daJump:
                   POP   EAX
                   PopSegs
                   STI
                   JMP   FWORD PTR CS:OldIRQ
GUS_IRQ            ENDP

GUS_IRQInit        PROC  NEAR
                   CLI
                   MOV   AL,0
                   MOV   EBX,O GUS_IRQ
                   MOV   CX,CS
                   CALL  COMM_HookIRQ
                   MOV   D OldIRQ,EBX
                   MOV   W OldIRQ+4,CX

                   CALL  GetIRQMasks
                   AND   AX,NOT 1
                   CALL  SetIRQMasks

                   MOV   AL,36H
                   OUT   43H,AL
                   MOV   AX,GUS_TIMERSPEED ; to get 1000Hz
                   OUT   40H,AL
                   MOV   AL,AH
                   IOWait
                   OUT   40H,AL

                   CLR   EBX
                   CALL  EnableCallBack

                   MOV   BL,125
                   CALL  GUS_SetBPM
                   STI
                   RET
GUS_IRQInit        ENDP

GUS_IRQDone        PROC  NEAR
                   CLI
                   CLR   EBX
                   CALL  DisableCallBack

                   MOV   AL,36H
                   OUT   43H,AL
                   XOR   AL,AL
                   OUT   40H,AL
                   IOWait
                   OUT   40H,AL

                   MOV   AL,0
                   MOV   EBX,D OldIRQ
                   MOV   CX,W OldIRQ+4
                   CALL  COMM_HookIRQ
                   STI

                   RET
GUS_IRQDone        ENDP

