__NOCARD           EQU  0
__BLASTER          EQU  1
__BLASTERPRO       EQU  2
__BLASTER16        EQU  3
__GUS              EQU  4

CFG_SoundCard      DW   0
; 0 - none
; 1 - sound blaster
; 2 - sound blaster pro
; 3 - sound blaster 16
; 4 - gravis ultrasound
CFG_BasePort       DW   ?
CFG_PrimaryIRQ     DW   ?
CFG_PrimaryDMA     DW   1
CFG_SecondaryIRQ   DW   4
CFG_SecondaryDMA   DW   5

CFG_IRQMaskTable   DW   1         ; IRQ 0
                   DW   2         ; IRQ 1
                   DW   4+512     ; IRQ 2/9
                   DW   8         ; IRQ 3
                   DW   16        ; IRQ 4
                   DW   32        ; IRQ 5
                   DW   64        ; IRQ 6
                   DW   128       ; IRQ 7
                   DW   4+256     ; IRQ 8
                   DW   4+512     ; IRQ 2/9
                   DW   4+1024    ; IRQ 10
                   DW   4+2048    ; IRQ 11
                   DW   4+4096    ; IRQ 12
                   DW   4+8192    ; IRQ 13
                   DW   4+16384   ; IRQ 14
                   DW   4+32768   ; IRQ 15
CFG_IRQNumTable    DW   0,1,9,3,4,5,6,7,8,9,10,11,12,13,14,15

comment #
 in
 ESI - data
 AL - line
 AH - lines
 out
 AL - selection
#
CFG_Selector       PROC  NEAR
                   MOV   @@selection,0
                   MOV   @@startline,AL
                   ADD   @@startline,2
                   MOV   @@maxline,AH
                   MOVZX EAX,AL
                   IMUL  EAX,160
                   IFDEF __DLL
                   PUSH  EBX
                   GetVar EBX,CursorPtr
                   MOV   D [EBX],EAX
                   POP   EBX
                   ELSE
                   MOV   CursorPtr,EAX
                   ENDIF
                   CALL  DisplayNullString
                   IFDEF __DLL
                   PUSH  EBX
                   GetVar EBX,CursorPtr
                   MOV   D [EBX],25*160
                   POP   EBX
                   ELSE
                   MOV   CursorPtr,25*160
                   ENDIF
                   CALL  DisplayCursor ; hide cursor

@@lp:              CALL  @@hilite
                   CALL  Kbd_Get
                   PUSH  EAX
                   CALL  @@delite
                   POP   EAX
                   CMP   AX,1C0DH ; enter
                   JZ    @@done
                   CMP   AX,3920H ; space
                   JZ    @@done
                   CMP   AX,4800H ; up
                   JNZ   @@s1
                   MOV   AL,@@selection
                   DEC   AL
                   CMP   AL,0FFH
                   JNZ   @@store
                   MOV   AL,@@maxline
                   DEC   AL
                   JMP   @@store

@@s1:              CMP   AX,5000H ; down
                   JNZ   @@lp
                   MOV   AL,@@selection
                   INC   AL
                   CMP   AL,@@maxline
                   JNZ   @@store
                   CLR   AL

@@store:           MOV   @@selection,AL
                   JMP   @@lp

@@done:            MOVZX EAX,@@selection
                   RET

@@hilite:          MOVZX EAX,@@startline
                   ADD   AL,@@selection
                   IMUL  EAX,160
                   IFDEF __DLL
                   GetVar ESI,SegB800
                   MOV   ESI,D [ESI]
                   ELSE
                   MOV   ESI,SegB800
                   ENDIF
                   ADD   ESI,EAX
                   MOV   ECX,41
@@hl:              MOV   B [ESI+1],1FH
                   ADD   ESI,2
                   LOOP  @@hl
                   RET

@@delite:          MOVZX EAX,@@startline
                   ADD   AL,@@selection
                   IMUL  EAX,160
                   IFDEF __DLL
                   GetVar ESI,SegB800
                   MOV   ESI,D [ESI]
                   ELSE
                   MOV   ESI,SegB800
                   ENDIF
                   ADD   ESI,EAX
                   MOV   ECX,41
@@de:              MOV   B [ESI+1],07H
                   ADD   ESI,2
                   LOOP  @@de
                   RET

@@startline        DB    ?
@@maxline          DB    ?
@@selection        DB    ?
CFG_Selector       ENDP

CFG_Ask            PROC  NEAR
@@mainlp:          CALL  @@header
                   SayLn ' Current settings '
                   SayLn ''
                   CALL  CFG_DisplayConfig

                   MOV   EAX,040AH
                   MOV   ESI,O @@mainoptions
                   CALL  CFG_Selector
                   CMP   AL,3
                   JZ    @@done
                   CMP   AL,2
                   JZ    @@verify
                   CMP   AL,1
                   JZ    @@auto
                   CMP   AL,0
                   JZ    @@select
                   JMP   @@mainlp

;--------------------------------------------------------------------
@@verify:          CALL  @@header
                   CALL  CFG_Verify
                   JC    @@vrbad
                   SayLn 'Sound card settings verified OK.'
                   JMP   @@vrcom
@@vrbad:           SayLn 'Sound card settings verification failed!'
@@vrcom:           SayLn 'Press any key.'
                   CALL  Kbd_Get
                   JMP   @@mainlp
;--------------------------------------------------------------------
@@select:          CALL  @@header
                   MOV   EAX,050AH
                   MOV   ESI,O @@soundcards
                   CALL  CFG_Selector
                   MOV   CFG_SoundCard,AX
                   OR    EAX,EAX
                   JZ    @@mainlp

                   CALL  @@header
                   MOV   EAX,070AH
                   MOV   ESI,O @@baseport
                   CALL  CFG_Selector
                   SHL   EAX,4
                   ADD   EAX,200H
                   MOV   CFG_BasePort,AX

                   MOV   CFG_SecondaryIRQ,-1
                   CMP   CFG_SoundCard,__GUS
                   JZ    @@gus

                   CALL  @@header
                   MOV   EAX,050AH
                   MOV   ESI,O @@sbirq
                   CALL  CFG_Selector
                   MOVZX EAX,B @@sbirqtab[EAX]
                   MOV   CFG_PrimaryIRQ,AX

                   CALL  @@header
                   MOV   EAX,030AH
                   MOV   ESI,O @@lowdma
                   CALL  CFG_Selector
                   MOVZX EAX,B @@lowdmatab[EAX]
                   MOV   CFG_PrimaryDMA,AX

                   CMP   CFG_SoundCard,__BLASTER16
                   JNZ   @@mainlp

                   CALL  @@header
                   MOV   EAX,030AH
                   MOV   ESI,O @@highdma
                   CALL  CFG_Selector
                   MOVZX EAX,B @@highdmatab[EAX]
                   MOV   CFG_SecondaryDMA,AX
                   JMP   @@mainlp

@@gus:             MOV   CFG_PrimaryDMA,-1
                   MOV   CFG_SecondaryDMA,-1
                   MOV   CFG_PrimaryIRQ,-1
                   MOV   CFG_SecondaryIRQ,-1
                   ;CALL  @@header
                   ;MOV   EAX,070AH
                   ;MOV   ESI,O @@gusirq
                   ;CALL  CFG_Selector
                   ;MOVZX EAX,B @@gusirqtab[EAX]
                   ;MOV   CFG_PrimaryIRQ,AX
                   JMP   @@mainlp
;--------------------------------------------------------------------
@@auto:            CALL  CFG_Auto
                   JMP   @@mainlp

@@done:            CALL  KlearTextScreen
                   RET

@@header:          CALL  KlearTextScreen
                   SayLn ' Sound card setup'
                   SayLn ''
                   RET
@@mainoptions      DB    ' Your options',CRLF
                   DB    '',CRLF
                   DB    ' Select sound card settings',CRLF
                   DB    ' Detect sound card',CRLF
                   DB    ' Verify settings',CRLF
                   DB    ' Accept settings',CRLF
                   DB    '',CRLF
                   DB    0

@@soundcards       DB    ' Available sound cards',CRLF
                   DB    '',CRLF
                   DB    ' No sound',CRLF
                   DB    ' Sound Blaster',CRLF
                   DB    ' Sound Blaster Pro',CRLF
                   DB    ' Sound Blaster 16',CRLF
                   DB    ' Gravis UltraSound',CRLF
                   DB    '',CRLF
                   DB    0

@@sbirqtab         DB    9,3,5,7,10
@@sbirq            DB    ' Possible IRQ levels',CRLF
                   DB    '',CRLF
                   DB    ' IRQ 2 (9)',CRLF
                   DB    ' IRQ 3',CRLF
                   DB    ' IRQ 5',CRLF
                   DB    ' IRQ 7',CRLF
                   DB    ' IRQ 10',CRLF
                   DB    '',CRLF
                   DB    0

@@gusirqtab        DB    9,3,5,7,11,12,15
@@gusirq           DB    ' Possible IRQ levels',CRLF
                   DB    '',CRLF
                   DB    ' IRQ 2 (9)',CRLF
                   DB    ' IRQ 3',CRLF
                   DB    ' IRQ 5',CRLF
                   DB    ' IRQ 7',CRLF
                   DB    ' IRQ 11',CRLF
                   DB    ' IRQ 12',CRLF
                   DB    ' IRQ 15',CRLF
                   DB    '',CRLF
                   DB    0

@@baseport         DB    ' Base port address',CRLF
                   DB    '',CRLF
                   DB    ' 200H',CRLF
                   DB    ' 210H',CRLF
                   DB    ' 220H',CRLF
                   DB    ' 230H',CRLF
                   DB    ' 240H',CRLF
                   DB    ' 250H',CRLF
                   DB    ' 260H',CRLF
                   DB    '',CRLF
                   DB    0

@@lowdmatab        DB    0,1,3
@@lowdma           DB    ' DMA Channel      ',CRLF
                   DB    '',CRLF
                   DB    ' DMA Channel 0',CRLF
                   DB    ' DMA Channel 1',CRLF
                   DB    ' DMA Channel 3',CRLF
                   DB    '',CRLF
                   DB    0

@@highdmatab       DB    5,6,7
@@highdma          DB    ' High DMA Channel      ',CRLF
                   DB    '',CRLF
                   DB    ' DMA Channel 5',CRLF
                   DB    ' DMA Channel 6',CRLF
                   DB    ' DMA Channel 7',CRLF
                   DB    '',CRLF
                   DB    0

CFG_Ask            ENDP

CFG_NoCard         DB    'No sound card',0
CFG_Blaster        DB    'Sound Blaster',0
CFG_BlasterPro     DB    'Sound Blaster Pro',0
CFG_Blaster16      DB    'Sound Blaster 16',0
CFG_GUS            DB    'Gravis UltraSound',0
                   DB    0
CFG_Cards          DD    O CFG_NoCard,O CFG_Blaster,O CFG_BlasterPro
                   DD    O CFG_Blaster16,O CFG_GUS

CFG_DisplayConfig  PROC  NEAR
                   Say   ' Card type: '
                   MOVZX EAX,CFG_SoundCard
                   MOV   ESI,CFG_Cards[EAX*4]
                   CALL  DisplayNullString
                   NewLine
                   OR    EAX,EAX
                   JZ    @@druut
                   Say   ' Base port: '
                   MOVZX EAX,CFG_BasePort
                   CALL  DisplayEAX
                   MOV   AL,'H'
                   CALL  DisplayChar
                   NewLine
                   CMP   CFG_SoundCard,__GUS
                   JZ    @@druut
                   Say   ' IRQ Level: '
                   MOVSX EAX,CFG_PrimaryIRQ
                   CALL  DisplayEAXDec
                   NewLine
                   Say   ' DMA Channel: '
                   MOVSX EAX,CFG_PrimaryDMA
                   CALL  DisplayEAXDec
                   NewLine
                   CMP   CFG_SoundCard,__BLASTER16
                   JNZ   @@druut
                   Say   ' Secondary DMA Channel: '
                   MOVSX EAX,CFG_SecondaryDMA
                   CALL  DisplayEAXDec
                   NewLine
@@druut:
                   RET
CFG_DisplayConfig  ENDP

CFG_Auto           PROC  NEAR
                   MOV   EBX,O @@ultra
                   CALL  @@searchenvstr
                   JNC   @@gogus
                   MOV   EBX,O @@blaster
                   CALL  @@searchenvstr
                   JNC   @@goblast
                   STC
                   RET

@@gogus:           MOV   CFG_SoundCard,__GUS
                   CALL  @@getdec ; base port
                   SUB   EAX,200
                   CLR   EDX
                   MOV   EBX,10
                   DIV   EBX
                   SHL   EAX,4
                   ADD   EAX,200H
                   MOV   CFG_BasePort,AX
                   INC   ESI ; skip ,
                   CALL  @@getdec ; primary dma
                   MOV   CFG_PrimaryDMA,AX
                   INC   ESI ; skip ,
                   CALL  @@getdec ; secondary dma
                   MOV   CFG_SecondaryDMA,AX
                   INC   ESI ; skip ,
                   CALL  @@getdec ; primary IRQ
                   MOV   CFG_PrimaryIRQ,AX
                   INC   ESI ; skip ,
                   CALL  @@getdec ; secondary IRQ
                   MOV   CFG_SecondaryIRQ,AX
                   RET

@@findlet:         ; AL - letter
                   MOV   ESI,EBX
@@fllp:            MOV   AH,GS:[ESI]
                   INC   ESI
                   CMP   AH,'a'
                   JB    @@upskip
                   CMP   AH,'z'
                   JA    @@upskip
                   SUB   AH,20H
@@upskip:          CMP   AL,AH
                   JZ    @@lfound
                   OR    AH,AH
                   JNZ   @@fllp
                   STC
                   RET
@@lfound:          CLC
                   RET

@@goblast:         MOV   EBX,ESI
                   ; type
                   MOV   AL,'T'
                   CALL  @@findlet
                   JC    @@badblast
                   CALL  @@getdec
                   OR    EAX,EAX
                   JZ    @@badblast
                   CMP   EAX,6
                   JA    @@badblast
                   MOV   AL,@@typetype[EAX]
                   MOV   CFG_SoundCard,AX
; address
                   MOV   AL,'A'
                   CALL  @@findlet
                   JC    @@badblast
                   CALL  @@getdec
                   SUB   EAX,200
                   CLR   EDX
                   MOV   ECX,10
                   DIV   ECX
                   SHL   EAX,4
                   ADD   EAX,200H
                   MOV   CFG_BasePort,AX
; irq
                   MOV   AL,'I'
                   CALL  @@findlet
                   JC    @@badblast
                   CALL  @@getdec
                   MOV   CFG_PrimaryIRQ,AX
; low dma
                   MOV   AL,'D'
                   CALL  @@findlet
                   JC    @@badblast
                   CALL  @@getdec
                   MOV   CFG_PrimaryDMA,AX

                   CMP   CFG_SoundCard,__BLASTER16
                   JNZ   @@nohighdma
; high dma
                   MOV   AL,'H'
                   CALL  @@findlet
                   JC    @@badblast
                   CALL  @@getdec
                   MOV   CFG_SecondaryDMA,AX

@@nohighdma:
                   RET
@@badblast:        MOV   CFG_SoundCard,__NOCARD
                   RET

                         ;1.x,pro,2.0,pro2,promcv,16
@@typetype         DB    __NOCARD
                   DB    __BLASTER
                   DB    __BLASTERPRO
                   DB    __BLASTER
                   DB    __BLASTERPRO
                   DB    __BLASTERPRO
                   DB    __BLASTER16

@@getdec:          CLR   EAX
@@gdlp:            MOV   DL,GS:[ESI]
                   CMP   DL,'9'
                   JA    @@gddone
                   SUB   DL,'0'
                   JB    @@gddone
                   INC   ESI
                   ADD   EAX,EAX
                   LEA   EAX,[EAX*4+EAX]
                   MOVZX EDX,DL
                   ADD   EAX,EDX
                   JMP   @@gdlp
@@gddone:
                   RET

; in: ebx -> string to find
@@searchenvstr:
                   IFDEF __DLL
                   GetVar ESI,EnvBase
                   MOV   ESI,D [ESI]
                   ELSE
                   MOV   ESI,EnvBase
                   ENDIF
                   MOV   EDX,EBX
@@searchlp:        MOV   EBX,EDX
                   CMP   B GS:[ESI],0
                   STC
                   JZ    @@srchdone
@@cmplp:           MOV   AL,[EBX]
                   INC   EBX
                   CMP   AL,GS:[ESI]
                   JNZ   @@skiptoz
                   INC   ESI
                   CMP   AL,'='
                   JZ    @@found
                   JMP   @@cmplp
@@skiptoz:         MOV   AL,GS:[ESI]
                   INC   ESI
                   OR    AL,AL
                   JZ    @@searchlp
                   JMP   @@skiptoz
@@found:
                   CLC
@@srchdone:
                   RET
@@blaster          DB    'BLASTER='
@@ultra            DB    'ULTRASND='
CFG_Auto           ENDP

CFG_VerifySB       PROC  NEAR

@@DSPDataAvail     MACRO
                   LOCAL NotReady
                   MOV   DX,CFG_BasePort
                   ADD   DX,0EH
NotReady:          IN    AL,DX
                   TEST  AL,80H
                   JZ    NotReady
                   ENDM

@@DSPRead          MACRO
                   @@DSPDataAvail
                   MOV   DX,CFG_BasePort
                   ADD   DX,0AH
                   IN    AL,DX
                   ENDM

@@DSPWriteStatus   MACRO
                   LOCAL NotReady
                   MOV   DX,CFG_BasePort
                   ADD   DX,0CH
NotReady:          IN    AL,DX
                   TEST  AL,80H
                   JNZ   NotReady
                   ENDM

@@DSPWrite         MACRO what
                   IFNB <what>
                   MOV  AH,what
                   ELSE
                   MOV  AH,AL
                   ENDIF
                   @@DSPWriteStatus
                   MOV  AL,AH
                   OUT  DX,AL
                   ENDM

; reset
                   MOV   DX,CFG_BasePort
                   ADD   DX,6
                   MOV   AL,1
                   OUT   DX,AL

                   MOV   ECX,1000
@@delay1:          IN    AL,80H
                   LOOP  @@delay1

                   MOV   DX,CFG_BasePort
                   ADD   DX,6
                   MOV   AL,00H
                   OUT   DX,AL

                   MOV   ECX,1000
@@delay2:          IN    AL,80H
                   LOOP  @@delay2

                   MOV   DX,CFG_BasePort
                   ADD   DX,0EH
                   MOV   ECX,2000
@@WAIT2:           IN    AL,DX
                   TEST  AL,80H
                   JNZ   @@DoRead
                   LOOP  @@WAIT2
                   JMP   @@badexit ; couldnt wait too long
@@DoRead:          MOV   DX,CFG_BasePort
                   ADD   DX,0AH
                   IN    AL,DX
                   CMP   AL,0AAH
                   JNZ   @@badexit
                   @@DSPWrite 0E1H ; dsp version
                   @@DSPRead
                   MOV   BL,AL
                   @@DSPRead
                   MOVZX EAX,AL
                   MOV   AH,BL
                   CLC
@@druut:           RET
@@badexit:         CLR   EAX
                   STC
                   JMP   SHORT @@druut
CFG_VerifySB       ENDP

CFG_VerifyGUS      PROC  NEAR
                   CLC
                   RET
CFG_VerifyGUS      ENDP

CFG_Verify         PROC  NEAR
                   CMP   CFG_SoundCard,__NOCARD
                   CLC
                   JZ    @@druut
                   CMP   CFG_SoundCard,__GUS
                   JNZ   @@blast
                   CALL  CFG_VerifyGUS
                   JMP   @@druut
@@blast:           CALL  CFG_VerifySB
                   JC    @@druut
                   MOVZX EBX,AH
                   MOVZX EBX,B @@dsptype[EBX]
                   CMP   BX,CFG_SoundCard ; readed DSP must be equal or better than selected
                   JAE   @@good
                   STC
                   JMP   @@druut
@@good:            CLC
@@druut:
                   RET
@@dsptype          DB    __NOCARD  ; no sound card
                   DB    __BLASTER ; dsp 1.xx
                   DB    __BLASTER ; dsp 2.xx
                   DB    __BLASTERPRO ; dsp 3.xx
                   DB    __BLASTER16  ; dsp 4.xx
                   DB    __BLASTER16  ; ++++++
                   DB    __BLASTER16  ;
                   DB    __BLASTER16  ;
CFG_Verify         ENDP
