;******************************************************************************
; Filename: ISTYPE.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1994.09.19
;  Updated: 1995.03.12
;******************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;******************************************************************************
; Functions included in this file:
;
; Function: ULONG @isdigit(CHAR chr)
;  Comment: Returns a nonzero value if 'chr' is a digit.
;    Input: Al - chr
;  Returns: nonzero value if 'chr' is an digit
;
; Function: ULONG @isxdigit(CHAR chr)
;  Comment: Returns a nonzero value if 'chr' is a hex digit.
;    Input: Al - chr
;  Returns: nonzero value if 'chr' is an hex digit
;
; Function: ULONG @isalpha(CHAR chr)
;  Comment: Returns a nonzero value if 'chr' is a letter.
;    Input: Al - chr
;  Returns: nonzero value if 'chr' is a letter
;
; Function: ULONG @islower(CHAR chr)
;  Comment: Returns a nonzero value if 'chr' is a lowercase letter.
;    Input: Al - chr
;  Returns: nonzero value if 'chr' is a lowercase letter
;
; Function: ULONG @isupper(CHAR chr)
;  Comment: Returns a nonzero value if 'chr' is an uppercase letter.
;    Input: Al - chr
;  Returns: nonzero value if 'chr' is an uppercase letter
;
; Function: ULONG @isalnum(CHAR chr)
;  Comment: Returns a nonzero value if 'chr' is a letter or a digit.
;    Input: Al - chr
;  Returns: nonzero value if 'chr' is a letter or a digit.
;
; Function: ULONG @iscntrl(CHAR chr)
;  Comment: Returns a nonzero value if 'chr' is a control character (0x00
;           to 0x1F and 0x7F).
;    Input: Al - chr
;  Returns: nonzero value if 'chr' is a control character
;
; Function: ULONG @isspace(CHAR chr)
;  Comment: Returns a nonzero value if 'chr' is a space character (0x09 to
;           0x0D and 0x20).
;    Input: Al - chr
;  Returns: nonzero value if 'chr' is a space character
;
; Function: ULONG @ispunct(CHAR chr)
;  Comment: Returns a nonzero value if 'chr' is a punctuation character
;           (0x00 to 0x20 and 07F).
;    Input: Al - chr
;  Returns: nonzero value if 'chr' is a punctuation character
;
; Function: ULONG @isascii(CHAR chr)
;  Comment: Returns a nonzero value if 'chr' is an ascii character (0x00 to
;           0x7Fh).
;    Input: Al - chr
;  Returns: nonzero value if 'chr' is an ascii character
;
; Function: ULONG @isprint(CHAR chr)
;  Comment: Returns a nonzero value if 'chr' is a printable character (0x20 to
;           0x7Eh).
;    Input: Al - chr
;  Returns: nonzero value if 'chr' is a printable character
;******************************************************************************

        Include STDDEF.INC

        Codeseg

TD = 001h               ; TYPE DIGIT               ("0"-"9")
TL = 002h               ; TYPE LOWERCASE CHARACTER ("a"-"z")
TU = 004h               ; TYPE UPPERCASE CHARACTER ("A"-"Z")
TP = 008h               ; TYPE PRINTABLE CHARACTER (20h-7Eh)
TC = 010h               ; TYPE CONTROL CHARACTER   (00h-1Fh+7Eh)
TS = 020h               ; TYPE SPACE CHARACTER     (09h-0Dh+20h)
TH = 040h               ; TYPE HEX DIGIT (with TD) ("a"-"f","A-F")
TUH = TU+TH             ; Upper case HEX
TLH = TL+TH             ; Lower case HEX

Proc    isascii ,1
                Cmp     Al,80h
                Sbb     Eax,Eax
                Ret
Endp

        Align   4

Proc    isalpha ,1
                And     Eax,255
                Mov     Al,[Eax+TypeTable]
                And     Al,TL+TU
                Ret
Endp

        Align   4

Proc    islower ,1
                And     Eax,255
                Mov     Al,[Eax+TypeTable]
                And     Al,TL
                Ret
Endp

        Align   4

Proc    isupper ,1
                And     Eax,255
                Mov     Al,[Eax+TypeTable]
                And     Al,TU
                Ret
Endp

        Align   4

Proc    isdigit ,1
                And     Eax,255
                Mov     Al,[Eax+TypeTable]
                And     Al,TD
                Ret
Endp

        Align   4

Proc    isxdigit ,1
                And     Eax,255
                Mov     Al,[Eax+TypeTable]
                And     Al,TD or TLH or TUH
                Ret
Endp

        Align   4

Proc    isalnum ,1
                And     Eax,255
                Mov     Al,[Eax+TypeTable]
                And     Al,TD+TL+TU
                Ret
Endp

        Align   4

Proc    isspace ,1
                And     Eax,255
                Mov     Al,[Eax+TypeTable]
                And     Al,TS
                Ret
Endp

        Align   4

Proc    ispunct ,1
                And     Eax,255
                Mov     Al,[Eax+TypeTable]
                And     Al,TS+TC
                Ret
Endp

        Align   4

Proc    isprint ,1
                And     Eax,255
                Mov     Al,[Eax+TypeTable]
                And     Al,TP
                Ret
Endp


        Align   4

Proc    iscntrl ,1
                And     Eax,255
                Mov     Al,[Eax+TypeTable]
                And     Al,TC
                Ret
Endp

        Dataseg

        Include "ISTYPE.INC"

        End
