;****************************************************************************
; Filename: MEMCPY.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.09.12
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: PVOID @memcmp(PVOID dest,PVOID source,ULONG length);
;    Input: Eax, dest - pointer to destination memory
;           Edx, source - pointer to source string memory
;           Ecx, length - number of bytes to compare
;   Output: 0 if dest = source,  -1 if dest < source, + 1 if dest > source
;  Comment: Compares memory blocks <source> and <dest>
;****************************************************************************

        Include STDDEF.INC

        Codeseg

Proc    memcmp  ,3
                Push    Ebx
                Clear   Ebx
                Jecxz   @@Exit01
        Align   4
@@Loop01:
                Mov     Bl,[Eax]
                Sub     Bl,[Edx]
                Jnz     @@Exit01
                Inc     Edx
                Inc     Eax
                Dec     Ecx
                Jnz     @@Loop01
@@Exit01:       Movsx   Eax,Bl
                Pop     Ebx
                Ret
Endp


        End
