; _GetCHR      campiona da schermo una matrice 8x8 per il carattere n
; _PutString   stampa una stringa asciiz
; _PutHex      stampa un hex a 32bit (8 cifre)
;              n.b. con questo e' possibile anche stampare un numero BCD
; _CHRFNT indirizzo base del font di caratteri installato

; WARNING! This assembler code is highly interleaved to get the max
; from 486 and Pentium processors while running quite fast on good ol' 386
; to better understand this code
; remember: REGISTERS are used as variables, so follow what happens to every
;           register.
;           Usually i interleave TWO sequences into one, skip one instruction
;           and you get the usual sequence everyone can understand.
;           I not optimized sequences that clashes with bottlenecks OUTSIDE
;           the processor (i.e. memory access), my main target is keep the most
;           accessed stuff into registers and process things at 32bit.

       .386P
       
code32 segment para public use32
       assume cs:code32,ds:code32
       
include 386power.inc       
include 386video.inc


; MODULO Per I/O Character oriented
;
        align dword
        ; pointer to current character font bitmaps
        public _CHRFNT
_CHRFNT dd 0 
        align byte
       
         public _GetCHR
_GetCHR:
         ; copia da RAM VIDEO sul BUFFER dei caratteri
         ; una matrice 
         ; esi = screen base offset
         ; edi = character bitmap index
         ; eax = x position in pixels
         ; edx = y position in pixels
        pushad
        and edi,127
        add esi,eax
        shl edi,CHARSHIFT
        add esi,[edx*4+_RowStart]
        add edi,_CHRFNT
        mov ecx,8
chanplane:        
        movsd
        movsd
        add esi,(PXWIDTH-8)
        loop chanplane
        popad
	ret

SPUTS macro
        movsd
        movsd
        add edi,(PXWIDTH-8)
        endm

        public _PutString

_PutString:
         ; edi = screen base
         ; eax = x in pixels
         ; edx = y in pixels
         ; ebx = string
         
         pushad
         add edi,eax
         add edi,[edx*4+_RowStart]
         jmp @czero
@bliit:  inc ebx
         shl esi,CHARSHIFT
         add esi,_CHRFNT
         mov ecx,8
LUPPALO:         
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         movsd
         movsd
         sub edi,(PXWIDTH*7)
@czero:         
         movsx esi,byte ptr [ebx]
         cmp esi,0
         jne @bliit
         
         popad
	 ret



        public _PutHex

_PutHex: ; scrive il numero BCD a 32 bit
         ; contenuto in ebx
         ; edi = screen dest
         ; eax = x in pixels
         ; edx = y in pixels
         ; ebx = number to write
         pushad
         add edi,eax
         add edi,[edx*4+_RowStart]
         mov ecx,8
         add edi,8*7
         mov esi,ebx
@ngnchar:
         and esi,0Fh
         shr ebx,4
         cmp esi,10
         jb  @isdec
         add esi,(65-48-10) ; 'A' - '0' - 10
@isdec:   
         push ecx
         add esi,48 ; '0' == 48
         shl esi,CHARSHIFT
         mov ebp,0
         add esi,_CHRFNT
SLUPPALO:         
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         movsd
         movsd
         sub edi,(PXWIDTH*7)+8+8
         pop ecx
         mov esi,ebx
         dec ecx
         jnz @ngnchar
         popad
	 ret
         
         public _GetString
_GetString:
        ; edi= scr dest
        ; eax= x in pixels
        ; edx= y in pixels
        ; ecx= max. string size
        ; ebx= string
        pushad
        call _InstallDKB
        mov byte ptr [edi],0
        mov ebp,0
        pushad                 ; fill stringz with space characters
        mov al,32 ; space      ;
        mov edi,ebx            ;
        ; ecx already loaded   ;
        dec ecx                ;
        rep stosb              ;
        mov byte ptr [edi],0   ;
        popad                  ;
        call _PutString
showit:        
        push eax
retry:        
        mov al,21h     ; get a key thru dos
        mov V86ah,06   ;
        mov V86dl,0FFh ;
        int 33h        ;
        jz retry       ;
        mov al,V86al   ;
        cmp al,00      ;
        je skipex      ;
        
        cmp al,8 ;BACKSPACE?
        jne nodel
        cmp ebp,0
        je zerobuf
        dec ebp
zerobuf:        
        mov byte ptr [ebx+ebp],32
        jmp short nukey
nodel:  cmp al,13 ;ENTER?
        je gotstring
        mov [ebx+ebp],al
        inc ebp
nukey:
        pop eax
        call _PutString
        cmp ebp,ecx
        jne showit
stringout:        
        mov byte ptr [ebx+ebp],0
        call _InstallOKB
        popad
        ret
gotstring:
        pop eax
        jmp short stringout        
skipex:
        mov al,21h     ; get the extended key thru dos & discard it
        mov V86ah,06   ;
        mov V86dl,0FFh ;
        int 33h        ;
        jmp retry      ;        
         
code32 ends

 END

