#include <conio.h>
#include <dos.h>

void (_interrupt _far *OldKeyboard)();
unsigned char keytab[256];

/* static to make function invisible to other modules */
static void _interrupt _far MyKeyboard(void)
{
   unsigned key;

   key = inp(0x60);
   outp(0x20, 0x20);
   if (key & 0x80)
   {
      keytab[key - 0x80] = 0;
   }
   else
   {
      keytab[key] = 1;
   }
}

void ClearKeys(void)
{
   unsigned x;
   for (x = 0; x < 256; x++) keytab[x] = 0;
}

void InitKeyboard(void)
{
   OldKeyboard = _dos_getvect(9);
   _dos_setvect(9, MyKeyboard);
   ClearKeys();                    /* New function, 0's out keytab */
}

void RestoreKeyboard(void)
{
   _dos_setvect(9, OldKeyboard);
}
